/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.emr.convert.node;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShellNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(RemoteShellNodeConvert.class);
    private static String defaultType = CodeProgramType.SSH.name();

    public RemoteShellNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        this.chooseDataSource(workflowNode, tgtworkflowNode);
        String script = workflowNode.getScript();
        JSONObject scriptJson = JSONObject.parseObject((String)script);
        if (scriptJson.containsKey("type") && scriptJson.containsKey("rawScript") && scriptJson.getString("type").equals(BwmCommonConstant.EmrWorkflow.scriptSourceType.SSH.name())) {
            tgtworkflowNode.setScript(scriptJson.getString("rawScript"));
        } else {
            tgtworkflowNode.setScript("");
            log.info("FILE type script not support");
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void chooseDataSource(WorkflowNode workflowNode, WorkflowNode tgtworkflowNode) {
        try {
            if (StringUtils.isNotBlank((String)workflowNode.getScript())) {
                JSONObject scriptJson = JSONObject.parseObject((String)workflowNode.getScript());
                tgtworkflowNode.setDatasourceId(this.getConnectionName(tgtworkflowNode));
            }
        }
        catch (Exception e) {
            log.error("chooseDataSource error {} {}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
        }
    }

    private String getConnectionName(WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        JSONObject nodeConnectionConf = nodeConfMap.getOrDefault("workflow.converter.connection.mapping", new JSONObject());
        JSONObject sshParam = JSONObject.parseObject((String)workflowNode.getScript());
        if (sshParam != null && sshParam.containsKey("datasource")) {
            WorkflowDatasource datasource;
            Integer datasourceId = sshParam.getInteger("datasource");
            if (this.taskContext.getWorkflowProjectPackage().getDatasources() != null && !this.taskContext.getWorkflowProjectPackage().getDatasources().isEmpty() && (datasource = this.taskContext.getWorkflowProjectPackage().getDatasources().stream().filter(s -> String.valueOf(s.getId()).equals(String.valueOf(datasourceId))).findFirst().orElseGet(null)) != null) {
                if (nodeConnectionConf.containsKey(datasource.getName())) {
                    return nodeConnectionConf.getString(datasource.getName());
                }
                return datasource.getName();
            }
        }
        return null;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.remoteShell.submitAs", defaultType);
        if (orDefault instanceof String) {
            return orDefault;
        }
        return defaultType;
    }
}

