/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.emr.convert.node;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaShellNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(ImpalaShellNodeConvert.class);
    private static String defaultType = CodeProgramType.VIRTUAL.name();

    public ImpalaShellNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        String codeProgramType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(codeProgramType);
        String dbType = CodeProgramType.of((String)codeProgramType).getCalcEngineType().name();
        tgtworkflowNode.setDbType(dbType);
        this.chooseDataSource(workflowNode, tgtworkflowNode, codeProgramType);
        String script = workflowNode.getScript();
        JSONObject scriptJson = JSONObject.parseObject((String)script);
        if (scriptJson.containsKey("type") && scriptJson.containsKey("rawScript") && scriptJson.getString("type").equals(BwmCommonConstant.EmrWorkflow.scriptSourceType.SCRIPT.name())) {
            tgtworkflowNode.setScript(scriptJson.getString("rawScript"));
        } else {
            tgtworkflowNode.setScript("");
            log.info("FILE type script not support");
        }
        if (dbType.equals(CalcEngineType.EMR.name())) {
            tgtworkflowNode.setScript(ImpalaShellNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void chooseDataSource(WorkflowNode workflowNode, WorkflowNode tgtworkflowNode, String codeProgramType) {
        try {
            String sqlParamStr = workflowNode.getCustomProperties().getOrDefault("SQL_PARAM", "").toString();
            if (StringUtils.isNotBlank((String)sqlParamStr)) {
                SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)sqlParamStr, (Type)TypeToken.get(SqlParameters.class).getType());
                tgtworkflowNode.setDatasourceId(this.getConnectionName(parameter, codeProgramType, tgtworkflowNode));
            }
        }
        catch (Exception e) {
            log.error("chooseDataSource error {} {}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
        }
    }

    private String getConnectionName(SqlParameters parameter, String codeProgramType, WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String mappingJson = nodeConfMap.getOrDefault("workflow.converter.connection.mapping", "{}");
        if (StringUtils.isNotEmpty((String)mappingJson)) {
            Map connectionMapping = (Map)JSONUtils.parseObject((String)mappingJson, Map.class);
            if (connectionMapping == null) {
                log.error("parse connection mapping with {} error", (Object)mappingJson);
            } else {
                String connectionName = (String)connectionMapping.get(codeProgramType);
                log.info("Got connectionName {} by {}", (Object)connectionName, (Object)codeProgramType);
                return connectionName;
            }
        }
        if (!CodeProgramType.EMR_HIVE.name().equals(codeProgramType) && !CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            List workflowDatasources = this.taskContext.getWorkflowDatasources();
            if (parameter.getDatasource() > 0) {
                return CollectionUtils.emptyIfNull((Collection)workflowDatasources).stream().filter(s -> s.getDatasourceId().equalsIgnoreCase(String.valueOf(parameter.getDatasource()))).findFirst().map(WorkflowDatasource::getName).orElseGet(null);
            }
        }
        return null;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.impalaShell.submitAs", defaultType);
        if (orDefault instanceof String) {
            return orDefault;
        }
        return defaultType;
    }
}

