/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.interceptor;

import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.annotation.Order;
import com.aliyun.securitysdk.rass.api.interceptor.CheckInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CompositeCheckInterceptor<T extends Permission>
implements CheckInterceptor<T> {
    private List<CheckInterceptor<T>> interceptors = new ArrayList<CheckInterceptor<T>>();

    public CompositeCheckInterceptor(CheckInterceptor<T> ... interceptors) {
        if (interceptors != null && interceptors.length > 0) {
            this.addInterceptors(Arrays.asList(interceptors));
            this.sort();
        }
    }

    private CompositeCheckInterceptor(Collection<CheckInterceptor<T>> interceptors) {
        if (interceptors != null && !interceptors.isEmpty()) {
            this.addInterceptors(interceptors);
            this.sort();
        }
    }

    @Override
    public boolean preCheck(T t) {
        for (CheckInterceptor<T> interceptor : this.interceptors) {
            if (interceptor.preCheck(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void postCheck(T t, CheckResult<?> checkResult) {
        for (CheckInterceptor<T> interceptor : this.interceptors) {
            interceptor.postCheck(t, checkResult);
        }
    }

    public void addInterceptor(CheckInterceptor<T> interceptor) {
        this.interceptors.add(interceptor);
        this.sort();
    }

    public void addInterceptors(Collection<CheckInterceptor<T>> interceptors) {
        this.interceptors.addAll(interceptors);
        this.sort();
    }

    public void removeInterceptor(CheckInterceptor<T> interceptor) {
        this.interceptors.remove(interceptor);
        this.sort();
    }

    public CompositeCheckInterceptor<T> copyWith(CheckInterceptor<T> theInterceptor) {
        CompositeCheckInterceptor<T> compositeCheckInterceptor = new CompositeCheckInterceptor<T>(this.interceptors);
        if (theInterceptor != null) {
            compositeCheckInterceptor.addInterceptor(theInterceptor);
        }
        return compositeCheckInterceptor;
    }

    private void sort() {
        Collections.sort(this.interceptors, new Comparator<CheckInterceptor>(){

            @Override
            public int compare(CheckInterceptor o1, CheckInterceptor o2) {
                return this.getOrderValue(o1) - this.getOrderValue(o2);
            }

            private int getOrderValue(CheckInterceptor interceptor) {
                Order order = interceptor.getClass().getAnnotation(Order.class);
                if (order != null) {
                    return order.value();
                }
                return Integer.MAX_VALUE;
            }
        });
    }
}

