/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.condition.action;

import com.aliyun.securitysdk.rass.api.condition.Action;
import java.util.HashMap;
import java.util.Map;

public enum FileAction implements Action
{
    Write("write", 1),
    Read("read", 2),
    Delete("delete", 4),
    All("file-all", -1);

    private final String name;
    private final byte code;
    private static final Map<String, FileAction> stringToEnum;

    private FileAction(String name, byte code) {
        this.name = name;
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public FileAction toAction(String name) {
        return stringToEnum.get(name);
    }

    static {
        stringToEnum = new HashMap<String, FileAction>();
        for (FileAction item : FileAction.values()) {
            if (stringToEnum.containsKey(item.name())) {
                throw new IllegalArgumentException("Duplicated enums, the values of enums should be unique : " + item.name());
            }
            stringToEnum.put(item.name(), item);
        }
    }
}

