/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.condition;

import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.condition.action.CmiAction;
import com.aliyun.securitysdk.rass.api.condition.action.FileAction;
import com.aliyun.securitysdk.rass.api.condition.action.NetAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Actions {
    private static final Map<String, Action> stringToEnum = new HashMap<String, Action>();

    private static void register(Action ... actions) {
        for (Action item : actions) {
            if (stringToEnum.containsKey(item.getName())) {
                throw new IllegalArgumentException("Duplicated enums, the values of enums should be unique : " + item.getName());
            }
            stringToEnum.put(item.getName(), item);
        }
    }

    public static Action getActionByName(String name) {
        return stringToEnum.get(name);
    }

    public static List<Action> getActionsByNames(List<String> names) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (String name : names) {
            actions.add(Actions.getActionByName(name));
        }
        return actions;
    }

    static {
        Actions.register(CmiAction.values());
        Actions.register(FileAction.values());
        Actions.register(NetAction.values());
    }
}

