/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.pattern;

import com.aliyun.security.shade.org.apache.logging.log4j.core.LogEvent;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.Configuration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.HtmlTextRenderer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.TextRenderer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.ArrayUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.Loader;
import com.aliyun.security.shade.org.apache.logging.log4j.message.Message;
import com.aliyun.security.shade.org.apache.logging.log4j.message.MultiformatMessage;
import com.aliyun.security.shade.org.apache.logging.log4j.status.StatusLogger;
import com.aliyun.security.shade.org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import com.aliyun.security.shade.org.apache.logging.log4j.util.PerformanceSensitive;
import com.aliyun.security.shade.org.apache.logging.log4j.util.StringBuilderFormattable;
import java.util.Locale;

@Plugin(name="MessagePatternConverter", category="Converter")
@ConverterKeys(value={"m", "msg", "message"})
@PerformanceSensitive(value={"allocation"})
public final class MessagePatternConverter
extends LogEventPatternConverter {
    private static final String NOLOOKUPS = "nolookups";
    private final String[] formats;
    private final Configuration config;
    private final TextRenderer textRenderer;

    private MessagePatternConverter(Configuration config, String[] options) {
        super("Message", "message");
        this.formats = options;
        this.config = config;
        int noLookupsIdx = this.loadNoLookups(options);
        this.textRenderer = this.loadMessageRenderer(noLookupsIdx >= 0 ? ArrayUtils.remove(options, noLookupsIdx) : options);
    }

    private int loadNoLookups(String[] options) {
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                String option = options[i];
                if (!NOLOOKUPS.equalsIgnoreCase(option)) continue;
                return i;
            }
        }
        return -1;
    }

    private TextRenderer loadMessageRenderer(String[] options) {
        if (options != null) {
            for (String option : options) {
                switch (option.toUpperCase(Locale.ROOT)) {
                    case "ANSI": {
                        if (Loader.isJansiAvailable()) {
                            return new JAnsiTextRenderer(options, JAnsiTextRenderer.DefaultMessageStyleMap);
                        }
                        StatusLogger.getLogger().warn("You requested ANSI message rendering but JANSI is not on the classpath.");
                        return null;
                    }
                    case "HTML": {
                        return new HtmlTextRenderer(options);
                    }
                }
            }
        }
        return null;
    }

    public static MessagePatternConverter newInstance(Configuration config, String[] options) {
        return new MessagePatternConverter(config, options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        Message msg = event.getMessage();
        if (msg instanceof StringBuilderFormattable) {
            StringBuilder workingBuilder;
            boolean doRender = this.textRenderer != null;
            StringBuilder stringBuilder = workingBuilder = doRender ? new StringBuilder(80) : toAppendTo;
            if (msg instanceof MultiFormatStringBuilderFormattable) {
                ((MultiFormatStringBuilderFormattable)msg).formatTo(this.formats, workingBuilder);
            } else {
                ((StringBuilderFormattable)((Object)msg)).formatTo(workingBuilder);
            }
            if (doRender) {
                this.textRenderer.render(workingBuilder, toAppendTo);
            }
            return;
        }
        if (msg != null) {
            String result = msg instanceof MultiformatMessage ? ((MultiformatMessage)msg).getFormattedMessage(this.formats) : msg.getFormattedMessage();
            if (result != null) {
                toAppendTo.append(result);
            } else {
                toAppendTo.append("null");
            }
        }
    }
}

