/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.jackson;

import com.aliyun.security.shade.org.apache.logging.log4j.Level;
import com.aliyun.security.shade.org.apache.logging.log4j.Marker;
import com.aliyun.security.shade.org.apache.logging.log4j.ThreadContext;
import com.aliyun.security.shade.org.apache.logging.log4j.core.LogEvent;
import com.aliyun.security.shade.org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import com.aliyun.security.shade.org.apache.logging.log4j.core.impl.ThrowableProxy;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.ExtendedStackTraceElementMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.InstantMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.LevelMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.LogEventJsonMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.LogEventWithContextListMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.MarkerMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.MessageSerializer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.MutableThreadContextStackDeserializer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.ObjectMessageSerializer;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.StackTraceElementMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.ThrowableProxyMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.ThrowableProxyWithStacktraceAsStringMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.jackson.ThrowableProxyWithoutStacktraceMixIn;
import com.aliyun.security.shade.org.apache.logging.log4j.core.time.Instant;
import com.aliyun.security.shade.org.apache.logging.log4j.message.Message;
import com.aliyun.security.shade.org.apache.logging.log4j.message.ObjectMessage;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;

class Initializers {
    Initializers() {
    }

    static class SimpleModuleInitializer {
        SimpleModuleInitializer() {
        }

        void initialize(SimpleModule simpleModule, boolean objectMessageAsJsonObject) {
            simpleModule.addDeserializer(StackTraceElement.class, (JsonDeserializer)new Log4jStackTraceElementDeserializer());
            simpleModule.addDeserializer(ThreadContext.ContextStack.class, (JsonDeserializer)new MutableThreadContextStackDeserializer());
            if (objectMessageAsJsonObject) {
                simpleModule.addSerializer(ObjectMessage.class, (JsonSerializer)new ObjectMessageSerializer());
            }
            simpleModule.addSerializer(Message.class, (JsonSerializer)new MessageSerializer());
        }
    }

    static class SetupContextJsonInitializer {
        SetupContextJsonInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventJsonMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }

    static class SetupContextInitializer {
        SetupContextInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventWithContextListMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }
}

