/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.appender;

import com.aliyun.security.shade.org.apache.logging.log4j.core.Filter;
import com.aliyun.security.shade.org.apache.logging.log4j.core.Layout;
import com.aliyun.security.shade.org.apache.logging.log4j.core.LogEvent;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.Configuration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.Property;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.aliyun.security.shade.org.apache.logging.log4j.core.filter.AbstractFilterable;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.Booleans;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.Integers;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@Plugin(name="RandomAccessFile", category="Core", elementType="appender", printObject=true)
public final class RandomAccessFileAppender
extends AbstractOutputStreamAppender<RandomAccessFileManager> {
    private final String fileName;

    private RandomAccessFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, RandomAccessFileManager manager, String filename, boolean ignoreExceptions, boolean immediateFlush, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
        this.fileName = filename;
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent event) {
        ((RandomAccessFileManager)this.getManager()).setEndOfBatch(event.isEndOfBatch());
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getBufferSize() {
        return ((RandomAccessFileManager)this.getManager()).getBufferSize();
    }

    @Deprecated
    public static <B extends Builder<B>> RandomAccessFileAppender createAppender(String fileName, String append, String name, String immediateFlush, String bufferSizeStr, String ignore, Layout<? extends Serializable> layout, Filter filter, Configuration configuration) {
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        int bufferSize = Integers.parseInt(bufferSizeStr, 262144);
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)((Builder)((Builder)((AbstractOutputStreamAppender.Builder)((Builder)RandomAccessFileAppender.newBuilder()).setAppend(isAppend)).withBufferSize(bufferSize)).setConfiguration(configuration)).setFileName(fileName)).setFilter(filter)).setIgnoreExceptions(ignoreExceptions)).withImmediateFlush(isFlush)).setLayout(layout)).setName(name)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements com.aliyun.security.shade.org.apache.logging.log4j.core.util.Builder<RandomAccessFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;

        @Override
        public RandomAccessFileAppender build() {
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for FileAppender");
                return null;
            }
            if (this.fileName == null) {
                LOGGER.error("No filename provided for FileAppender with name " + name);
                return null;
            }
            Layout<Serializable> layout = this.getOrCreateLayout();
            boolean immediateFlush = this.isImmediateFlush();
            RandomAccessFileManager manager = RandomAccessFileManager.getFileManager(this.fileName, this.append, immediateFlush, this.getBufferSize(), layout, null);
            if (manager == null) {
                return null;
            }
            return new RandomAccessFileAppender(name, layout, this.getFilter(), manager, this.fileName, this.isIgnoreExceptions(), immediateFlush, this.getPropertyArray());
        }

        public B setFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Builder)this.asBuilder());
        }

        public B setAppend(boolean append) {
            this.append = append;
            return (B)((Builder)this.asBuilder());
        }
    }
}

