/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.response.common;

import com.aliyun.amp.plugin.annotation.AmpParam;
import com.aliyun.migration.teleport.cloud.response.ApiResponse;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;

public class ApiPageResponse<T>
extends ApiResponse {
    private static final long serialVersionUID = 1L;
    @AmpParam(name="totalCount", description="\u603b\u6570")
    private int totalCount = 0;
    @AmpParam(name="totalPages", description="\u603b\u9875\u6570")
    private int totalPages = 0;
    @AmpParam(name="pageSize", description="\u5206\u9875\u5927\u5c0f")
    private int pageSize = 1;
    @AmpParam(name="pageIndex", description="\u5206\u9875\u53f7")
    private int pageIndex = 1;
    @AmpParam(name="empty", description="\u662f\u5426\u4e3a\u7a7a")
    private boolean empty = true;
    @AmpParam(name="notEmpty", description="\u662f\u5426\u975e\u7a7a")
    private boolean notEmpty = false;
    @AmpParam(name="data", description="\u8fd4\u56de\u6570\u636e")
    private Collection<T> data = Collections.emptyList();

    public static ApiPageResponse buildSuccess() {
        ApiPageResponse response = new ApiPageResponse();
        response.setSuccess(true);
        return response;
    }

    public static ApiPageResponse buildFailure(String errCode, String errMessage) {
        ApiPageResponse response = new ApiPageResponse();
        response.setSuccess(false);
        response.setErrCode(errCode);
        response.setErrMessage(errMessage);
        return response;
    }

    public static <T> ApiPageResponse<T> of(int pageSize, int pageIndex) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(Collections.emptyList());
        response.setTotalCount(0);
        response.setPageSize(pageSize);
        response.setPageIndex(pageIndex);
        return response;
    }

    public static <T> ApiPageResponse<T> of(Collection<T> data, int totalCount, int pageSize, int pageIndex) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(data);
        response.setTotalCount(totalCount);
        response.setPageSize(pageSize);
        response.setPageIndex(pageIndex);
        return response;
    }

    public static <T> ApiPageResponse<T> of(Collection<T> data) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(data);
        response.setTotalCount(data.size());
        response.setPageSize(data.size());
        response.setPageIndex(1);
        return response;
    }

    public static <T> ApiPageResponse<T> of(PageInfo<T> pageInfo) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(pageInfo.getList());
        response.setTotalCount((int)pageInfo.getTotal());
        response.setTotalPages(pageInfo.getPages());
        response.setPageSize(pageInfo.getPageSize());
        response.setPageIndex(pageInfo.getPageNum());
        response.setEmpty(pageInfo.getSize() == 0);
        response.setNotEmpty(pageInfo.getSize() != 0);
        return response;
    }

    public static <T> ApiPageResponse<T> of(Page<T> page) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(page.getRecords());
        response.setTotalCount((int)page.getTotal());
        response.setTotalPages((int)page.getPages());
        response.setPageSize((int)page.getSize());
        response.setPageIndex((int)page.getCurrent());
        response.setEmpty(page.getRecords().isEmpty());
        return response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiPageResponse)) {
            return false;
        }
        ApiPageResponse other = (ApiPageResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.isNotEmpty() != other.isNotEmpty()) {
            return false;
        }
        Collection<T> this$data = this.getData();
        Collection<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiPageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotalCount();
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPageIndex();
        result = result * 59 + (this.isEmpty() ? 79 : 97);
        result = result * 59 + (this.isNotEmpty() ? 79 : 97);
        Collection<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ApiPageResponse(totalCount=" + this.getTotalCount() + ", totalPages=" + this.getTotalPages() + ", pageSize=" + this.getPageSize() + ", pageIndex=" + this.getPageIndex() + ", empty=" + this.isEmpty() + ", notEmpty=" + this.isNotEmpty() + ", data=" + this.getData() + ")";
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    public Collection<T> getData() {
        return this.data;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }
}

