/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowProjectSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowProjectSheetProperties.class);
    private Map<WorkflowProjectSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowProjectSheetColumn, Integer>();
    private Map<WorkflowProjectSheetColumn, Object> propertyValueMap = new HashMap<WorkflowProjectSheetColumn, Object>();

    public WorkflowProjectSheetProperties() {
        for (WorkflowProjectSheetColumn column : WorkflowProjectSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowProjectSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowProjectSheetColumn column = WorkflowProjectSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowProjectSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowProjectSheetColumn column = WorkflowProjectSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return List.of();
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return List.of();
    }

    @Override
    public List<String> getValuesForExcel() {
        return List.of();
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public void setPropertyValue(Map<WorkflowProjectSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowProjectSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(WorkflowProject project) {
        this.setPropertyValue(WorkflowProjectSheetColumn.PROJECT_ID, project.getProjectId());
        this.setPropertyValue(WorkflowProjectSheetColumn.NAME, project.getName());
        this.setPropertyValue(WorkflowProjectSheetColumn.DESCRIPTION, project.getDescription());
    }

    public static enum WorkflowProjectSheetColumn {
        PROJECT_ID("\u9879\u76ee\u7a7a\u95f4ID", false, false, true),
        NAME("\u9879\u76ee\u7a7a\u95f4\u540d\u79f0", false, false, true),
        DESCRIPTION("\u5907\u6ce8", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowProjectSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowProjectSheetColumn of(String colName) {
            for (WorkflowProjectSheetColumn column : WorkflowProjectSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

