/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ResourceUtils {
    public static final String PLACEHOLDER_RES = "res";
    public static final String PLACEHOLDER_FILE_NAME = "placeholder";
    public static final String FILE_EXT_JAR = "jar";
    public static final String FILE_EXT_PY = "py";
    public static final String FILE_EXT_ARCHIVE_ZIP = "zip";
    public static final String FILE_EXT_ARCHIVE_TAR = "tar";
    public static final String FILE_EXT_ARCHIVE_TGZ = "tgz";
    public static final String FILE_EXT_ARCHIVE_TAR_GZ = "tar.gz";
    public static final String FILE_EXT_ARCHIVE_NAR = "nar";
    public static final List<String> FILE_EXT_ARCHIVE = new ArrayList<String>();

    public static String getFileResourceType(String fileName) {
        return ResourceUtils.getFileResourceType(fileName, "odps");
    }

    public static String getFileResourceType(String fileName, String engineType) {
        if (fileName.endsWith(".jar")) {
            return DefaultNodeTypeUtils.getJarResourceType(engineType).name();
        }
        if (fileName.endsWith(".py")) {
            return CodeProgramType.ODPS_PYTHON.name();
        }
        if (FILE_EXT_ARCHIVE.stream().filter(ext -> fileName.endsWith("." + ext)).count() > 0L) {
            return CodeProgramType.ODPS_ARCHIVE.name();
        }
        return DefaultNodeTypeUtils.getFileResourceType(engineType).name();
    }

    public static String getPlaceholderFile(String fileName) {
        if (fileName.endsWith(".jar")) {
            return PLACEHOLDER_RES + File.separator + PLACEHOLDER_FILE_NAME + "." + FILE_EXT_JAR;
        }
        if (fileName.endsWith(".py")) {
            return PLACEHOLDER_RES + File.separator + PLACEHOLDER_FILE_NAME + "." + FILE_EXT_PY;
        }
        if (FILE_EXT_ARCHIVE.stream().filter(ext -> fileName.endsWith("." + ext)).count() > 0L) {
            return PLACEHOLDER_RES + File.separator + PLACEHOLDER_FILE_NAME + "." + FILE_EXT_ARCHIVE_ZIP;
        }
        return PLACEHOLDER_RES + File.separator + PLACEHOLDER_FILE_NAME;
    }

    static {
        FILE_EXT_ARCHIVE.add(FILE_EXT_ARCHIVE_NAR);
        FILE_EXT_ARCHIVE.add(FILE_EXT_ARCHIVE_TAR);
        FILE_EXT_ARCHIVE.add(FILE_EXT_ARCHIVE_TAR_GZ);
        FILE_EXT_ARCHIVE.add(FILE_EXT_ARCHIVE_TGZ);
        FILE_EXT_ARCHIVE.add(FILE_EXT_ARCHIVE_ZIP);
    }
}

