/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.FileNodeCfg;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.FileNodeInputOutput;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.IoParseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeUtils.class);
    private static Pattern NODE_IO_PREFIX_PATTERN = Pattern.compile("^[\\s\\t]*(?<projectIdentifier>[a-zA-Z][0-9A-Za-z\\-_]{2,})(\\..*|_root$)", 2);
    public static Pattern PROJECT_ROOT_OUTPUT_PATTERN = Pattern.compile("^[\\s\\t]*(?<projectIdentifier>[a-zA-Z][0-9A-Za-z\\-_]{2,})(_root$)", 2);
    public static final Pattern IDE_SYSTEM_IO_PATTERN = Pattern.compile("^\\w+\\.\\d+_out$", 2);
    public static final String IDE_SYSTEM_IO_REWRITE_SUFFIX = "_original";
    public static Pattern IDE_CROSS_PROJECT_CLONE_SYSTEM_OUTPUT_PATTERN = Pattern.compile("^(\\d+\\.)+(?<projectIdentifier>[a-zA-Z][0-9A-Za-z\\-_]{2,})\\..*", 2);

    public static String getDefaultNodeOutput(Workflow workflow, Node node) {
        return String.format("%s_%s.out", workflow.getName(), node.getName());
    }

    public static String getProjectRootOutput(Project project) {
        return String.format("%s_root", project.getName());
    }

    public static boolean matchProjectIdentifierIo(String projectIdentifier, String ioStr) {
        if (StringUtils.isBlank((CharSequence)ioStr) || StringUtils.isBlank((CharSequence)projectIdentifier)) {
            return false;
        }
        Pattern normalIoPattern = Pattern.compile("^[\\s\\t]*" + projectIdentifier + "(?<suffix>\\.|_root$)", 2);
        Pattern crossProjectCloneIoPattern = Pattern.compile("^(\\d+\\.)+" + projectIdentifier + "\\..*", 2);
        Matcher m1 = normalIoPattern.matcher(ioStr);
        Matcher m2 = crossProjectCloneIoPattern.matcher(ioStr);
        return m1.find() || m2.matches();
    }

    public static boolean matchIdeSystemIo(String io) {
        return IDE_SYSTEM_IO_PATTERN.matcher(io).matches();
    }

    public static String normalize(String io) {
        if (!NodeUtils.matchIdeSystemIo(io)) {
            return io;
        }
        io = io + IDE_SYSTEM_IO_REWRITE_SUFFIX;
        return io;
    }

    public static String replaceSystemOutputProjectIdentifier(String io, String identifier) {
        if (!NodeUtils.matchIdeSystemIo(io)) {
            return io;
        }
        Object[] tokens = io.split("\\.");
        tokens[0] = identifier;
        return Joiner.on((String)".").join(tokens);
    }

    public static String replaceOutputProjectIdentifier(String io, String identifier) {
        if (StringUtils.isBlank((CharSequence)io)) {
            return io;
        }
        Object[] tokens = io.split("\\.");
        tokens[0] = identifier;
        return Joiner.on((String)".").join(tokens);
    }

    public static void copyPropertiesFromNodeToFileNodeCfg(Node nodeFrom, FileNodeCfg fileNodeCfgTo) {
        fileNodeCfgTo.setNodeName(nodeFrom.getName());
        fileNodeCfgTo.setCronExpress(nodeFrom.getCronExpress());
        fileNodeCfgTo.setReRunAble(nodeFrom.getRerunMode() == null ? RerunMode.ALL_ALLOWED.getValue() : nodeFrom.getRerunMode().getValue());
        fileNodeCfgTo.setIsStop(nodeFrom.getPauseSchedule() != null && nodeFrom.getPauseSchedule() != false ? 1 : 0);
        fileNodeCfgTo.setStartRightNow(nodeFrom.getStartRightNow());
        fileNodeCfgTo.setOwner(nodeFrom.getOwner());
        fileNodeCfgTo.setParaValue(nodeFrom.getParameter());
        fileNodeCfgTo.setStartEffectDate(nodeFrom.getStartEffectDate());
        fileNodeCfgTo.setEndEffectDate(nodeFrom.getEndEffectDate());
        fileNodeCfgTo.setTaskRerunInterval(nodeFrom.getTaskRerunInterval());
        fileNodeCfgTo.setTaskRerunTime(nodeFrom.getTaskRerunTime());
        fileNodeCfgTo.setDependentType(nodeFrom.getDependentType());
        fileNodeCfgTo.setCycleType(nodeFrom.getCycleType());
        fileNodeCfgTo.setIsAutoParse(nodeFrom.getIsAutoParse() == null ? 0 : nodeFrom.getIsAutoParse());
        fileNodeCfgTo.setDescription(nodeFrom.getDescription());
        fileNodeCfgTo.setPriority(nodeFrom.getPriority());
        fileNodeCfgTo.setMultiinstCheckType(nodeFrom.getMultiInstCheckType());
        fileNodeCfgTo.setDependentDataNode(nodeFrom.getDependentDataNode());
        fileNodeCfgTo.setExtConfig(nodeFrom.getExtraConfig());
        ArrayList<FileNodeInputOutput> inputs = new ArrayList<FileNodeInputOutput>();
        for (NodeIo nodeIo : nodeFrom.getInputs()) {
            FileNodeInputOutput input = new FileNodeInputOutput();
            input.setStr(nodeIo.getData());
            input.setRefTableName(nodeIo.getRefTableName());
            input.setParseType(nodeIo.getParseType());
            inputs.add(input);
        }
        ArrayList<FileNodeInputOutput> outputs = new ArrayList<FileNodeInputOutput>();
        for (NodeIo nodeIo : nodeFrom.getOutputs()) {
            FileNodeInputOutput output = new FileNodeInputOutput();
            output.setStr(nodeIo.getData());
            output.setRefTableName(nodeIo.getRefTableName());
            output.setParseType(nodeIo.getParseType());
            outputs.add(output);
        }
        if (inputs.size() > 0) {
            fileNodeCfgTo.setInput(GsonUtils.toJsonString(inputs));
            fileNodeCfgTo.setInputList(inputs);
        }
        if (outputs.size() > 0) {
            fileNodeCfgTo.setOutput(GsonUtils.toJsonString(outputs));
            fileNodeCfgTo.setOutputList(outputs);
        }
    }

    public static void setProjectRootDependencyIfIsolated(Project project, DwWorkflow workflow, Node node) {
        if (CollectionUtils.isEmpty(node.getInputs()) && workflow.getScheduled().booleanValue()) {
            node.setInputs(Arrays.asList(new NodeIo(NodeUtils.getProjectRootOutput(project))));
            ListUtils.emptyIfNull(node.getInputs()).forEach(in -> in.setParseType(1));
        }
    }

    public static DwNode toDwNode(Node node) {
        if (node instanceof DwNode) {
            return (DwNode)node;
        }
        DwNode dwNode = new DwNode();
        BeanUtils.copyProperties((Object)node, (Object)dwNode);
        return dwNode;
    }

    public static boolean isIdeCrossProjectCloneSystemOutput(Integer type, String data, Integer parseType) {
        return StringUtils.isNotBlank((CharSequence)data) && IDE_CROSS_PROJECT_CLONE_SYSTEM_OUTPUT_PATTERN.matcher(data).matches();
    }

    public static void parseNodeDiResGroupInfo(DwNode dwNode) {
        if (!DefaultNodeTypeUtils.isDiNode(dwNode.getType())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)dwNode.getDiResourceGroup())) {
            return;
        }
        String code = dwNode.getCode();
        if (StringUtils.isBlank((CharSequence)code) && StringUtils.isBlank((CharSequence)dwNode.getExtend())) {
            return;
        }
        try {
            String resourceGroup;
            JsonObject extendJson = null;
            JsonObject codeExtendJson = null;
            try {
                extendJson = (JsonObject)GsonUtils.fromJsonString((String)dwNode.getExtend(), JsonObject.class);
                JsonObject codeJson = (JsonObject)GsonUtils.gson.fromJson(code, JsonObject.class);
                if (codeJson == null && extendJson == null) {
                    return;
                }
                if (codeJson != null && codeJson.has("extend")) {
                    codeExtendJson = codeJson.get("extend").getAsJsonObject();
                }
            }
            catch (Exception e) {
                LOGGER.warn("parse extend failed, extend json: {}", (Object)dwNode.getExtend(), (Object)e);
            }
            if (extendJson != null && extendJson.has("resourceGroup")) {
                resourceGroup = extendJson.get("resourceGroup").getAsString();
                dwNode.setDiResourceGroup(resourceGroup);
                dwNode.setDiResourceGroupName(resourceGroup);
                return;
            }
            if (codeExtendJson != null && codeExtendJson.has("resourceGroup")) {
                resourceGroup = codeExtendJson.get("resourceGroup").getAsString();
                dwNode.setDiResourceGroup(resourceGroup);
                dwNode.setDiResourceGroupName(resourceGroup);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String normalizedFileName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return name.replaceAll(":", "_").replaceAll("-", "_").replaceAll("\\*", "_").replaceAll("\\\\", "_").replaceAll("\\+", "_").replaceAll("%", "_").replaceAll("/", "_").replaceAll("=", "_").replaceAll("&", "_").replaceAll("#", "_").replaceAll("@", "_").replaceAll("!", "_").replaceAll("~", "_").replaceAll("`", "_").replaceAll("\\$", "_").replaceAll("\\^", "_").replaceAll("\\[", "__").replaceAll("]", "__").replaceAll("\\{", "__").replaceAll("}", "__").replaceAll("\\(", "__").replaceAll("\\)", "__");
    }

    public static boolean isEmrNode(String type) {
        CodeProgramType defaultNodeType = DefaultNodeTypeUtils.getTypeByName(type, null);
        if (defaultNodeType == null) {
            return false;
        }
        switch (defaultNodeType) {
            case EMR_SHELL: 
            case EMR_HIVE: 
            case EMR_SPARK: 
            case EMR_SPARK_SQL: 
            case EMR_PRESTO: 
            case EMR_SPARK_SHELL: 
            case EMR_IMPALA: 
            case EMR_MR: 
            case EMR_HIVE_CLI: 
            case EMR_SCOOP: 
            case EMR_STREAMING_SQL: 
            case EMR_SPARK_STREAMING: {
                return true;
            }
        }
        return false;
    }

    public static String getProjectIdentifierPrefix(String io) {
        Matcher matcher;
        String data = (String)StringUtils.defaultIfBlank((CharSequence)io, (CharSequence)"");
        if (NODE_IO_PREFIX_PATTERN.matcher(data).matches() && (matcher = NODE_IO_PREFIX_PATTERN.matcher(data)).find()) {
            return matcher.group("projectIdentifier");
        }
        return null;
    }

    public static boolean matchNodeIoProjectDependency(String io) {
        String data = (String)StringUtils.defaultIfBlank((CharSequence)io, (CharSequence)"");
        return NODE_IO_PREFIX_PATTERN.matcher(data).matches();
    }

    public static String replaceBranchNodeCodeIoPrefix(CodeProgramType type, String code, Map<String, String> prefixMapping) {
        if (!CodeProgramType.CONTROLLER_BRANCH.equals((Object)type)) {
            return code;
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return code;
        }
        try {
            JsonArray json = (JsonArray)GsonUtils.fromJsonString((String)code, JsonArray.class);
            if (json == null) {
                LOGGER.warn("failed to parse branch node code json: {}", (Object)code);
                return code;
            }
            boolean replaced = false;
            for (int i = 0; i < json.size(); ++i) {
                JsonObject condition = json.get(i).getAsJsonObject();
                if (!condition.has("nodeoutput")) continue;
                String out = condition.get("nodeoutput").getAsString();
                String oldPrefix = NodeUtils.getProjectIdentifierPrefix(out);
                String targetPrefix = (String)MapUtils.emptyIfNull(prefixMapping).get(oldPrefix);
                if (!StringUtils.isNotBlank((CharSequence)targetPrefix)) continue;
                condition.addProperty("nodeoutput", NodeUtils.normalize(NodeUtils.replaceOutputProjectIdentifier(out, targetPrefix)));
                replaced = true;
                json.set(i, (JsonElement)condition);
            }
            if (replaced) {
                return GsonUtils.defaultGson.toJson((JsonElement)json);
            }
            return code;
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return code;
        }
    }

    public static String replaceJoinNodeCodeIoPrefix(CodeProgramType type, String code, Map<String, String> prefixMapping) {
        if (!CodeProgramType.CONTROLLER_JOIN.equals((Object)type)) {
            return code;
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return code;
        }
        try {
            JsonObject json = (JsonObject)GsonUtils.fromJsonString((String)code, JsonObject.class);
            if (json == null) {
                LOGGER.error("failed to parse join node code json: {}", (Object)code);
                return code;
            }
            JsonArray branchList = json.has("branchList") ? (JsonArray)GsonUtils.fromJsonString((String)json.get("branchList").getAsString(), JsonArray.class) : new JsonArray();
            boolean replaced = false;
            for (int i = 0; i < branchList.size(); ++i) {
                String out;
                String oldPrefix;
                String targetPrefix;
                JsonObject condition = branchList.get(i).getAsJsonObject();
                if (!condition.has("node") || !StringUtils.isNotBlank((CharSequence)(targetPrefix = prefixMapping.get(oldPrefix = NodeUtils.getProjectIdentifierPrefix(out = condition.get("node").getAsString()))))) continue;
                condition.addProperty("node", NodeUtils.normalize(NodeUtils.replaceOutputProjectIdentifier(out, targetPrefix)));
                replaced = true;
                branchList.set(i, (JsonElement)condition);
            }
            json.addProperty("branchList", GsonUtils.toJsonString((Object)branchList));
            if (replaced) {
                return GsonUtils.defaultGson.toJson((JsonElement)json);
            }
            return code;
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return code;
        }
    }

    public static boolean matchIdeNodeNameOutput(String nodeName, String data, Integer parseType) {
        Pattern pattern = Pattern.compile("^\\w+\\." + nodeName + "$", 2);
        return IoParseType.MANUAL.getCode().equals(parseType) && pattern.matcher(data).matches();
    }

    public static boolean matchProjectOutput(String data) {
        return PROJECT_ROOT_OUTPUT_PATTERN.matcher(data).matches();
    }
}

