/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecParamHub;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamHubNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(ParamHubNodeSpecHandler.class);

    @Override
    public boolean support(DwNodeEntity nodeEntity) {
        return this.matchNodeType(nodeEntity, CodeProgramType.PARAM_HUB);
    }

    @Override
    public SpecNode handle(DwNodeEntity orcNode) {
        Preconditions.checkArgument((orcNode != null ? 1 : 0) != 0);
        SpecNode specNode = super.handle(orcNode);
        specNode.setParamHub(this.buildParamHub(orcNode, specNode));
        return specNode;
    }

    private SpecParamHub buildParamHub(DwNodeEntity orcNode, SpecNode specNode) {
        SpecParserContext ctx = new SpecParserContext();
        ctx.setVersion(SpecVersion.V_1_1_0.getLabel());
        return Optional.ofNullable(orcNode.getCode()).filter(StringUtils::isNotBlank).map(code -> Optional.ofNullable(JSON.parseObject((String)code)).orElse(new JSONObject())).map(code -> (SpecParamHub)SpecDevUtil.getObjectByParser(SpecParamHub.class, (Object)code, (SpecParserContext)ctx)).map(paramHub -> {
            ListUtils.emptyIfNull((List)paramHub.getVariables()).stream().filter(var -> VariableType.PASS_THROUGH.equals((Object)var.getType())).forEach(var -> var.setValue(Optional.ofNullable(var.getReferenceVariable()).filter(refVar -> refVar.getNode() != null && refVar.getNode().getOutput() != null && StringUtils.isNotBlank((CharSequence)refVar.getNode().getOutput().getData()) && StringUtils.isNotBlank((CharSequence)refVar.getName())).map(refVar -> Joiner.on((String)":").join((Object)refVar.getNode().getOutput().getData(), (Object)refVar.getName(), new Object[0])).orElse(var.getValue())));
            return paramHub;
        }).orElseGet(() -> {
            SpecParamHub hub = new SpecParamHub();
            hub.setVariables(ListUtils.emptyIfNull((List)specNode.getOutputs()).stream().filter(out -> out instanceof SpecVariable).map(out -> (SpecVariable)out).collect(Collectors.toList()));
            return hub;
        });
    }
}

