/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModelFactory;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecAssertIn;
import com.aliyun.dataworks.common.spec.domain.noref.SpecAssertion;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoin;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoinBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecLogic;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(JoinNodeSpecHandler.class);
    public static final Integer LOGIC_OR = 0;
    public static final Integer LOGIC_AND = 1;
    public static final String SPEC_JOIN_BRANCH_NAME_PREFIX = "b_";
    public static final String SPEC_JOIN_LOGIC_OPERATOR_AND = "and";
    public static final String SPEC_JOIN_LOGIC_OPERATOR_OR = "or";

    @Override
    public boolean support(DwNodeEntity dwNode) {
        return this.matchNodeType(dwNode, CodeProgramType.CONTROLLER_JOIN);
    }

    @Override
    public SpecNode handle(DwNodeEntity dmNodeBo) {
        Preconditions.checkNotNull((Object)dmNodeBo, (Object)"node is null");
        SpecNode specNode = super.handle(dmNodeBo);
        specNode.setJoin(this.buildJoin(dmNodeBo, this.context));
        return specNode;
    }

    private SpecJoin buildJoin(DwNodeEntity getNodeSpecBO, SpecHandlerContext dwContext) {
        SpecJoin specJoin = new SpecJoin();
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)CodeProgramType.CONTROLLER_JOIN.name(), (String)getNodeSpecBO.getCode());
        List branches = ListUtils.emptyIfNull((List)Optional.ofNullable((ControllerJoinCode)codeModel.getCodeModel()).map(ControllerJoinCode::getBranchList).orElse(null));
        AtomicInteger branchIndex = new AtomicInteger(0);
        AtomicReference<String> logicExpress = new AtomicReference<String>("");
        specJoin.setBranches(ListUtils.emptyIfNull((List)branches).stream().map(branch -> {
            Integer index = branchIndex.incrementAndGet();
            SpecJoinBranch specJoinBranch = new SpecJoinBranch();
            specJoinBranch.setName(SPEC_JOIN_BRANCH_NAME_PREFIX + index);
            SpecNodeOutput output = new SpecNodeOutput();
            output.setData(branch.getNode());
            specJoinBranch.setOutput(output);
            SpecAssertion assertion = new SpecAssertion();
            assertion.setField("status");
            SpecAssertIn in = new SpecAssertIn();
            in.setValue(new ArrayList(ListUtils.emptyIfNull((List)branch.getRunStatus())));
            assertion.setIn(in);
            specJoinBranch.setAssertion(assertion);
            if (index.equals(1)) {
                logicExpress.set(specJoinBranch.getName());
            } else {
                String op = LOGIC_AND.equals(branch.getLogic()) ? SPEC_JOIN_LOGIC_OPERATOR_AND : SPEC_JOIN_LOGIC_OPERATOR_OR;
                logicExpress.set(Joiner.on((String)" ").join(logicExpress.get(), (Object)op, new Object[]{specJoinBranch.getName()}));
            }
            return specJoinBranch;
        }).collect(Collectors.toList()));
        log.info("logic expression: {}", (Object)logicExpress.get());
        SpecLogic logic = new SpecLogic();
        logic.setExpression(logicExpress.get());
        specJoin.setLogic(logic);
        specJoin.setResultStatus((String)Optional.ofNullable((ControllerJoinCode)codeModel.getCodeModel()).map(ControllerJoinCode::getResultStatus).orElse(null));
        return specJoin;
    }
}

