/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecForEach;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeachNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(ForeachNodeSpecHandler.class);
    public static final String TRAVERSE_INPUT_VARIABLE_NAME = "loopDataArray";

    @Override
    public boolean support(DwNodeEntity dwNode) {
        return this.matchNodeType(dwNode, CodeProgramType.CONTROLLER_TRAVERSE);
    }

    @Override
    public SpecNode handle(DwNodeEntity orcNode) {
        Preconditions.checkNotNull((Object)orcNode, (Object)"node is null");
        SpecNode specNode = super.handle(orcNode);
        if (this.support(orcNode)) {
            List<DwNodeEntity> innerNodes = this.getInnerNodes(orcNode);
            specNode.setForeach(this.buildForEach(orcNode, specNode, innerNodes, this.context));
        }
        return specNode;
    }

    public SpecNode handle(DwNodeEntity parentNode, List<DwNodeEntity> innerNodes) {
        Preconditions.checkNotNull((Object)parentNode, (Object)"node is null");
        SpecNode specNode = super.handle(parentNode);
        if (this.support(parentNode)) {
            specNode.setForeach(this.buildForEach(parentNode, specNode, innerNodes, this.context));
        }
        return specNode;
    }

    private SpecForEach buildForEach(DwNodeEntity orcNode, SpecNode specNode, List<DwNodeEntity> innerNodes, SpecHandlerContext context) {
        SpecForEach specForEach = new SpecForEach();
        specForEach.setNodes(innerNodes.stream().map(n -> (SpecNode)this.getSpecAdapter().getHandler(n, context.getLocale()).handle(n)).collect(Collectors.toList()));
        specForEach.setMaxIterations(orcNode.getLoopCount());
        specForEach.setFlow(innerNodes.stream().map(node -> this.getSpecAdapter().toFlow(this, (DwNodeEntity)node, context)).flatMap(Collection::stream).collect(Collectors.toList()));
        ListUtils.emptyIfNull((List)Optional.ofNullable(specNode.getScript()).map(SpecScript::getParameters).orElse(null)).stream().filter(Objects::nonNull).filter(in -> StringUtils.equals((CharSequence)TRAVERSE_INPUT_VARIABLE_NAME, (CharSequence)in.getName())).findFirst().ifPresent(in -> {
            specForEach.setArray(in);
            specNode.getInputs().remove(in);
        });
        return specForEach;
    }
}

