/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDoWhile;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowhileNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(DowhileNodeSpecHandler.class);

    @Override
    public boolean support(DwNodeEntity node) {
        return this.matchNodeType(node, CodeProgramType.CONTROLLER_CYCLE);
    }

    @Override
    public SpecNode handle(DwNodeEntity dmNodeBo) {
        Preconditions.checkNotNull((Object)dmNodeBo, (Object)"node is null");
        SpecNode specNode = super.handle(dmNodeBo);
        if (this.support(dmNodeBo)) {
            List<DwNodeEntity> innerNodes = this.getInnerNodes(dmNodeBo);
            specNode.setDoWhile(this.buildDoWhile(dmNodeBo, innerNodes, this.context));
        }
        return specNode;
    }

    public SpecNode handle(DwNodeEntity parentNode, List<DwNodeEntity> innerNodes) {
        Preconditions.checkNotNull((Object)parentNode, (Object)"node is null");
        SpecNode specNode = super.handle(parentNode);
        if (this.support(parentNode)) {
            specNode.setDoWhile(this.buildDoWhile(parentNode, innerNodes, this.context));
        }
        return specNode;
    }

    private SpecDoWhile buildDoWhile(DwNodeEntity orcNode, List<DwNodeEntity> innerNodes, SpecHandlerContext context) {
        SpecDoWhile specDoWhile = new SpecDoWhile();
        specDoWhile.setMaxIterations(orcNode.getLoopCount());
        specDoWhile.setNodes(innerNodes.stream().map(n -> (SpecNode)this.getSpecAdapter().getHandler(n, context.getLocale()).handle(n)).filter(n -> !StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.CONTROLLER_CYCLE_END.name(), (CharSequence)Optional.ofNullable(n).map(SpecNode::getScript).map(SpecScript::getRuntime).map(SpecScriptRuntime::getCommand).orElse(null))).collect(Collectors.toList()));
        specDoWhile.setSpecWhile((SpecNode)innerNodes.stream().map(n -> (SpecNode)this.getSpecAdapter().getHandler(n, context.getLocale()).handle(n)).filter(n -> StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.CONTROLLER_CYCLE_END.name(), (CharSequence)Optional.ofNullable(n).map(SpecNode::getScript).map(SpecScript::getRuntime).map(SpecScriptRuntime::getCommand).orElse(null))).findFirst().orElse(null));
        specDoWhile.setFlow(innerNodes.stream().map(node -> this.getSpecAdapter().toFlow(this, (DwNodeEntity)node, context)).flatMap(Collection::stream).collect(Collectors.toList()));
        return specDoWhile;
    }
}

