/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeInstanceModeType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRecurrenceType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRerunModeType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.enums.TriggerType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.NodeIO;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecRuntimeResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.container.SpecContainer;
import com.aliyun.dataworks.common.spec.utils.JSONUtils;
import com.aliyun.dataworks.common.spec.utils.ReflectUtils;
import com.aliyun.dataworks.common.spec.utils.VariableUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.NodeType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.DependentType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.IoParseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.migrationx.common.utils.DateUtils;
import com.aliyun.migrationx.common.utils.UuidUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSpecUpdateAdapter {
    private static final Logger log = LoggerFactory.getLogger(NodeSpecUpdateAdapter.class);

    public void updateSpecification(DwNodeEntity dwNode, Specification<DataWorksWorkflowSpec> specification) {
        specification.setVersion(SpecVersion.V_1_1_0.getLabel());
        specification.setKind(Optional.ofNullable(dwNode.getNodeUseType()).map(useType -> {
            switch (useType) {
                case MANUAL: {
                    return SpecKind.MANUAL_NODE.getLabel();
                }
                case MANUAL_WORKFLOW: {
                    return SpecKind.MANUAL_WORKFLOW.getLabel();
                }
                case COMPONENT: {
                    return SpecKind.COMPONENT.getLabel();
                }
            }
            return SpecKind.CYCLE_WORKFLOW.getLabel();
        }).orElse(SpecKind.CYCLE_WORKFLOW.getLabel()));
        Map metadata = (Map)ObjectUtils.defaultIfNull((Object)specification.getMetadata(), new LinkedHashMap());
        Optional.ofNullable(dwNode.getOwner()).ifPresent(owner -> metadata.put("owner", owner));
        Optional.ofNullable(dwNode.getUuid()).ifPresent(uuid -> metadata.put("uuid", uuid));
        Optional.ofNullable(dwNode.getParentId()).ifPresent(containerId -> metadata.put("containerId", String.valueOf(containerId)));
        specification.setMetadata(metadata);
        DataWorksWorkflowSpec spec = (DataWorksWorkflowSpec)ObjectUtils.defaultIfNull((Object)((DataWorksWorkflowSpec)specification.getSpec()), (Object)new DataWorksWorkflowSpec());
        Optional.ofNullable(dwNode.getBizId()).filter(id -> id > 0L).map(String::valueOf).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setId(arg_0));
        Optional.ofNullable(dwNode.getBizName()).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setName(arg_0));
        specification.setSpec((Spec)spec);
        SpecNode specNode = ListUtils.emptyIfNull((List)spec.getNodes()).stream().findFirst().orElseGet(SpecNode::new);
        spec.setNodes(Collections.singletonList(specNode));
        SpecFlowDepend specFlowDepend = ListUtils.emptyIfNull((List)spec.getFlow()).stream().filter(dependence -> StringUtils.equals((CharSequence)specNode.getId(), (CharSequence)Optional.ofNullable(dependence.getNodeId()).map(SpecRefEntity::getId).orElse(null))).findFirst().orElseGet(() -> {
            SpecFlowDepend dependence = new SpecFlowDepend();
            dependence.setNodeId(specNode);
            return dependence;
        });
        spec.setFlow(Collections.singletonList(specFlowDepend));
        this.fillSpecNode(dwNode, specNode);
        this.fillSpecFlowDepend(dwNode, specNode, specFlowDepend);
        log.info("specification: {}", specification);
    }

    private void fillSpecNode(DwNodeEntity dwNode, SpecNode specNode) {
        SpecScript script = (SpecScript)ObjectUtils.defaultIfNull((Object)specNode.getScript(), (Object)new SpecScript());
        SpecTrigger trigger = (SpecTrigger)ObjectUtils.defaultIfNull((Object)specNode.getTrigger(), (Object)new SpecTrigger());
        specNode.setScript(script);
        specNode.setTrigger(trigger);
        this.fillSpecNodeBasicInfo(dwNode, specNode);
        this.fillSpecScript(dwNode, script, specNode);
        this.fillTrigger(dwNode, trigger);
        this.fillResourceGroup(dwNode, specNode);
        this.fillDatasource(dwNode, specNode);
        this.fillInputs(dwNode, specNode, script);
        this.fillOutputs(dwNode, specNode);
    }

    private void fillInputs(DwNodeEntity dwNode, SpecNode specNode, SpecScript script) {
        List inputList = (List)ObjectUtils.defaultIfNull((Object)specNode.getInputs(), new ArrayList());
        specNode.setInputs(inputList);
        List specVariableList = (List)ObjectUtils.defaultIfNull((Object)script.getParameters(), new ArrayList());
        script.setParameters(specVariableList);
        if (dwNode.getInputs() != null) {
            inputList.removeIf(input -> input == null || input instanceof SpecNodeOutput);
            inputList.addAll(this.toNodeIos(dwNode.getInputs()));
        }
        if (dwNode.getInputContexts() != null) {
            inputList.removeIf(input -> input == null || input instanceof SpecVariable);
            specVariableList.removeIf(v -> v == null || VariableScopeType.NODE_CONTEXT.equals((Object)v.getScope()));
            SpecDepend specDepend = new SpecDepend();
            specDepend.setNodeId(specNode);
            List inputVariables = dwNode.getInputContexts().stream().map(inCtx -> {
                SpecVariable specVariable = new SpecVariable();
                specVariable.setScope(VariableScopeType.NODE_CONTEXT);
                specVariable.setType(this.convertParamType(inCtx.getParamType()));
                specVariable.setName(inCtx.getParamName());
                specVariable.setDescription(inCtx.getDescription());
                String[] kv = StringUtils.split((String)inCtx.getParamValue(), (String)":");
                if (kv != null && kv.length == 2) {
                    String output = kv[0];
                    SpecVariable ref = new SpecVariable();
                    SpecDepend refNode = new SpecDepend();
                    SpecNodeOutput o = new SpecNodeOutput();
                    o.setData(output);
                    refNode.setOutput(o);
                    ref.setNode(refNode);
                    ref.setName(kv[1]);
                    ref.setType(VariableType.NODE_OUTPUT);
                    ref.setScope(VariableScopeType.NODE_CONTEXT);
                    specVariable.setReferenceVariable(ref);
                } else {
                    log.warn("invalid input context value: {}", inCtx);
                }
                specVariable.setNode(specDepend);
                return specVariable;
            }).collect(Collectors.toList());
            inputVariables.stream().map(SpecVariable.class::cast).forEach(specVariableList::add);
            ListUtils.emptyIfNull(inputVariables).stream().map(v -> (SpecVariable)v).map(SpecVariable::getReferenceVariable).filter(Objects::nonNull).forEach(inputList::add);
        }
    }

    private void fillOutputs(DwNodeEntity dwNode, SpecNode specNode) {
        List outputList = (List)ObjectUtils.defaultIfNull((Object)specNode.getOutputs(), new ArrayList());
        specNode.setOutputs(outputList);
        if (dwNode.getOutputs() != null) {
            outputList.removeIf(output -> output == null || output instanceof SpecNodeOutput);
            outputList.addAll(this.toNodeIos(dwNode.getOutputs()));
        }
        if (dwNode.getOutputContexts() != null) {
            outputList.removeIf(output -> output == null || output instanceof SpecVariable);
            SpecDepend specDepend = new SpecDepend();
            specDepend.setNodeId(specNode);
            dwNode.getOutputContexts().stream().map(outCtx -> {
                SpecVariable specVariable = new SpecVariable();
                specVariable.setScope(VariableScopeType.NODE_CONTEXT);
                specVariable.setType(this.convertParamType(outCtx.getParamType()));
                specVariable.setName(outCtx.getParamName());
                specVariable.setValue(outCtx.getParamValue());
                specVariable.setNode(specDepend);
                specVariable.setDescription(outCtx.getDescription());
                return specVariable;
            }).forEach(outputList::add);
        }
    }

    private <T extends NodeIO> List<T> toNodeIos(List<NodeIo> ios) {
        return ListUtils.emptyIfNull(ios).stream().map(out -> {
            SpecNodeOutput a = new SpecNodeOutput();
            a.setArtifactType(ArtifactType.NODE_OUTPUT);
            a.setData(out.getData());
            a.setRefTableName(out.getRefTableName());
            a.setIsDefault(Boolean.valueOf(Objects.equals(IoParseType.SYSTEM.getCode(), out.getParseType())));
            return a;
        }).collect(Collectors.toList());
    }

    private void fillResourceGroup(DwNodeEntity dwNode, SpecNode specNode) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getResourceGroup())) {
            SpecRuntimeResource specRuntimeResource = new SpecRuntimeResource();
            specRuntimeResource.setResourceGroup(dwNode.getResourceGroup());
            specNode.setRuntimeResource(specRuntimeResource);
        }
    }

    private void fillDatasource(DwNodeEntity dwNode, SpecNode specNode) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getConnection())) {
            SpecDatasource specDatasource = new SpecDatasource();
            specDatasource.setName(dwNode.getConnection());
            specNode.setDatasource(specDatasource);
        }
    }

    private void fillTrigger(DwNodeEntity dwNode, SpecTrigger trigger) {
        NodeUseType useType = dwNode.getNodeUseType();
        switch (useType) {
            case SKIP: 
            case SCHEDULED: {
                Optional.ofNullable(dwNode.getStartEffectDate()).map(DateUtils::convertDateToString).ifPresent(arg_0 -> ((SpecTrigger)trigger).setStartTime(arg_0));
                Optional.ofNullable(dwNode.getEndEffectDate()).map(DateUtils::convertDateToString).ifPresent(arg_0 -> ((SpecTrigger)trigger).setEndTime(arg_0));
                Optional.ofNullable(dwNode.getCronExpress()).map(String::trim).ifPresent(arg_0 -> ((SpecTrigger)trigger).setCron(arg_0));
                Optional.ofNullable(dwNode.getCalendarId()).ifPresent(arg_0 -> ((SpecTrigger)trigger).setCalendarId(arg_0));
                trigger.setType(TriggerType.SCHEDULER);
                trigger.setTimezone(ZoneId.systemDefault().getId());
                break;
            }
            default: {
                trigger.setType(TriggerType.MANUAL);
            }
        }
    }

    private void fillSpecNodeBasicInfo(DwNodeEntity dwNode, SpecNode specNode) {
        String id = Optional.ofNullable(dwNode.getUuid()).orElseGet(UuidUtils::genUuidWithoutHorizontalLine);
        specNode.setId(id);
        Optional.ofNullable(dwNode.getName()).ifPresent(arg_0 -> ((SpecNode)specNode).setName(arg_0));
        Optional.ofNullable(dwNode.getDescription()).ifPresent(arg_0 -> ((SpecNode)specNode).setDescription(arg_0));
        Optional.ofNullable(dwNode.getOwner()).ifPresent(arg_0 -> ((SpecNode)specNode).setOwner(arg_0));
        Optional.ofNullable(dwNode.getAlisaTaskKillTimeout()).ifPresent(arg_0 -> ((SpecNode)specNode).setTimeout(arg_0));
        Optional.ofNullable(dwNode.getTaskRerunTime()).ifPresent(arg_0 -> ((SpecNode)specNode).setRerunTimes(arg_0));
        Optional.ofNullable(dwNode.getTaskRerunInterval()).ifPresent(arg_0 -> ((SpecNode)specNode).setRerunInterval(arg_0));
        Optional.ofNullable(dwNode.getRerunMode()).map(this::convertRerunMode).ifPresent(arg_0 -> ((SpecNode)specNode).setRerunMode(arg_0));
        Optional.ofNullable(dwNode.getNodeType()).map(this::convertRecurrence).ifPresent(arg_0 -> ((SpecNode)specNode).setRecurrence(arg_0));
        Optional.ofNullable(dwNode.getPauseSchedule()).filter(BooleanUtils::isTrue).ifPresent(ignore -> specNode.setRecurrence(NodeRecurrenceType.PAUSE));
        Optional.ofNullable(dwNode.getNodeUseType()).filter(NodeUseType.SKIP::equals).ifPresent(ignore -> specNode.setRecurrence(NodeRecurrenceType.SKIP));
        Optional.ofNullable(dwNode.getStartRightNow()).map(startRightNow -> startRightNow != false ? NodeInstanceModeType.IMMEDIATELY : NodeInstanceModeType.T_PLUS_1).ifPresent(arg_0 -> ((SpecNode)specNode).setInstanceMode(arg_0));
        Optional.ofNullable(dwNode.getIsAutoParse()).map(auto -> Objects.equals(auto, 1)).ifPresent(arg_0 -> ((SpecNode)specNode).setAutoParse(arg_0));
        Optional.ofNullable(dwNode.getIgnoreBranchConditionSkip()).ifPresent(arg_0 -> ((SpecNode)specNode).setIgnoreBranchConditionSkip(arg_0));
    }

    private void fillSpecScript(DwNodeEntity dwNode, SpecScript script, SpecNode specNode) {
        Optional.ofNullable(dwNode.getFolder()).map(path -> FilenameUtils.concat((String)path, (String)specNode.getName())).ifPresent(arg_0 -> ((SpecScript)script).setPath(arg_0));
        if (script.getPath() == null || !StringUtils.equals((CharSequence)FilenameUtils.getName((String)script.getPath()), (CharSequence)specNode.getName())) {
            String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)script.getPath());
            script.setPath(FilenameUtils.concat((String)parentPath, (String)specNode.getName()));
        }
        Optional.ofNullable(dwNode.getCode()).ifPresent(arg_0 -> ((SpecScript)script).setContent(arg_0));
        this.fillScriptParam(dwNode, script);
        this.fillSpecScriptRuntime(dwNode, script);
    }

    private void fillSpecScriptRuntime(DwNodeEntity dwNode, SpecScript script) {
        SpecScriptRuntime runtime = (SpecScriptRuntime)ObjectUtils.defaultIfNull((Object)script.getRuntime(), (Object)new SpecScriptRuntime());
        script.setRuntime(runtime);
        Optional.ofNullable(dwNode.getType()).map(CodeProgramType::getNodeTypeByName).ifPresent(codeProgramType -> {
            runtime.setCommand(codeProgramType.name());
            runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        });
        Optional.ofNullable(dwNode.getTypeId()).ifPresent(arg_0 -> ((SpecScriptRuntime)runtime).setCommandTypeId(arg_0));
        Optional.ofNullable(dwNode.getCu()).ifPresent(arg_0 -> ((SpecScriptRuntime)runtime).setCu(arg_0));
        Optional.ofNullable(dwNode.getImageId()).ifPresent(imageId -> {
            SpecContainer specContainer = Optional.ofNullable(runtime.getContainer()).orElseGet(SpecContainer::new);
            runtime.setContainer(specContainer);
            specContainer.setImageId(imageId);
        });
        this.parseAdvancedSettings(dwNode.getAdvanceSettings(), dwNode.getStreamLaunchMode(), runtime);
    }

    private void parseAdvancedSettings(String advancedSettings, Integer startImmediately, SpecScriptRuntime runtime) {
        String command = runtime.getCommand();
        if (CodeProgramType.EMR_SPARK_STREAMING.getName().equalsIgnoreCase(command) || CodeProgramType.EMR_STREAMING_SQL.getName().equalsIgnoreCase(command)) {
            if (StringUtils.isNotBlank((CharSequence)advancedSettings)) {
                this.parseEmrCode(runtime, advancedSettings);
            }
            if (startImmediately != null) {
                if (MapUtils.isEmpty((Map)runtime.getStreamJobConfig())) {
                    runtime.setStreamJobConfig(new HashMap());
                }
                runtime.getStreamJobConfig().put("streamLaunchMode", startImmediately);
            }
        }
    }

    private void parseEmrCode(SpecScriptRuntime specScriptRuntime, String code) {
        Map allocSpecMap = (Map)JSONUtils.parseObject((String)code, (TypeReference)new TypeReference<Map<String, Object>>(){});
        EmrAllocationSpec allocSpec = EmrAllocationSpec.of((Map)allocSpecMap);
        if (allocSpec != null) {
            Map emrJobConfig = Optional.ofNullable(specScriptRuntime).map(SpecScriptRuntime::getEmrJobConfig).orElseGet(() -> {
                HashMap emrJobConfigMap = new HashMap();
                Optional.ofNullable(specScriptRuntime).ifPresent(runtime -> runtime.setEmrJobConfig(emrJobConfigMap));
                return emrJobConfigMap;
            });
            emrJobConfig.put("priority", allocSpec.getPriority());
            emrJobConfig.put("cores", allocSpec.getVcores());
            emrJobConfig.put("memory", allocSpec.getMemory());
            emrJobConfig.put("queue", allocSpec.getQueue());
            emrJobConfig.put("submitter", allocSpec.getUserName());
            Optional.ofNullable(allocSpec.getDataworksSessionDisable()).ifPresent(disable -> emrJobConfig.put("DATAWORKS_SESSION_DISABLE", disable));
            Optional.ofNullable(allocSpec.getEnableJdbcSql()).ifPresent(enable -> emrJobConfig.put("ENABLE_SPARKSQL_JDBC", enable));
            Optional.ofNullable(allocSpec.getReuseSession()).ifPresent(reuse -> emrJobConfig.put("REUSE_SESSION", reuse));
            Optional.ofNullable(allocSpec.getUseGateway()).ifPresent(useGateway -> emrJobConfig.put("USE_GATEWAY", useGateway));
            Optional.ofNullable(allocSpec.getBatchMode()).ifPresent(batchMode -> emrJobConfig.put("FLOW_SKIP_SQL_ANALYZE", batchMode));
        }
        Optional.ofNullable(allocSpecMap).map(Map::entrySet).orElse(Collections.emptySet()).stream().filter(ent -> ReflectUtils.getPropertyFields((Object)allocSpec).stream().noneMatch(f -> f.getName().equals(ent.getKey()))).filter(ent -> !EmrAllocationSpec.UPPER_KEYS.contains(ent.getKey())).forEach(ent -> {
            Map sparkConf = Optional.ofNullable(specScriptRuntime).map(SpecScriptRuntime::getSparkConf).orElseGet(() -> {
                HashMap sparkConfMap = new HashMap();
                Optional.ofNullable(specScriptRuntime).ifPresent(runtime -> runtime.setSparkConf(sparkConfMap));
                return sparkConfMap;
            });
            sparkConf.put((String)ent.getKey(), ent.getValue());
        });
    }

    private NodeRerunModeType convertRerunMode(RerunMode rerunMode) {
        if (rerunMode == null) {
            return null;
        }
        return Arrays.stream(NodeRerunModeType.values()).filter(nodeRerunModeType -> StringUtils.equalsIgnoreCase((CharSequence)nodeRerunModeType.name(), (CharSequence)rerunMode.name())).findFirst().orElse(null);
    }

    private NodeRecurrenceType convertRecurrence(Integer nodeType) {
        return Arrays.stream(NodeType.values()).filter(t -> Objects.equals(t.getCode(), nodeType)).flatMap(t -> Arrays.stream(NodeRecurrenceType.values()).filter(r -> r.name().equalsIgnoreCase(t.name()))).findFirst().orElse(null);
    }

    private VariableType convertParamType(Integer paramType) {
        if (paramType == null) {
            return VariableType.CONSTANT;
        }
        if (1 == paramType) {
            return VariableType.CONSTANT;
        }
        if (2 == paramType) {
            return VariableType.NODE_OUTPUT;
        }
        if (3 == paramType) {
            return VariableType.PASS_THROUGH;
        }
        return VariableType.CONSTANT;
    }

    private void fillScriptParam(DwNodeEntity dwNode, SpecScript script) {
        if (dwNode.getParameter() == null) {
            return;
        }
        List specVariableList = ListUtils.defaultIfNull((List)script.getParameters(), new ArrayList());
        script.setParameters(specVariableList);
        specVariableList.removeIf(specVariable -> VariableScopeType.NODE_PARAMETER.equals((Object)specVariable.getScope()));
        List<SpecVariable> scriptParameters = this.toScriptParameters(dwNode);
        specVariableList.addAll(scriptParameters);
    }

    private boolean isNoKvPairParaValue(DwNodeEntity dmNodeBO, String paraValue) {
        if (CodeProgramType.TT_MERGE.name().equalsIgnoreCase(dmNodeBO.getType())) {
            return true;
        }
        if (CodeProgramType.DIDE_SHELL.name().equalsIgnoreCase(dmNodeBO.getType())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)paraValue)) {
            return false;
        }
        if (DefaultNodeTypeUtils.isDiNode(dmNodeBO.getType())) {
            return VariableUtils.NO_KV_PAIR_PARA_VALUE.matcher(paraValue).find();
        }
        String[] parts = StringUtils.trim((String)paraValue).split(" ");
        if (parts.length > 1) {
            for (String kv : parts) {
                String[] kvPair = kv.split("=");
                if (kvPair.length == 2) continue;
                return true;
            }
        }
        return false;
    }

    private List<SpecVariable> toScriptParameters(DwNodeEntity dmNodeBO) {
        if (this.isNoKvPairParaValue(dmNodeBO, dmNodeBO.getParameter())) {
            SpecVariable noKvPairVar = new SpecVariable();
            noKvPairVar.setName("-");
            noKvPairVar.setScope(VariableScopeType.NODE_PARAMETER);
            noKvPairVar.setType(VariableType.NO_KV_PAIR_EXPRESSION);
            noKvPairVar.setValue(dmNodeBO.getParameter());
            return Collections.singletonList(noKvPairVar);
        }
        AtomicInteger paraIndex = new AtomicInteger(1);
        return Arrays.stream(StringUtils.split((String)StringUtils.defaultString((String)dmNodeBO.getParameter(), (String)""), (String)" ")).map(kvStr -> {
            SpecVariable var = new SpecVariable();
            var.setType(VariableType.SYSTEM);
            var.setScope(VariableScopeType.NODE_PARAMETER);
            String[] kv = StringUtils.split((String)kvStr, (String)"=");
            if (kv.length == 2) {
                var.setName(kv[0]);
                var.setValue(kv[1]);
                return var;
            }
            var.setValue(kvStr);
            var.setName(String.valueOf(paraIndex.getAndIncrement()));
            return var;
        }).collect(Collectors.toList());
    }

    private void fillSpecFlowDepend(DwNodeEntity dwNode, SpecNode specNode, SpecFlowDepend specFlowDepend) {
        if (dwNode.getInputs() == null && StringUtils.isNotBlank((CharSequence)dwNode.getDependentDataNode())) {
            return;
        }
        specFlowDepend.setDepends(new ArrayList());
        ListUtils.emptyIfNull((List)specNode.getInputs()).stream().filter(SpecNodeOutput.class::isInstance).map(SpecNodeOutput.class::cast).map(input -> {
            SpecDepend specDepend = new SpecDepend();
            specDepend.setType(DependencyType.NORMAL);
            SpecNodeOutput art = new SpecNodeOutput();
            art.setData(input.getData());
            art.setArtifactType(ArtifactType.NODE_OUTPUT);
            art.setRefTableName(input.getRefTableName());
            specDepend.setOutput(art);
            return specDepend;
        }).forEach(specFlowDepend.getDepends()::add);
        if (Stream.of(DependentType.USER_DEFINE, DependentType.USER_DEFINE_AND_SELF).anyMatch(dt -> Objects.equals(dwNode.getDependentType(), dt.getValue()))) {
            ((List)Optional.ofNullable(StringUtils.split((String)dwNode.getDependentDataNode(), (String)",")).map(Arrays::asList).orElse(new ArrayList())).stream().map(out -> {
                SpecDepend specDepend = new SpecDepend();
                specDepend.setType(DependencyType.CROSS_CYCLE_OTHER_NODE);
                SpecNodeOutput art = new SpecNodeOutput();
                art.setData(out);
                art.setArtifactType(ArtifactType.NODE_OUTPUT);
                specDepend.setOutput(art);
                return specDepend;
            }).forEach(specFlowDepend.getDepends()::add);
        }
        if (Stream.of(DependentType.SELF, DependentType.USER_DEFINE_AND_SELF, DependentType.CHILD_AND_SELF).anyMatch(dt -> Objects.equals(dt.getValue(), dwNode.getDependentType()))) {
            SpecDepend specDepend = new SpecDepend();
            specDepend.setType(DependencyType.CROSS_CYCLE_SELF);
            specDepend.setNodeId(specNode);
            specFlowDepend.getDepends().add(specDepend);
            if (Objects.equals(DependentType.CHILD_AND_SELF.getValue(), dwNode.getDependentType())) {
                SpecDepend sp = new SpecDepend();
                sp.setType(DependencyType.CROSS_CYCLE_CHILDREN);
                sp.setNodeId(specNode);
                specFlowDepend.getDepends().add(sp);
            }
        }
    }
}

