/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec;

import com.alibaba.fastjson2.JSON;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.FunctionType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecEmbeddedResourceType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFileResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFunction;
import com.aliyun.dataworks.common.spec.domain.ref.SpecRuntimeResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.utils.UuidUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionSpecUpdateAdapter {
    private static final Logger log = LoggerFactory.getLogger(FunctionSpecUpdateAdapter.class);

    public void updateSpecification(DwNodeEntity dwNode, Specification<DataWorksWorkflowSpec> specification) {
        specification.setVersion(SpecVersion.V_1_1_0.getLabel());
        specification.setKind(SpecKind.FUNCTION.getLabel());
        Map metadata = (Map)ObjectUtils.defaultIfNull((Object)specification.getMetadata(), new LinkedHashMap());
        Optional.ofNullable(dwNode.getOwner()).ifPresent(owner -> metadata.put("owner", owner));
        Optional.ofNullable(dwNode.getUuid()).ifPresent(uuid -> metadata.put("uuid", uuid));
        Optional.ofNullable(dwNode.getParentId()).ifPresent(containerId -> metadata.put("containerId", String.valueOf(containerId)));
        specification.setMetadata(metadata);
        DataWorksWorkflowSpec spec = (DataWorksWorkflowSpec)ObjectUtils.defaultIfNull((Object)((DataWorksWorkflowSpec)specification.getSpec()), (Object)new DataWorksWorkflowSpec());
        Optional.ofNullable(dwNode.getBizId()).filter(id -> id > 0L).map(String::valueOf).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setId(arg_0));
        Optional.ofNullable(dwNode.getBizName()).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setName(arg_0));
        specification.setSpec((Spec)spec);
        SpecFunction specFunction = ListUtils.emptyIfNull((List)spec.getFunctions()).stream().findFirst().orElseGet(SpecFunction::new);
        spec.setFunctions(Collections.singletonList(specFunction));
        this.fillSpecFunction(dwNode, specFunction, spec);
        log.info("specification: {}", (Object)JSON.toJSONString(specification));
    }

    private void fillSpecFunction(DwNodeEntity dwNode, SpecFunction specFunction, DataWorksWorkflowSpec spec) {
        SpecScript specScript = (SpecScript)ObjectUtils.defaultIfNull((Object)specFunction.getScript(), (Object)new SpecScript());
        specFunction.setScript(specScript);
        this.fillSpecFunctionBasicInfo(dwNode, specFunction);
        this.fillSpecScript(dwNode, specScript, specFunction);
        this.fillResourceGroup(dwNode, specFunction);
        this.fillDatasource(dwNode, specFunction);
        this.fillContentAttr(dwNode, specFunction, spec);
    }

    private void fillSpecFunctionBasicInfo(DwNodeEntity dwNode, SpecFunction specFunction) {
        String id = Optional.ofNullable(dwNode.getUuid()).orElseGet(UuidUtils::genUuidWithoutHorizontalLine);
        specFunction.setId(id);
        Optional.ofNullable(dwNode.getName()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setName(arg_0));
    }

    private void fillSpecScript(DwNodeEntity dwNode, SpecScript script, SpecFunction specFunction) {
        Optional.ofNullable(dwNode.getFolder()).map(path -> FilenameUtils.concat((String)path, (String)specFunction.getName())).ifPresent(arg_0 -> ((SpecScript)script).setPath(arg_0));
        if (script.getPath() == null || !StringUtils.equals((CharSequence)FilenameUtils.getName((String)script.getPath()), (CharSequence)specFunction.getName())) {
            String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)script.getPath());
            script.setPath(FilenameUtils.concat((String)parentPath, (String)specFunction.getName()));
        }
        this.fillSpecScriptRuntime(dwNode, script);
    }

    private void fillSpecScriptRuntime(DwNodeEntity dwNode, SpecScript script) {
        SpecScriptRuntime runtime = (SpecScriptRuntime)ObjectUtils.defaultIfNull((Object)script.getRuntime(), (Object)new SpecScriptRuntime());
        script.setRuntime(runtime);
        Optional.ofNullable(dwNode.getType()).map(CodeProgramType::getNodeTypeByName).ifPresent(codeProgramType -> {
            runtime.setCommand(codeProgramType.name());
            runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        });
        Optional.ofNullable(dwNode.getTypeId()).ifPresent(arg_0 -> ((SpecScriptRuntime)runtime).setCommandTypeId(arg_0));
        Optional.ofNullable(dwNode.getCu()).ifPresent(arg_0 -> ((SpecScriptRuntime)runtime).setCu(arg_0));
    }

    private void fillResourceGroup(DwNodeEntity dwNode, SpecFunction specFunction) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getResourceGroup())) {
            SpecRuntimeResource specRuntimeResource = new SpecRuntimeResource();
            specRuntimeResource.setResourceGroup(dwNode.getResourceGroup());
            specFunction.setRuntimeResource(specRuntimeResource);
        }
    }

    private void fillDatasource(DwNodeEntity dwNode, SpecFunction specFunction) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getConnection())) {
            SpecDatasource specDatasource = new SpecDatasource();
            specDatasource.setName(dwNode.getConnection());
            specFunction.setDatasource(specDatasource);
        }
    }

    private void fillContentAttr(DwNodeEntity dwNode, SpecFunction specFunction, DataWorksWorkflowSpec spec) {
        if (StringUtils.isBlank((CharSequence)dwNode.getCode())) {
            return;
        }
        UdfDefinition udfDefinition = (UdfDefinition)JSON.parseObject((String)dwNode.getCode(), UdfDefinition.class);
        Optional.ofNullable(udfDefinition.getFunctionType()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setType(arg_0));
        Optional.ofNullable(udfDefinition.getClassName()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setClassName(arg_0));
        Optional.ofNullable(udfDefinition.getCmdDesc()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setUsageDescription(arg_0));
        Optional.ofNullable(udfDefinition.getDescription()).ifPresent(arg_0 -> ((DataWorksWorkflowSpec)spec).setDescription(arg_0));
        Optional.ofNullable(udfDefinition.getParamDesc()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setArgumentsDescription(arg_0));
        Optional.ofNullable(udfDefinition.getReturnValue()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setReturnValueDescription(arg_0));
        Optional.ofNullable(udfDefinition.getExample()).ifPresent(arg_0 -> ((SpecFunction)specFunction).setUsageExample(arg_0));
        Optional.ofNullable(udfDefinition.getResources()).ifPresent(x -> {
            if (StringUtils.isNotBlank((CharSequence)x)) {
                String[] resourceArr = x.split(",");
                ArrayList<SpecFileResource> fileResources = new ArrayList<SpecFileResource>();
                for (String resource : resourceArr) {
                    SpecFileResource fileResource = new SpecFileResource();
                    fileResource.setName(resource);
                    fileResources.add(fileResource);
                }
                specFunction.setFileResources(fileResources);
            }
        });
        specFunction.setResourceType(SpecEmbeddedResourceType.FILE);
    }

    public static final class UdfDefinition {
        private FunctionType functionType;
        private String className;
        private String name;
        private String resources;
        private String description;
        private String cmdDesc;
        private String paramDesc;
        private String returnValue;
        private String example;
        private String schema;

        public FunctionType getFunctionType() {
            return this.functionType;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getResources() {
            return this.resources;
        }

        public String getDescription() {
            return this.description;
        }

        public String getCmdDesc() {
            return this.cmdDesc;
        }

        public String getParamDesc() {
            return this.paramDesc;
        }

        public String getReturnValue() {
            return this.returnValue;
        }

        public String getExample() {
            return this.example;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setFunctionType(FunctionType functionType) {
            this.functionType = functionType;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setResources(String resources) {
            this.resources = resources;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setCmdDesc(String cmdDesc) {
            this.cmdDesc = cmdDesc;
        }

        public void setParamDesc(String paramDesc) {
            this.paramDesc = paramDesc;
        }

        public void setReturnValue(String returnValue) {
            this.returnValue = returnValue;
        }

        public void setExample(String example) {
            this.example = example;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UdfDefinition)) {
                return false;
            }
            UdfDefinition other = (UdfDefinition)o;
            FunctionType this$functionType = this.getFunctionType();
            FunctionType other$functionType = other.getFunctionType();
            if (this$functionType == null ? other$functionType != null : !this$functionType.equals(other$functionType)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$resources = this.getResources();
            String other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$cmdDesc = this.getCmdDesc();
            String other$cmdDesc = other.getCmdDesc();
            if (this$cmdDesc == null ? other$cmdDesc != null : !this$cmdDesc.equals(other$cmdDesc)) {
                return false;
            }
            String this$paramDesc = this.getParamDesc();
            String other$paramDesc = other.getParamDesc();
            if (this$paramDesc == null ? other$paramDesc != null : !this$paramDesc.equals(other$paramDesc)) {
                return false;
            }
            String this$returnValue = this.getReturnValue();
            String other$returnValue = other.getReturnValue();
            if (this$returnValue == null ? other$returnValue != null : !this$returnValue.equals(other$returnValue)) {
                return false;
            }
            String this$example = this.getExample();
            String other$example = other.getExample();
            if (this$example == null ? other$example != null : !this$example.equals(other$example)) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionType $functionType = this.getFunctionType();
            result = result * 59 + ($functionType == null ? 43 : $functionType.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $cmdDesc = this.getCmdDesc();
            result = result * 59 + ($cmdDesc == null ? 43 : $cmdDesc.hashCode());
            String $paramDesc = this.getParamDesc();
            result = result * 59 + ($paramDesc == null ? 43 : $paramDesc.hashCode());
            String $returnValue = this.getReturnValue();
            result = result * 59 + ($returnValue == null ? 43 : $returnValue.hashCode());
            String $example = this.getExample();
            result = result * 59 + ($example == null ? 43 : $example.hashCode());
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            return result;
        }

        public String toString() {
            return "FunctionSpecUpdateAdapter.UdfDefinition(functionType=" + this.getFunctionType() + ", className=" + this.getClassName() + ", name=" + this.getName() + ", resources=" + this.getResources() + ", description=" + this.getDescription() + ", cmdDesc=" + this.getCmdDesc() + ", paramDesc=" + this.getParamDesc() + ", returnValue=" + this.getReturnValue() + ", example=" + this.getExample() + ", schema=" + this.getSchema() + ")";
        }
    }
}

