/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.impl;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwProject;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.service.AbstractPackageFileService;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.ZipUtils;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksDwmaPackageFileService
extends AbstractPackageFileService<DataWorksPackage> {
    private static final Logger log = LoggerFactory.getLogger(DataWorksDwmaPackageFileService.class);
    public static final String SRC_WORKFLOW = "workflows";
    public static final String SRC_DATASOURCE = "datasources";
    public static final String SRC_TABLE = "tables";
    public static final String SRC_COMPONENT = "components";
    public static final String SRC_ADHOC_QUERY = "queries";
    public static final String SRC_RESOURCE = "resources";

    protected boolean isProjectRoot(File file) {
        return false;
    }

    private XmlMapper newXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        return xmlMapper;
    }

    public void load(DataWorksPackage packageObj) throws Exception {
    }

    public DataWorksPackage getPackage() throws Exception {
        return null;
    }

    public void write(DataWorksPackage packageModelObject, File targetPackageFile) throws Exception {
        File targetWorkspace = new File(targetPackageFile.getParentFile(), ".tmp");
        FileUtils.forceMkdir((File)targetWorkspace);
        this.writeProject(packageModelObject, targetWorkspace);
        this.writeSrc(packageModelObject, targetWorkspace);
        ZipUtils.zipDir((File)targetWorkspace, (File)targetPackageFile);
        log.info("zipped file: {}", (Object)targetPackageFile);
    }

    private void writeSrc(DataWorksPackage packageModelObject, File targetWorkspace) throws IOException {
        File srcDir = new File(targetWorkspace, "src");
        FileUtils.forceMkdir((File)srcDir);
        this.writeSrcWorkflows(packageModelObject, srcDir);
        this.writeSrcOthers(packageModelObject, srcDir, NodeUseType.AD_HOC, SRC_ADHOC_QUERY);
        this.writeSrcOthers(packageModelObject, srcDir, NodeUseType.COMPONENT, SRC_COMPONENT);
        this.writeSrcDatasources(packageModelObject, srcDir);
        this.writeSrcTables(packageModelObject, srcDir);
    }

    private void writeSrcOthers(DataWorksPackage packageModelObject, File srcDir, NodeUseType nodeUseType, String dirName) throws IOException {
        File adHocQueriesDir = new File(srcDir, dirName);
        FileUtils.forceMkdir((File)adHocQueriesDir);
        ((Stream)ListUtils.emptyIfNull(packageModelObject.getDwProject().getAdHocQueries()).stream().parallel()).forEach(n -> {
            try {
                File file = new File(adHocQueriesDir, n.getUniqueKey() + "_" + n.getName() + ".xml");
                XmlMapper xmlMapper = this.newXmlMapper();
                xmlMapper.writeValue(file, n);
            }
            catch (IOException e) {
                throw BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{"write " + dirName + " failed: " + e.getMessage()});
            }
        });
    }

    private void writeSrcTables(DataWorksPackage packageModelObject, File srcDir) throws IOException {
        File tableDir = new File(srcDir, SRC_TABLE);
        FileUtils.forceMkdir((File)tableDir);
        ((Stream)ListUtils.emptyIfNull(packageModelObject.getDwProject().getTables()).stream().parallel()).forEach(table -> {
            File tableFile = new File(tableDir, table.getName() + ".xml");
            XmlMapper xmlMapper = this.newXmlMapper();
            try {
                xmlMapper.writeValue(tableFile, table);
            }
            catch (IOException e) {
                throw BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{"write tables failed: " + e.getMessage()});
            }
        });
    }

    private void writeSrcDatasources(DataWorksPackage packageModelObject, File srcDir) throws IOException {
        File datasourceDir = new File(srcDir, SRC_DATASOURCE);
        FileUtils.forceMkdir((File)datasourceDir);
        ((Stream)ListUtils.emptyIfNull(packageModelObject.getDwProject().getDatasources()).stream().parallel()).forEach(ds -> {
            if (ds.getEnvType() == null) {
                ds.setEnvType(EnvType.DEV.name());
            }
            File datasourceFile = new File(datasourceDir, Joiner.on((String)"_").join((Object)ds.getEnvType(), (Object)ds.getName(), new Object[0]) + ".xml");
            XmlMapper xmlMapper = this.newXmlMapper();
            try {
                xmlMapper.writeValue(datasourceFile, ds);
            }
            catch (IOException e) {
                log.error("write datasource file: {}, error: ", (Object)datasourceFile, (Object)e);
                throw BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{"write datasource failed: " + e.getMessage()});
            }
        });
    }

    private void writeSrcWorkflows(DataWorksPackage packageModelObject, File srcDir) throws IOException {
        File workflowDir = new File(srcDir, SRC_WORKFLOW);
        FileUtils.forceMkdir((File)workflowDir);
        packageModelObject.getDwProject().getWorkflows().forEach(workflow -> {
            try {
                WorkflowType workflowType = workflow.getType();
                File workflowPath = new File(Joiner.on((String)File.separator).join((Object)workflowDir, (Object)Joiner.on((String)"_").join((Object)workflowType.name(), (Object)workflow.getName(), new Object[0]), new Object[0]));
                FileUtils.forceMkdir((File)workflowPath);
                this.writeResourceFiles(workflowPath, workflow.getResources());
                File workflowXml = new File(workflowPath, "workflow.xml");
                log.info("write workflow xml file: {}", (Object)workflowXml);
                XmlMapper xmlMapper = this.newXmlMapper();
                xmlMapper.writeValue(workflowXml, workflow);
            }
            catch (IOException e) {
                log.error("workflow json: {}", (Object)GsonUtils.gson.toJson(workflow));
                throw BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{"write workflow.xml failed: " + e.getMessage()});
            }
        });
    }

    private void writeResourceFiles(File workflowPath, List<Resource> resources) {
        File resourcesDir = new File(workflowPath, SRC_RESOURCE);
        resources.stream().filter(r -> r instanceof DwResource).forEach(res -> {
            try {
                File resFile = new File(resourcesDir, res.getName());
                FileUtils.copyFile((File)new File(((DwResource)res).getLocalPath()), (File)resFile);
                res.setPath(Joiner.on((String)File.separator).join((Object)SRC_RESOURCE, (Object)resFile.getName(), new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void writeProject(DataWorksPackage packageModelObject, File targetWorkspace) throws IOException {
        File projectXmlFile = new File(targetWorkspace, "project.xml");
        XmlMapper xmlMapper = this.newXmlMapper();
        DwProject projToWrite = new DwProject();
        projToWrite.setName(packageModelObject.getDwProject().getName());
        xmlMapper.writeValue((Writer)new FileWriter(projectXmlFile), (Object)projToWrite);
    }
}

