/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DITask;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DateParser;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.CDPTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.DependentTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.CronUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums.FrequencyTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums.TaskCodeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.model.NewDataX2DI;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.model.OldDataX2DI;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGoTask {
    private static final Logger log = LoggerFactory.getLogger(DataGoTask.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String INPUT = "INPUT";
    private static final String OUTPUT = "OUTPUT";
    private static final String DEFAULT_START_NODE = "datago_start";
    private static final String NORMAL_EXPR = "0:ALIGN";
    private TaskInstModel taskInstModel;
    private String treePathOfName;
    private Boolean success = Boolean.FALSE;
    private Properties properties;

    private DwNode toNode(String workflow) throws ParseException {
        TaskInstModel.TaskSnapshot.Task task = this.taskInstModel.taskSnapshot.task;
        DwNode dwNode = new DwNode();
        this.getNodeType(dwNode);
        this.convertBasicInfo(dwNode);
        dwNode.setCycleType(Integer.valueOf(FrequencyTypeEnum.toCycleType(task.scheduleConfig.frequency).getCode()));
        dwNode.setCronExpress(CronUtil.parseCron(task.scheduleConfig.scheduleExpression));
        this.convertDependent(dwNode);
        return dwNode;
    }

    public List<DwNode> toNodes(String workflow, Map<String, DgDatasource> datasourceMap) throws Exception {
        DwNode originalNode = this.toNode(workflow);
        this.processDepDetect(originalNode, datasourceMap);
        TaskInstModel.TaskSnapshot.Task task = this.taskInstModel.taskSnapshot.task;
        OldDataX2DI oldDataX2DI = task.getParams();
        List<DwNode> dwNodes = oldDataX2DI.convertMergeNode(originalNode, workflow);
        if (CollectionUtils.isNotEmpty(dwNodes)) {
            this.success = Boolean.TRUE;
        }
        return dwNodes;
    }

    private void processDepDetect(DwNode originalNode, Map<String, DgDatasource> datasourceMap) throws Exception {
        if (CollectionUtils.isEmpty((Collection)this.taskInstModel.taskSnapshot.task.depDetectList) || MapUtils.isEmpty(datasourceMap)) {
            return;
        }
        List depDetectList = this.taskInstModel.taskSnapshot.task.depDetectList;
        if (depDetectList.size() > 1) {
            log.error("depDetectList: {}", (Object)GsonUtils.gson.toJson((Object)depDetectList));
            throw new RuntimeException("got more than one detect config: " + this.taskInstModel.taskSnapshot.task.name);
        }
        TaskInstModel.DetectConfig detectConfig = (TaskInstModel.DetectConfig)depDetectList.get(0);
        if (detectConfig.getTarget() == null) {
            return;
        }
        TaskInstModel.DetectTarget target = detectConfig.getTarget();
        datasourceMap.values().stream().filter(ds -> ds.getId().equals(target.getDatasourceId())).findFirst().ifPresent(ds -> {
            try {
                String path = DateParser.parse((String)Joiner.on((String)File.separator).join((Object)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)ds.getRootPath(), (CharSequence)"root"), (Object)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)target.getDirectory(), (CharSequence)"directory"), new Object[]{org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)target.getFile(), (CharSequence)"")}));
                Integer interval = detectConfig.getInterval() == null ? 3 : detectConfig.getInterval();
                String stopAt = Optional.ofNullable(this.properties).map(prop -> prop.getProperty("workflow.converter.detectTask.stopAt")).orElse("2350");
                String params = Joiner.on((String)" ").join((Object)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)ds.getName(), (CharSequence)"datasourceName"), (Object)path, new Object[]{interval, stopAt});
                String code = IOUtils.toString((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("res/ftpcheck.sh")));
                originalNode.setParameter(params);
                originalNode.setCode(code);
                originalNode.setType(CodeProgramType.DIDE_SHELL.name());
            }
            catch (Exception e) {
                log.error("convert detect config error: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    public List<DwNode> toNodes(String workflow) throws Exception {
        return this.toNodes(workflow, null);
    }

    private void getNodeType(DwNode dwNode) {
        TaskInstModel.TaskSnapshot.Task task = this.taskInstModel.taskSnapshot.task;
        CodeProgramType nodeType = TaskCodeEnum.toDefaultNodeType(task.code);
        if (null == nodeType) {
            log.error("[DataGO] node Type not support, task: {}", (Object)this.taskInstModel.name);
            dwNode.setType(CodeProgramType.DIDE_SHELL.name());
            dwNode.setCode(task.content);
        } else {
            dwNode.setType(nodeType.name());
            if (CodeProgramType.DI.name().equals(nodeType.getName())) {
                DITask diTask = DataGoTask.toDITask(task);
                diTask.getSteps().stream().forEach(step -> this.rewriteParameters((DITask.Step)step));
                if (diTask.getSetting() != null) {
                    DITask.Setting.Speed speed;
                    DITask.Setting setting = diTask.getSetting();
                    if (setting.getSpeed() != null && (speed = setting.getSpeed()) != null && speed.getConcurrent() != null) {
                        speed.setDmu(speed.getConcurrent());
                    }
                    if (setting.getErrorLimit() == null) {
                        DITask.Setting.ErrorLimit errorLimit = new DITask.Setting.ErrorLimit();
                        errorLimit.setRecord(Integer.valueOf(0));
                        setting.setErrorLimit(errorLimit);
                    } else if (setting.getErrorLimit().getRecord() == null) {
                        setting.getErrorLimit().setRecord(Integer.valueOf(0));
                    }
                } else {
                    DITask.Setting setting = new DITask.Setting();
                    DITask.Setting.ErrorLimit errorLimit = new DITask.Setting.ErrorLimit();
                    errorLimit.setRecord(Integer.valueOf(0));
                    setting.setErrorLimit(errorLimit);
                    DITask.Setting.Speed speed = new DITask.Setting.Speed();
                    setting.setSpeed(speed);
                    diTask.setSetting(setting);
                }
                dwNode.setCode(diTask.toString());
                dwNode.setCodeMode(CodeModeType.WIZARD.getValue());
            } else if (!CodeProgramType.VIRTUAL.name().equals(nodeType.name())) {
                dwNode.setCode(task.content);
            }
        }
    }

    private void rewriteParameters(DITask.Step step) {
        JsonObject parameter;
        if ("sftp".equalsIgnoreCase(step.getStepType())) {
            step.setStepType("ftp");
        }
        if ((parameter = step.getParameter()) != null) {
            JsonElement partition;
            String compress;
            if (!parameter.has("fieldDelimiterOrigin") || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parameter.get("fieldDelimiterOrigin").getAsString())) {
                String fieldDelimiter;
                String string = fieldDelimiter = parameter.has("fieldDelimiter") ? parameter.get("fieldDelimiter").getAsString() : null;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fieldDelimiter)) {
                    parameter.addProperty("fieldDelimiterOrigin", StringEscapeUtils.escapeJava((String)fieldDelimiter));
                }
            }
            if (!parameter.has("path")) {
                String filePath;
                String string = filePath = parameter.has("filePath") ? parameter.get("filePath").getAsString() : "";
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filePath)) {
                    JsonArray path = new JsonArray();
                    path.add(filePath);
                    parameter.add("path", (JsonElement)path);
                }
            }
            if (!parameter.has("fileFormat")) {
                parameter.addProperty("fileFormat", "text");
            }
            if (parameter.has("compress") && "NONE".equalsIgnoreCase(compress = parameter.get("compress").getAsString())) {
                parameter.remove("compress");
            }
            if ("odps".equalsIgnoreCase(step.getStepType()) && "reader".equalsIgnoreCase(step.getCategory()) && parameter.has("partition") && (partition = parameter.get("partition")).isJsonPrimitive()) {
                String partitionStr = partition.getAsString();
                JsonArray partitionArray = new JsonArray();
                partitionArray.add(partitionStr);
                parameter.add("partition", (JsonElement)partitionArray);
            }
            if (CDPTypeEnum.OCEAN_BASE_NEW.getCDPDataXType().equalsIgnoreCase(step.getStepType())) {
                step.setStepType(CDPTypeEnum.OCEAN_BASE_NEW.getD2DataXType());
            }
        }
    }

    public static DITask toDITask(TaskInstModel.TaskSnapshot.Task task) {
        DITask diTask = new DITask();
        if (TaskCodeEnum.DATA_IMPORT.getCode().equals(task.code) || TaskCodeEnum.DATA_EXPORT.getCode().equals(task.code)) {
            OldDataX2DI oldDataX2DI = task.getParams();
            diTask.getSteps().add(oldDataX2DI.toReader());
            diTask.getSteps().add(oldDataX2DI.toWriter());
            diTask.setSetting(oldDataX2DI.getDataSyncConfig().getSerializeSetting());
        } else {
            NewDataX2DI dataXContent = (NewDataX2DI)GsonUtils.defaultGson.fromJson(task.content, new TypeToken<NewDataX2DI>(){}.getType());
            diTask.getSteps().add(dataXContent.toReader());
            diTask.getSteps().add(dataXContent.toWriter());
            diTask.setSetting(dataXContent.getContent().getDataxSetting());
        }
        return diTask;
    }

    private void convertBasicInfo(DwNode dwNode) throws ParseException {
        List userDefineValueModels;
        TaskInstModel.TaskSnapshot.Task task = this.taskInstModel.taskSnapshot.task;
        dwNode.setName(task.name.replaceAll(" +", ""));
        dwNode.setPriority(task.scheduleConfig.priority);
        dwNode.setIsAutoParse(Integer.valueOf(0));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)task.scheduleConfig.startEffectDate)) {
            dwNode.setStartEffectDate(SDF.parse(task.scheduleConfig.startEffectDate));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)task.scheduleConfig.endEffectDate)) {
            dwNode.setEndEffectDate(SDF.parse(task.scheduleConfig.endEffectDate));
        }
        if (CollectionUtils.isNotEmpty((Collection)(userDefineValueModels = task.userDefineValueModels))) {
            List paramList = userDefineValueModels.stream().map(TaskInstModel.UserDefineValueModel::toKeyValue).collect(Collectors.toList());
            String param = Joiner.on((String)" ").skipNulls().join(paramList);
            dwNode.setParameter(DateParser.parse((String)param));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)task.getUdv())) {
            JsonObject uv = task.getSerializeUdv();
            StringBuilder builder = new StringBuilder();
            uv.entrySet().forEach(stringJsonElementEntry -> builder.append((String)stringJsonElementEntry.getKey()).append("=").append(((JsonElement)stringJsonElementEntry.getValue()).getAsString()).append(" "));
            dwNode.setParameter(DateParser.parse((String)builder.toString()));
        }
        if (task.getParams() != null && task.getParams() != null && task.getParams().getInputParam() != null) {
            dwNode.setParameter(DateParser.parse((String)task.getParams().getInputParam().getValue()));
        }
    }

    private void convertDependent(DwNode dwNode) {
        List ioTags = this.taskInstModel.taskSnapshot.ioTags;
        if (CollectionUtils.isNotEmpty((Collection)ioTags)) {
            Optional<TaskInstModel.IoTag> crossDependentIO = ioTags.stream().filter(ioTag -> INPUT.equals(((TaskInstModel.IoTag)ioTag).type) && !NORMAL_EXPR.equals(((TaskInstModel.IoTag)ioTag).depExpr.expr)).findFirst();
            if (crossDependentIO.isPresent()) {
                dwNode.setDependentType(DependentTypeEnum.SELF.getType());
            } else {
                dwNode.setDependentType(DependentTypeEnum.NONE.getType());
            }
            List inputs = ioTags.stream().filter(ioTag -> INPUT.equals(((TaskInstModel.IoTag)ioTag).type) && NORMAL_EXPR.equals(((TaskInstModel.IoTag)ioTag).depExpr.expr) && ((TaskInstModel.IoTag)ioTag).enabled != false).map(ioTag -> {
                NodeIo in = this.convertNodeIo(((TaskInstModel.IoTag)ioTag).name);
                in.setParseType(Integer.valueOf(1));
                return in;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(inputs)) {
                dwNode.getInputs().addAll(inputs);
            }
            List outputs = ioTags.stream().filter(ioTag -> OUTPUT.equals(((TaskInstModel.IoTag)ioTag).type) && ((TaskInstModel.IoTag)ioTag).enabled != false).map(ioTag -> this.convertNodeIo(((TaskInstModel.IoTag)ioTag).name)).collect(Collectors.toList());
            dwNode.getOutputs().addAll(outputs);
        } else {
            dwNode.getOutputs().add(this.convertNodeIo(dwNode.getName()));
        }
        dwNode.setInputs(dwNode.getInputs().stream().filter(in -> !dwNode.getOutputs().stream().anyMatch(out -> out.getData().equalsIgnoreCase(in.getData()))).collect(Collectors.toList()));
    }

    private String normalizeNodeIo(String data) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)data)) {
            return data;
        }
        if (StringUtils.isAllAlphabetLowerCase((String)data)) {
            data = data + "_0";
            return data;
        }
        if (StringUtils.isAllAlphabetUpperCase((String)data)) {
            data = data + "_1";
            return data;
        }
        data = data + "_2";
        return data;
    }

    private NodeIo convertNodeIo(String name) {
        DwNodeIo output = new DwNodeIo();
        output.setParseType(Integer.valueOf(1));
        output.setData(this.normalizeNodeIo(name));
        output.setIsDifferentApp(Boolean.valueOf(true));
        return output;
    }

    public TaskInstModel getTaskInstModel() {
        return this.taskInstModel;
    }

    public String getTreePathOfName() {
        return this.treePathOfName;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setTaskInstModel(TaskInstModel taskInstModel) {
        this.taskInstModel = taskInstModel;
    }

    public void setTreePathOfName(String treePathOfName) {
        this.treePathOfName = treePathOfName;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataGoTask)) {
            return false;
        }
        DataGoTask other = (DataGoTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        TaskInstModel this$taskInstModel = this.getTaskInstModel();
        TaskInstModel other$taskInstModel = other.getTaskInstModel();
        if (this$taskInstModel == null ? other$taskInstModel != null : !((Object)this$taskInstModel).equals(other$taskInstModel)) {
            return false;
        }
        String this$treePathOfName = this.getTreePathOfName();
        String other$treePathOfName = other.getTreePathOfName();
        if (this$treePathOfName == null ? other$treePathOfName != null : !this$treePathOfName.equals(other$treePathOfName)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataGoTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        TaskInstModel $taskInstModel = this.getTaskInstModel();
        result = result * 59 + ($taskInstModel == null ? 43 : ((Object)$taskInstModel).hashCode());
        String $treePathOfName = this.getTreePathOfName();
        result = result * 59 + ($treePathOfName == null ? 43 : $treePathOfName.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DataGoTask(taskInstModel=" + this.getTaskInstModel() + ", treePathOfName=" + this.getTreePathOfName() + ", success=" + this.getSuccess() + ", properties=" + this.getProperties() + ")";
    }

    public static class TaskInstModel {
        private String taskCode;
        private String name;
        private String userId;
        private TaskSnapshot taskSnapshot;

        public String getTaskCode() {
            return this.taskCode;
        }

        public String getName() {
            return this.name;
        }

        public String getUserId() {
            return this.userId;
        }

        public TaskSnapshot getTaskSnapshot() {
            return this.taskSnapshot;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setTaskSnapshot(TaskSnapshot taskSnapshot) {
            this.taskSnapshot = taskSnapshot;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskInstModel)) {
                return false;
            }
            TaskInstModel other = (TaskInstModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taskCode = this.getTaskCode();
            String other$taskCode = other.getTaskCode();
            if (this$taskCode == null ? other$taskCode != null : !this$taskCode.equals(other$taskCode)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            TaskSnapshot this$taskSnapshot = this.getTaskSnapshot();
            TaskSnapshot other$taskSnapshot = other.getTaskSnapshot();
            return !(this$taskSnapshot == null ? other$taskSnapshot != null : !((Object)this$taskSnapshot).equals(other$taskSnapshot));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskInstModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taskCode = this.getTaskCode();
            result = result * 59 + ($taskCode == null ? 43 : $taskCode.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            TaskSnapshot $taskSnapshot = this.getTaskSnapshot();
            result = result * 59 + ($taskSnapshot == null ? 43 : ((Object)$taskSnapshot).hashCode());
            return result;
        }

        public String toString() {
            return "DataGoTask.TaskInstModel(taskCode=" + this.getTaskCode() + ", name=" + this.getName() + ", userId=" + this.getUserId() + ", taskSnapshot=" + this.getTaskSnapshot() + ")";
        }

        public static class TaskSnapshot {
            private Task task;
            private List<IoTag> ioTags;

            public Task getTask() {
                return this.task;
            }

            public List<IoTag> getIoTags() {
                return this.ioTags;
            }

            public void setTask(Task task) {
                this.task = task;
            }

            public void setIoTags(List<IoTag> ioTags) {
                this.ioTags = ioTags;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaskSnapshot)) {
                    return false;
                }
                TaskSnapshot other = (TaskSnapshot)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Task this$task = this.getTask();
                Task other$task = other.getTask();
                if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
                    return false;
                }
                List<IoTag> this$ioTags = this.getIoTags();
                List<IoTag> other$ioTags = other.getIoTags();
                return !(this$ioTags == null ? other$ioTags != null : !((Object)this$ioTags).equals(other$ioTags));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TaskSnapshot;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Task $task = this.getTask();
                result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
                List<IoTag> $ioTags = this.getIoTags();
                result = result * 59 + ($ioTags == null ? 43 : ((Object)$ioTags).hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.TaskSnapshot(task=" + this.getTask() + ", ioTags=" + this.getIoTags() + ")";
            }

            private static class Task {
                private String code;
                private String name;
                private String description;
                private String userId;
                private String content;
                private String udv;
                private List<UserDefineValueModel> userDefineValueModels;
                private ScheduleConfig scheduleConfig;
                private OldDataX2DI params;
                private List<DetectConfig> depDetectList;

                private JsonObject getSerializeUdv() {
                    JsonParser parser = new JsonParser();
                    return parser.parse(this.udv).getAsJsonObject();
                }

                public String toString() {
                    return GsonUtils.defaultGson.toJson((Object)this);
                }

                public String getCode() {
                    return this.code;
                }

                public String getName() {
                    return this.name;
                }

                public String getDescription() {
                    return this.description;
                }

                public String getUserId() {
                    return this.userId;
                }

                public String getContent() {
                    return this.content;
                }

                public String getUdv() {
                    return this.udv;
                }

                public List<UserDefineValueModel> getUserDefineValueModels() {
                    return this.userDefineValueModels;
                }

                public ScheduleConfig getScheduleConfig() {
                    return this.scheduleConfig;
                }

                public OldDataX2DI getParams() {
                    return this.params;
                }

                public List<DetectConfig> getDepDetectList() {
                    return this.depDetectList;
                }

                public void setCode(String code) {
                    this.code = code;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setDescription(String description) {
                    this.description = description;
                }

                public void setUserId(String userId) {
                    this.userId = userId;
                }

                public void setContent(String content) {
                    this.content = content;
                }

                public void setUdv(String udv) {
                    this.udv = udv;
                }

                public void setUserDefineValueModels(List<UserDefineValueModel> userDefineValueModels) {
                    this.userDefineValueModels = userDefineValueModels;
                }

                public void setScheduleConfig(ScheduleConfig scheduleConfig) {
                    this.scheduleConfig = scheduleConfig;
                }

                public void setParams(OldDataX2DI params) {
                    this.params = params;
                }

                public void setDepDetectList(List<DetectConfig> depDetectList) {
                    this.depDetectList = depDetectList;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Task)) {
                        return false;
                    }
                    Task other = (Task)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$code = this.getCode();
                    String other$code = other.getCode();
                    if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    String this$description = this.getDescription();
                    String other$description = other.getDescription();
                    if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                        return false;
                    }
                    String this$userId = this.getUserId();
                    String other$userId = other.getUserId();
                    if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                        return false;
                    }
                    String this$content = this.getContent();
                    String other$content = other.getContent();
                    if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                        return false;
                    }
                    String this$udv = this.getUdv();
                    String other$udv = other.getUdv();
                    if (this$udv == null ? other$udv != null : !this$udv.equals(other$udv)) {
                        return false;
                    }
                    List<UserDefineValueModel> this$userDefineValueModels = this.getUserDefineValueModels();
                    List<UserDefineValueModel> other$userDefineValueModels = other.getUserDefineValueModels();
                    if (this$userDefineValueModels == null ? other$userDefineValueModels != null : !((Object)this$userDefineValueModels).equals(other$userDefineValueModels)) {
                        return false;
                    }
                    ScheduleConfig this$scheduleConfig = this.getScheduleConfig();
                    ScheduleConfig other$scheduleConfig = other.getScheduleConfig();
                    if (this$scheduleConfig == null ? other$scheduleConfig != null : !((Object)this$scheduleConfig).equals(other$scheduleConfig)) {
                        return false;
                    }
                    OldDataX2DI this$params = this.getParams();
                    OldDataX2DI other$params = other.getParams();
                    if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                        return false;
                    }
                    List<DetectConfig> this$depDetectList = this.getDepDetectList();
                    List<DetectConfig> other$depDetectList = other.getDepDetectList();
                    return !(this$depDetectList == null ? other$depDetectList != null : !((Object)this$depDetectList).equals(other$depDetectList));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Task;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $code = this.getCode();
                    result = result * 59 + ($code == null ? 43 : $code.hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    String $description = this.getDescription();
                    result = result * 59 + ($description == null ? 43 : $description.hashCode());
                    String $userId = this.getUserId();
                    result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
                    String $content = this.getContent();
                    result = result * 59 + ($content == null ? 43 : $content.hashCode());
                    String $udv = this.getUdv();
                    result = result * 59 + ($udv == null ? 43 : $udv.hashCode());
                    List<UserDefineValueModel> $userDefineValueModels = this.getUserDefineValueModels();
                    result = result * 59 + ($userDefineValueModels == null ? 43 : ((Object)$userDefineValueModels).hashCode());
                    ScheduleConfig $scheduleConfig = this.getScheduleConfig();
                    result = result * 59 + ($scheduleConfig == null ? 43 : ((Object)$scheduleConfig).hashCode());
                    OldDataX2DI $params = this.getParams();
                    result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
                    List<DetectConfig> $depDetectList = this.getDepDetectList();
                    result = result * 59 + ($depDetectList == null ? 43 : ((Object)$depDetectList).hashCode());
                    return result;
                }
            }
        }

        private static class IoTag {
            private String type;
            private String name;
            private String source;
            private Boolean enabled;
            private DepExpr depExpr;

            public String getType() {
                return this.type;
            }

            public String getName() {
                return this.name;
            }

            public String getSource() {
                return this.source;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public DepExpr getDepExpr() {
                return this.depExpr;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setSource(String source) {
                this.source = source;
            }

            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            public void setDepExpr(DepExpr depExpr) {
                this.depExpr = depExpr;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IoTag)) {
                    return false;
                }
                IoTag other = (IoTag)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$source = this.getSource();
                String other$source = other.getSource();
                if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                    return false;
                }
                DepExpr this$depExpr = this.getDepExpr();
                DepExpr other$depExpr = other.getDepExpr();
                return !(this$depExpr == null ? other$depExpr != null : !((Object)this$depExpr).equals(other$depExpr));
            }

            protected boolean canEqual(Object other) {
                return other instanceof IoTag;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $source = this.getSource();
                result = result * 59 + ($source == null ? 43 : $source.hashCode());
                DepExpr $depExpr = this.getDepExpr();
                result = result * 59 + ($depExpr == null ? 43 : ((Object)$depExpr).hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.IoTag(type=" + this.getType() + ", name=" + this.getName() + ", source=" + this.getSource() + ", enabled=" + this.getEnabled() + ", depExpr=" + this.getDepExpr() + ")";
            }
        }

        private static class DepExpr {
            private String expr;

            public String getExpr() {
                return this.expr;
            }

            public void setExpr(String expr) {
                this.expr = expr;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DepExpr)) {
                    return false;
                }
                DepExpr other = (DepExpr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$expr = this.getExpr();
                String other$expr = other.getExpr();
                return !(this$expr == null ? other$expr != null : !this$expr.equals(other$expr));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DepExpr;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $expr = this.getExpr();
                result = result * 59 + ($expr == null ? 43 : $expr.hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.DepExpr(expr=" + this.getExpr() + ")";
            }
        }

        private static class ScheduleConfig {
            private String frequency;
            private String scheduleExpression;
            private Integer priority;
            private String startEffectDate;
            private String endEffectDate;

            public String getFrequency() {
                return this.frequency;
            }

            public String getScheduleExpression() {
                return this.scheduleExpression;
            }

            public Integer getPriority() {
                return this.priority;
            }

            public String getStartEffectDate() {
                return this.startEffectDate;
            }

            public String getEndEffectDate() {
                return this.endEffectDate;
            }

            public void setFrequency(String frequency) {
                this.frequency = frequency;
            }

            public void setScheduleExpression(String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
            }

            public void setPriority(Integer priority) {
                this.priority = priority;
            }

            public void setStartEffectDate(String startEffectDate) {
                this.startEffectDate = startEffectDate;
            }

            public void setEndEffectDate(String endEffectDate) {
                this.endEffectDate = endEffectDate;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ScheduleConfig)) {
                    return false;
                }
                ScheduleConfig other = (ScheduleConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$priority = this.getPriority();
                Integer other$priority = other.getPriority();
                if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                    return false;
                }
                String this$frequency = this.getFrequency();
                String other$frequency = other.getFrequency();
                if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
                    return false;
                }
                String this$scheduleExpression = this.getScheduleExpression();
                String other$scheduleExpression = other.getScheduleExpression();
                if (this$scheduleExpression == null ? other$scheduleExpression != null : !this$scheduleExpression.equals(other$scheduleExpression)) {
                    return false;
                }
                String this$startEffectDate = this.getStartEffectDate();
                String other$startEffectDate = other.getStartEffectDate();
                if (this$startEffectDate == null ? other$startEffectDate != null : !this$startEffectDate.equals(other$startEffectDate)) {
                    return false;
                }
                String this$endEffectDate = this.getEndEffectDate();
                String other$endEffectDate = other.getEndEffectDate();
                return !(this$endEffectDate == null ? other$endEffectDate != null : !this$endEffectDate.equals(other$endEffectDate));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ScheduleConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $priority = this.getPriority();
                result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
                String $frequency = this.getFrequency();
                result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
                String $scheduleExpression = this.getScheduleExpression();
                result = result * 59 + ($scheduleExpression == null ? 43 : $scheduleExpression.hashCode());
                String $startEffectDate = this.getStartEffectDate();
                result = result * 59 + ($startEffectDate == null ? 43 : $startEffectDate.hashCode());
                String $endEffectDate = this.getEndEffectDate();
                result = result * 59 + ($endEffectDate == null ? 43 : $endEffectDate.hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.ScheduleConfig(frequency=" + this.getFrequency() + ", scheduleExpression=" + this.getScheduleExpression() + ", priority=" + this.getPriority() + ", startEffectDate=" + this.getStartEffectDate() + ", endEffectDate=" + this.getEndEffectDate() + ")";
            }
        }

        private static class UserDefineValueModel {
            private final String EQUAL_SIGN = "=";
            private String key;
            private String value;
            private Boolean encryption;

            public String toKeyValue() {
                return this.key + "=" + this.value;
            }

            public String getEQUAL_SIGN() {
                return this.EQUAL_SIGN;
            }

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }

            public Boolean getEncryption() {
                return this.encryption;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public void setEncryption(Boolean encryption) {
                this.encryption = encryption;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UserDefineValueModel)) {
                    return false;
                }
                UserDefineValueModel other = (UserDefineValueModel)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$encryption = this.getEncryption();
                Boolean other$encryption = other.getEncryption();
                if (this$encryption == null ? other$encryption != null : !((Object)this$encryption).equals(other$encryption)) {
                    return false;
                }
                String this$EQUAL_SIGN = this.getEQUAL_SIGN();
                String other$EQUAL_SIGN = other.getEQUAL_SIGN();
                if (this$EQUAL_SIGN == null ? other$EQUAL_SIGN != null : !this$EQUAL_SIGN.equals(other$EQUAL_SIGN)) {
                    return false;
                }
                String this$key = this.getKey();
                String other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof UserDefineValueModel;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $encryption = this.getEncryption();
                result = result * 59 + ($encryption == null ? 43 : ((Object)$encryption).hashCode());
                String $EQUAL_SIGN = this.getEQUAL_SIGN();
                result = result * 59 + ($EQUAL_SIGN == null ? 43 : $EQUAL_SIGN.hashCode());
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.UserDefineValueModel(EQUAL_SIGN=" + this.getEQUAL_SIGN() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", encryption=" + this.getEncryption() + ")";
            }
        }

        private static class DetectTarget {
            private String fileType;
            private String directory;
            private String file;
            private Long datasourceId;
            private String type;

            public String getFileType() {
                return this.fileType;
            }

            public String getDirectory() {
                return this.directory;
            }

            public String getFile() {
                return this.file;
            }

            public Long getDatasourceId() {
                return this.datasourceId;
            }

            public String getType() {
                return this.type;
            }

            public void setFileType(String fileType) {
                this.fileType = fileType;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public void setFile(String file) {
                this.file = file;
            }

            public void setDatasourceId(Long datasourceId) {
                this.datasourceId = datasourceId;
            }

            public void setType(String type) {
                this.type = type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DetectTarget)) {
                    return false;
                }
                DetectTarget other = (DetectTarget)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$datasourceId = this.getDatasourceId();
                Long other$datasourceId = other.getDatasourceId();
                if (this$datasourceId == null ? other$datasourceId != null : !((Object)this$datasourceId).equals(other$datasourceId)) {
                    return false;
                }
                String this$fileType = this.getFileType();
                String other$fileType = other.getFileType();
                if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
                    return false;
                }
                String this$directory = this.getDirectory();
                String other$directory = other.getDirectory();
                if (this$directory == null ? other$directory != null : !this$directory.equals(other$directory)) {
                    return false;
                }
                String this$file = this.getFile();
                String other$file = other.getFile();
                if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DetectTarget;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $datasourceId = this.getDatasourceId();
                result = result * 59 + ($datasourceId == null ? 43 : ((Object)$datasourceId).hashCode());
                String $fileType = this.getFileType();
                result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
                String $directory = this.getDirectory();
                result = result * 59 + ($directory == null ? 43 : $directory.hashCode());
                String $file = this.getFile();
                result = result * 59 + ($file == null ? 43 : $file.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.DetectTarget(fileType=" + this.getFileType() + ", directory=" + this.getDirectory() + ", file=" + this.getFile() + ", datasourceId=" + this.getDatasourceId() + ", type=" + this.getType() + ")";
            }
        }

        private static class DetectConfig {
            private String type;
            private Date gmtModified;
            private Integer interval;
            private Integer duration;
            private String stopStrategy;
            private String stopTime;
            private DetectTarget target;

            public String getType() {
                return this.type;
            }

            public Date getGmtModified() {
                return this.gmtModified;
            }

            public Integer getInterval() {
                return this.interval;
            }

            public Integer getDuration() {
                return this.duration;
            }

            public String getStopStrategy() {
                return this.stopStrategy;
            }

            public String getStopTime() {
                return this.stopTime;
            }

            public DetectTarget getTarget() {
                return this.target;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setGmtModified(Date gmtModified) {
                this.gmtModified = gmtModified;
            }

            public void setInterval(Integer interval) {
                this.interval = interval;
            }

            public void setDuration(Integer duration) {
                this.duration = duration;
            }

            public void setStopStrategy(String stopStrategy) {
                this.stopStrategy = stopStrategy;
            }

            public void setStopTime(String stopTime) {
                this.stopTime = stopTime;
            }

            public void setTarget(DetectTarget target) {
                this.target = target;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DetectConfig)) {
                    return false;
                }
                DetectConfig other = (DetectConfig)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$interval = this.getInterval();
                Integer other$interval = other.getInterval();
                if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
                    return false;
                }
                Integer this$duration = this.getDuration();
                Integer other$duration = other.getDuration();
                if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                Date this$gmtModified = this.getGmtModified();
                Date other$gmtModified = other.getGmtModified();
                if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
                    return false;
                }
                String this$stopStrategy = this.getStopStrategy();
                String other$stopStrategy = other.getStopStrategy();
                if (this$stopStrategy == null ? other$stopStrategy != null : !this$stopStrategy.equals(other$stopStrategy)) {
                    return false;
                }
                String this$stopTime = this.getStopTime();
                String other$stopTime = other.getStopTime();
                if (this$stopTime == null ? other$stopTime != null : !this$stopTime.equals(other$stopTime)) {
                    return false;
                }
                DetectTarget this$target = this.getTarget();
                DetectTarget other$target = other.getTarget();
                return !(this$target == null ? other$target != null : !((Object)this$target).equals(other$target));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DetectConfig;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $interval = this.getInterval();
                result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
                Integer $duration = this.getDuration();
                result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                Date $gmtModified = this.getGmtModified();
                result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
                String $stopStrategy = this.getStopStrategy();
                result = result * 59 + ($stopStrategy == null ? 43 : $stopStrategy.hashCode());
                String $stopTime = this.getStopTime();
                result = result * 59 + ($stopTime == null ? 43 : $stopTime.hashCode());
                DetectTarget $target = this.getTarget();
                result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
                return result;
            }

            public String toString() {
                return "DataGoTask.TaskInstModel.DetectConfig(type=" + this.getType() + ", gmtModified=" + this.getGmtModified() + ", interval=" + this.getInterval() + ", duration=" + this.getDuration() + ", stopStrategy=" + this.getStopStrategy() + ", stopTime=" + this.getStopTime() + ", target=" + this.getTarget() + ")";
            }
        }
    }
}

