/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago;

import com.google.common.base.Joiner;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtil {
    private static final Logger log = LoggerFactory.getLogger(CronUtil.class);

    public static String parseCron(String expression) {
        if (StringUtils.isBlank((String)expression)) {
            return expression;
        }
        Object[] fields = expression.split(" ");
        fields[0] = CronUtil.convertField(fields[0]);
        fields[1] = CronUtil.convertField(fields[1]);
        fields[2] = CronUtil.convertField(fields[2]);
        return Joiner.on((String)" ").join(fields);
    }

    private static String convertField(String filed) {
        return CronUtil.convertField(filed, "/", 1);
    }

    private static String convertField(String field, String delimiter, int maxLength) {
        if (field.contains(delimiter)) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] items = field.split(delimiter);
            for (int i = 0; i < items.length; ++i) {
                String s = items[i];
                if (s.contains("-")) {
                    s = CronUtil.convertField(s, "-", 2);
                }
                if (StringUtils.isNumeric((String)s) && i < maxLength) {
                    s = String.format("%02d", Integer.parseInt(s));
                }
                stringBuilder.append(s);
                if (i >= items.length - 1) continue;
                stringBuilder.append(delimiter);
            }
            field = stringBuilder.toString().trim();
        } else if (StringUtils.isNumeric((String)field)) {
            field = String.format("%02d", Integer.parseInt(field));
        }
        return field;
    }
}

