/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.subprocess;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.enums.SpecEntityType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.subprocess.BaseSubProcessParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class SubProcessParameterConverter
extends BaseSubProcessParameterConverter {
    private SpecRefEntityWrapper specRefEntity;

    public SubProcessParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(spec, specWorkflow, taskDefinition, context);
    }

    @Override
    public SpecNode convert() {
        SpecNode specNode = this.newSpecNode(this.taskDefinition);
        String uuid = this.context.getUuidFromCode(((SubProcessParameters)this.parameter).getProcessDefinitionCode());
        SpecRefEntityWrapper specRefEntityWrapper = this.context.getSpecRefEntityMap().get(uuid);
        SpecEntityType specEntityType = Optional.ofNullable(specRefEntityWrapper).map(SpecRefEntityWrapper::getType).orElse(null);
        if (SpecEntityType.WORKFLOW.equals((Object)specEntityType)) {
            this.specRefEntity = specRefEntityWrapper;
            this.convertParameter(specNode);
        }
        return specNode;
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        SpecWorkflow workflow = this.specRefEntity.getWorkflow();
        this.copySubWorkflowAndAddInnerNode(workflow, specNode);
    }

    private void copySubWorkflowAndAddInnerNode(SpecWorkflow refWorkflow, SpecNode subprocessNode) {
        SpecWorkflow copyWorkflow = this.copyWorkflow(refWorkflow);
        List specNodes = ListUtils.emptyIfNull((List)copyWorkflow.getInnerNodes());
        specNodes.forEach(node -> Optional.ofNullable(node.getScript()).ifPresent(script -> script.setPath(this.getScriptPath(subprocessNode) + "_" + node.getName())));
        this.getWorkflowNodeList().addAll(specNodes);
        this.getWorkflowDependencyList().addAll(ListUtils.emptyIfNull((List)copyWorkflow.getInnerDependencies()));
        this.buildHeadAndTailNode(specNodes);
    }

    private void buildHeadAndTailNode(List<SpecNode> specNodeList) {
        Set allOutputId = ListUtils.emptyIfNull(specNodeList).stream().map(SpecNode::getOutputs).flatMap(Collection::stream).filter(output -> output instanceof SpecRefEntity).map(output -> (SpecRefEntity)output).map(SpecRefEntity::getId).collect(Collectors.toSet());
        Set allIdSet = ListUtils.emptyIfNull(specNodeList).stream().map(SpecRefEntity::getId).collect(Collectors.toSet());
        HashSet nonTailIdSet = new HashSet();
        specNodeList.forEach(node -> {
            boolean isHead = ListUtils.emptyIfNull((List)node.getInputs()).stream().map(input -> ((SpecRefEntity)input).getId()).noneMatch(allOutputId::contains);
            if (isHead) {
                this.headList.add(this.newWrapper((SpecRefEntity)node));
            } else {
                ListUtils.emptyIfNull((List)node.getInputs()).stream().filter(input -> input instanceof SpecNodeOutput).map(input -> ((SpecNodeOutput)input).getData()).forEach(nonTailIdSet::add);
            }
        });
        allIdSet.removeAll(nonTailIdSet);
        specNodeList.forEach(node -> {
            if (allIdSet.contains(node.getId())) {
                this.tailList.add(this.newWrapper((SpecRefEntity)node));
            }
        });
    }
}

