/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.enums.NodeRecurrenceType;
import com.aliyun.dataworks.common.spec.domain.enums.TriggerType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Flag;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.DateUtils;
import java.text.ParseException;
import java.time.Duration;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerConverter
extends AbstractCommonConverter<SpecTrigger> {
    private static final Logger log = LoggerFactory.getLogger(TriggerConverter.class);
    private final Schedule schedule;
    private final SpecTrigger currTrigger;
    private final TaskDefinition taskDefinition;
    private SpecTrigger convertRes;

    public TriggerConverter(Schedule schedule, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.schedule = schedule;
        this.currTrigger = null;
        this.taskDefinition = null;
        this.convertRes = new SpecTrigger();
    }

    public TriggerConverter(SpecTrigger trigger, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.schedule = null;
        this.currTrigger = trigger;
        this.taskDefinition = taskDefinition;
        this.convertRes = new SpecTrigger();
    }

    @Override
    public SpecTrigger convert() {
        if (Objects.nonNull(this.schedule)) {
            this.convertBySchedule();
        } else if (Objects.nonNull(this.currTrigger) && Objects.nonNull(this.taskDefinition)) {
            this.convertByTaskDefinition();
        } else {
            return null;
        }
        return this.convertRes;
    }

    private void convertBySchedule() {
        if (Objects.isNull(this.schedule)) {
            this.convertRes.setType(TriggerType.MANUAL);
        } else {
            this.convertRes.setId(this.generateUuid(Long.valueOf(this.schedule.getId())));
            this.convertRes.setType(TriggerType.SCHEDULER);
            this.convertRes.setStartTime(DateUtils.convertDateToString((Date)this.schedule.getStartTime()));
            this.convertRes.setEndTime(DateUtils.convertDateToString((Date)this.schedule.getEndTime()));
            this.convertRes.setCron(this.dolphinCron2SpecCron(this.schedule.getCrontab()));
            this.convertRes.setTimezone(this.schedule.getTimezoneId());
            this.convertRes.setDelaySeconds(Integer.valueOf(0));
        }
    }

    private void convertByTaskDefinition() {
        assert (this.currTrigger != null && this.taskDefinition != null);
        this.convertRes = (SpecTrigger)BeanUtils.deepCopy((Object)this.currTrigger, SpecTrigger.class);
        this.convertRes.setDelaySeconds(Integer.valueOf((int)Duration.ofMinutes(this.taskDefinition.getDelayTime()).getSeconds()));
        this.convertRes.setRecurrence(Flag.YES.equals((Object)this.taskDefinition.getFlag()) ? NodeRecurrenceType.NORMAL : NodeRecurrenceType.PAUSE);
        this.convertRes.setId(this.generateUuid());
    }

    private String dolphinCron2SpecCron(String dolphinCron) {
        try {
            return CronExpressUtil.quartzCronExpressionToDwCronExpress((String)dolphinCron);
        }
        catch (ParseException e) {
            log.warn("dolphin cron parse error: {}", (Object)dolphinCron);
            return dolphinCron;
        }
    }
}

