/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.AbstractParameters;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.condition.ConditionsParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.dependent.DependentParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.subprocess.SubProcessParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.mr.MapReduceParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.python.PythonParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.shell.ShellParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.spark.SparkParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.sql.SqlParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.sqoop.SqoopParameterConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(ParameterConverterFactory.class);

    private ParameterConverterFactory() {
    }

    public static <P extends AbstractParameters> AbstractParameterConverter<P> create(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        TaskType taskType = TaskType.of((String)taskDefinition.getTaskType());
        AbstractParameterConverter<P> converter = ParameterConverterFactory.createFromContext(spec, specWorkflow, taskDefinition, taskType, context);
        if (converter != null) {
            return converter;
        }
        return Optional.of(taskType).map(type -> {
            switch (taskType) {
                case SQL: {
                    return new SqlParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case PYTHON: {
                    return new PythonParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case SPARK: {
                    return new SparkParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case CONDITIONS: {
                    return new ConditionsParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case SUB_PROCESS: {
                    return new SubProcessParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case DEPENDENT: {
                    return new DependentParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case SHELL: {
                    return new ShellParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case MR: {
                    return new MapReduceParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
                case SQOOP: {
                    return new SqoopParameterConverter(spec, specWorkflow, taskDefinition, context);
                }
            }
            throw new BizException(ErrorCode.UNKNOWN_ENUM_TYPE, new Object[]{TaskType.class, taskType});
        }).orElseThrow(() -> new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"taskDefinition.taskType"}));
    }

    private static <P extends AbstractParameters> AbstractParameterConverter<P> createFromContext(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, TaskType taskType, DolphinSchedulerV3ConverterContext context) {
        if (taskType == null) {
            log.warn("task type is null, taskDefinition: {}", (Object)taskDefinition);
            return null;
        }
        Map nodeTypeMap = Optional.ofNullable(context).map(DolphinSchedulerV3ConverterContext::getNodeTypeMap).orElse(Collections.emptyMap());
        String converterClassName = (String)nodeTypeMap.get(taskType.name());
        if (converterClassName == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(converterClassName);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(DataWorksWorkflowSpec.class, SpecWorkflow.class, TaskDefinition.class, DolphinSchedulerV3ConverterContext.class);
            return (AbstractParameterConverter)declaredConstructor.newInstance(spec, specWorkflow, taskDefinition, context);
        }
        catch (ClassNotFoundException e) {
            log.warn("class not found: {}", (Object)converterClassName, (Object)e);
        }
        catch (NoSuchMethodException e) {
            log.warn("construct method not found: {}", (Object)converterClassName, (Object)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.warn("error found when new instance, {}", (Object)converterClassName, (Object)e);
        }
        return null;
    }
}

