/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.LabelEnum;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecAssertIn;
import com.aliyun.dataworks.common.spec.domain.noref.SpecAssertion;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoin;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoinBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecLogic;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFileResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScheduleStrategy;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.exception.SpecIErrorCode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.datax.DataxParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.flink.FlinkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.http.HttpParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.AbstractParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.SqoopParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.task.condition.ConditionsParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.transformer.core.utils.SpecFileResourceTypeUtils;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.ParamListConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.TriggerConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterConverter<T extends AbstractParameters>
extends AbstractCommonConverter<SpecNode> {
    private static final Logger log = LoggerFactory.getLogger(AbstractParameterConverter.class);
    private static final String RESOURCE_REFERENCE_FORMAT = "%s@resource_reference{\"%s\"}";
    protected final TaskDefinition taskDefinition;
    protected static Map<TaskType, Class<? extends AbstractParameters>> taskTypeClassMap = new EnumMap<TaskType, Class<? extends AbstractParameters>>(TaskType.class);
    protected T parameter;
    protected final List<SpecRefEntityWrapper> headList = new ArrayList<SpecRefEntityWrapper>();
    protected final List<SpecRefEntityWrapper> tailList = new ArrayList<SpecRefEntityWrapper>();
    private final DataWorksWorkflowSpec spec;
    private final SpecWorkflow specWorkflow;

    protected AbstractParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.spec = spec;
        this.specWorkflow = specWorkflow;
        this.taskDefinition = taskDefinition;
        TaskType taskType = TaskType.valueOf((String)taskDefinition.getTaskType());
        try {
            this.parameter = (AbstractParameters)GsonUtils.fromJsonString((String)taskDefinition.getTaskParams(), (Type)TypeToken.get(taskTypeClassMap.get(taskType)).getType());
        }
        catch (Exception ex) {
            log.error("parse task {}, parameter {} error: ", new Object[]{taskType, taskTypeClassMap.get(taskType), ex});
        }
    }

    protected abstract void convertParameter(SpecNode var1);

    @Override
    public SpecNode convert() {
        SpecNode specNode = this.newSpecNode(this.taskDefinition);
        this.convertParameter(specNode);
        this.getWorkflowNodeList().add(specNode);
        if (CollectionUtils.isEmpty(this.headList)) {
            this.headList.add(this.newWrapper((SpecRefEntity)specNode));
        }
        if (CollectionUtils.isEmpty(this.tailList)) {
            this.tailList.add(this.newWrapper((SpecRefEntity)specNode));
        }
        return specNode;
    }

    private SpecNode initSpecNode() {
        SpecNode specNode = new SpecNode();
        specNode.setInputs(new ArrayList());
        specNode.setOutputs(new ArrayList());
        specNode.setFileResources(new ArrayList());
        specNode.setFunctions(new ArrayList());
        return specNode;
    }

    protected SpecNode newSpecNode(TaskDefinition taskDefinition) {
        SpecNode specNode = this.initSpecNode();
        specNode.setId(this.generateUuid(taskDefinition.getCode(), (SpecRefEntity)specNode));
        specNode.setName(taskDefinition.getName());
        specNode.setDescription(taskDefinition.getDescription());
        specNode.setRerunTimes(Integer.valueOf(taskDefinition.getFailRetryTimes()));
        specNode.setRerunInterval(Integer.valueOf((int)Duration.ofMinutes(taskDefinition.getFailRetryInterval()).toMillis()));
        specNode.setTimeout(Integer.valueOf(taskDefinition.getTimeout()));
        specNode.setPriority(this.convertPriority(taskDefinition.getTaskPriority()));
        this.resetNodeStrategy(specNode);
        SpecNodeOutput defaultOutput = this.buildDefaultNodeOutput(specNode);
        specNode.getOutputs().add((Output)BeanUtils.deepCopy((Object)defaultOutput, SpecNodeOutput.class));
        TriggerConverter triggerConverter = new TriggerConverter(this.getWorkflowTrigger(), taskDefinition, this.context);
        specNode.setTrigger(triggerConverter.convert());
        return specNode;
    }

    protected SpecNodeOutput buildDefaultNodeOutput(SpecNode specNode) {
        SpecNodeOutput specNodeOutput = new SpecNodeOutput();
        specNodeOutput.setIsDefault(Boolean.valueOf(true));
        specNodeOutput.setId(this.generateUuid());
        specNodeOutput.setData(specNode.getId());
        specNodeOutput.setRefTableName(specNode.getName());
        return specNodeOutput;
    }

    protected SpecNodeOutput getDefaultOutput(SpecNode specNode) {
        return this.getDefaultOutput((List<Output>)Optional.ofNullable(specNode).map(SpecNode::getOutputs).orElse(null));
    }

    protected SpecNodeOutput getDefaultOutput(SpecWorkflow specWorkflow, boolean throwException) {
        return this.getDefaultOutput((List<Output>)Optional.ofNullable(specWorkflow).map(SpecWorkflow::getOutputs).orElse(null), throwException);
    }

    protected SpecNodeOutput getDefaultOutput(SpecNode specNode, boolean throwException) {
        return this.getDefaultOutput((List<Output>)Optional.ofNullable(specNode).map(SpecNode::getOutputs).orElse(null), throwException);
    }

    protected SpecNodeOutput getDefaultOutput(List<Output> outputList) {
        return this.getDefaultOutput(outputList, false);
    }

    protected SpecNodeOutput getDefaultOutput(List<Output> outputList, boolean throwException) {
        Optional<Output> first = ListUtils.emptyIfNull(outputList).stream().filter(output -> output instanceof SpecNodeOutput && ((SpecNodeOutput)output).getIsDefault() != false).findFirst();
        if (throwException && !first.isPresent()) {
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"defaultOutput"});
        }
        return first.orElse(null);
    }

    protected List<SpecVariable> getContextOutputs(SpecNode specNode) {
        return specNode.getOutputs().stream().filter(v -> v instanceof SpecVariable && VariableScopeType.NODE_CONTEXT.equals((Object)((SpecVariable)v).getScope()) && VariableType.NODE_OUTPUT.equals((Object)((SpecVariable)v).getType())).map(v -> {
            SpecVariable variable = (SpecVariable)BeanUtils.deepCopy((Object)v, SpecVariable.class);
            variable.setNode(new SpecDepend(specNode, DependencyType.NORMAL, null));
            return variable;
        }).collect(Collectors.toList());
    }

    protected List<SpecVariable> convertSpecNodeParam(SpecNode specNode) {
        ParamListConverter paramListConverter = new ParamListConverter(this.taskDefinition.getTaskParamList(), this.taskDefinition, this.context);
        Object specVariableList = paramListConverter.convert();
        Iterator iterator = specVariableList.iterator();
        while (iterator.hasNext()) {
            SpecVariable specVariable = (SpecVariable)iterator.next();
            if (!VariableType.NODE_OUTPUT.equals((Object)specVariable.getType())) continue;
            SpecDepend nodeDepend = new SpecDepend();
            nodeDepend.setNodeId(specNode);
            nodeDepend.setOutput(this.getDefaultOutput(specNode));
            specVariable.setNode(nodeDepend);
            specNode.getOutputs().add(specVariable);
        }
        return specVariableList;
    }

    protected void convertFileResourceList(SpecNode specNode) {
        ListUtils.emptyIfNull((List)this.parameter.getResourceFilesList()).forEach(resourceInfo -> {
            SpecFileResource specFileResource = new SpecFileResource();
            specFileResource.setRuntimeResource(specNode.getRuntimeResource());
            specFileResource.setName(this.getFileNameByPath(resourceInfo.getResourceName()));
            specFileResource.setType(SpecFileResourceTypeUtils.getResourceTypeBySuffix(specFileResource.getName()));
            this.checkFileSameName(specFileResource.getName(), resourceInfo.getResourceName());
            specNode.getFileResources().add(specFileResource);
        });
    }

    private void checkFileSameName(String fileName, String fullName) {
        String fullNameIn = this.context.getFileNameMap().get(fileName);
        if (Objects.nonNull(fullNameIn) && !fullNameIn.equals(fullName)) {
            log.warn("\u5b58\u5728\u540c\u540d\u8d44\u6e90\u51b2\u7a81\u98ce\u9669, {} \u548c {} \u5bfc\u5165\u540e\u4f1a\u540c\u540d", (Object)fullNameIn, (Object)fullName);
        } else {
            this.context.getFileNameMap().put(fileName, fullName);
        }
    }

    protected String buildFileResourceReference(SpecNode specNode, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        Optional.ofNullable(specNode).map(SpecNode::getFileResources).ifPresent(fileResources -> fileResources.forEach(fileResource -> stringBuilder.append(String.format(RESOURCE_REFERENCE_FORMAT, prefix, fileResource.getName())).append("\n")));
        return stringBuilder.append("\n").toString();
    }

    protected SpecJoinBranch buildSpecJoinBranch(SpecNode specNode, ControllerJoinCode.Status assertion) {
        SpecJoinBranch specJoinBranch = new SpecJoinBranch();
        specJoinBranch.setNodeId(specNode);
        specJoinBranch.setName("b_" + specNode.getId());
        specJoinBranch.setOutput(this.getDefaultOutput(specNode, false));
        specJoinBranch.setAssertion(this.newAssertion(Collections.singletonList(assertion)));
        return specJoinBranch;
    }

    protected SpecJoinBranch buildSpecJoinBranch(SpecNodeOutput specNodeOutput, ControllerJoinCode.Status assertion) {
        SpecJoinBranch specJoinBranch = new SpecJoinBranch();
        specJoinBranch.setName("b_" + specNodeOutput.getId());
        specJoinBranch.setOutput(specNodeOutput);
        specJoinBranch.setAssertion(this.newAssertion(Collections.singletonList(assertion)));
        return specJoinBranch;
    }

    private SpecAssertion newAssertion(List<ControllerJoinCode.Status> statusList) {
        if (CollectionUtils.isEmpty(statusList)) {
            return null;
        }
        SpecAssertIn specAssertIn = new SpecAssertIn();
        specAssertIn.setValue(new ArrayList());
        ListUtils.emptyIfNull(statusList).stream().map(ControllerJoinCode.Status::getCode).forEach(code -> specAssertIn.getValue().add(code));
        SpecAssertion specAssertion = new SpecAssertion();
        specAssertion.setField("status");
        specAssertion.setIn(specAssertIn);
        return specAssertion;
    }

    protected SpecNode copyJoinNode(SpecNode specNode, SpecJoin specJoin, String suffix) {
        SpecNode specNodeCopy = (SpecNode)BeanUtils.deepCopy((Object)specNode, SpecNode.class);
        specNodeCopy.setId(this.generateUuid((SpecRefEntity)specNodeCopy));
        specNodeCopy.setName(specNodeCopy.getName() + suffix);
        for (Output output : specNodeCopy.getOutputs()) {
            if (output instanceof SpecNodeOutput && Boolean.TRUE.equals(((SpecNodeOutput)output).getIsDefault())) {
                ((SpecNodeOutput)output).setId(this.generateUuid());
                ((SpecNodeOutput)output).setData(specNodeCopy.getId());
                ((SpecNodeOutput)output).setRefTableName(specNodeCopy.getName());
                continue;
            }
            if (!(output instanceof SpecRefEntity)) continue;
            ((SpecRefEntity)output).setId(this.generateUuid());
        }
        this.getWorkflowNodeList().add(specNodeCopy);
        SpecScript scriptCopy = (SpecScript)BeanUtils.deepCopy((Object)specNodeCopy.getScript(), SpecScript.class);
        scriptCopy.setId(this.generateUuid());
        scriptCopy.setPath(scriptCopy.getPath() + suffix);
        specNodeCopy.setScript(scriptCopy);
        specNodeCopy.setJoin(specJoin);
        Optional.ofNullable(this.buildControllerJoinCode(specNodeCopy)).map(AbstractBaseCode::getContent).ifPresent(arg_0 -> ((SpecScript)scriptCopy).setContent(arg_0));
        return specNodeCopy;
    }

    protected void addRelation(SpecNode postNode, List<SpecNode> preNodeList, List<SpecNodeOutput> preNodeOutputList) {
        SpecFlowDepend specFlowDepend = this.newSpecFlowDepend();
        specFlowDepend.setNodeId(postNode);
        ListUtils.emptyIfNull(preNodeList).forEach(preNode -> {
            SpecNodeOutput preNodeOutput = this.getDefaultOutput((SpecNode)preNode);
            postNode.getInputs().add(preNodeOutput);
            postNode.getInputs().addAll(this.getContextOutputs((SpecNode)preNode));
            specFlowDepend.getDepends().add(new SpecDepend(preNode, DependencyType.NORMAL, preNodeOutput));
        });
        ListUtils.emptyIfNull(preNodeOutputList).forEach(preNodeOutput -> {
            postNode.getInputs().add(preNodeOutput);
            SpecDepend specDepend = new SpecDepend();
            specDepend.setType(DependencyType.NORMAL);
            specDepend.setOutput(preNodeOutput);
            specFlowDepend.getDepends().add(specDepend);
        });
        this.getWorkflowDependencyList().add(specFlowDepend);
    }

    protected void addRelation(SpecNode postNode, List<SpecNode> preNodeList) {
        this.addRelation(postNode, preNodeList, null);
    }

    protected String getFileNameByPath(String path) {
        File file = new File(path);
        return file.getName();
    }

    protected String getScriptPath(SpecNode specNode) {
        if (Objects.isNull(specNode)) {
            return "";
        }
        String defaultPath = StringUtils.defaultString((String)this.context.getDefaultScriptPath(), (String)"");
        String workFlowPath = Optional.ofNullable(this.specWorkflow).map(SpecWorkflow::getName).orElse(Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getName).orElse(""));
        return FilenameUtils.concat((String)FilenameUtils.concat((String)defaultPath, (String)workFlowPath), (String)specNode.getName());
    }

    protected String getScriptPath(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        String defaultPath = StringUtils.defaultString((String)this.context.getDefaultScriptPath(), (String)"");
        String workFlowPath = Optional.ofNullable(this.specWorkflow).map(SpecWorkflow::getName).orElse(Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getName).orElse(""));
        return FilenameUtils.concat((String)FilenameUtils.concat((String)defaultPath, (String)workFlowPath), (String)name);
    }

    protected List<SpecNode> getWorkflowNodeList() {
        if (Objects.nonNull(this.specWorkflow)) {
            return this.specWorkflow.getNodes();
        }
        return Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getNodes).orElseThrow(() -> new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"spec or specWorkflow"}));
    }

    protected List<SpecFlowDepend> getWorkflowDependencyList() {
        if (Objects.nonNull(this.specWorkflow)) {
            return this.specWorkflow.getDependencies();
        }
        return Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getFlow).orElseThrow(() -> new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"spec or specWorkflow"}));
    }

    protected SpecTrigger getWorkflowTrigger() {
        if (Objects.nonNull(this.specWorkflow)) {
            return this.specWorkflow.getTrigger();
        }
        return null;
    }

    protected SpecWorkflow getWorkFlow() {
        return this.specWorkflow;
    }

    protected void resetNodeStrategy(SpecNode specNode) {
        if (specNode.getStrategy() == null) {
            specNode.setStrategy(new SpecScheduleStrategy());
        }
        SpecScheduleStrategy strategy = specNode.getStrategy();
        strategy.setPriority(specNode.getPriority());
        strategy.setTimeout(specNode.getTimeout());
        strategy.setRerunInterval(specNode.getRerunInterval());
        strategy.setRerunTimes(specNode.getRerunTimes());
        strategy.setIgnoreBranchConditionSkip(specNode.getIgnoreBranchConditionSkip());
        strategy.setInstanceMode(specNode.getInstanceMode());
        strategy.setRerunMode(specNode.getRerunMode());
        Optional.ofNullable(this.getWorkFlow()).map(SpecWorkflow::getStrategy).map(SpecScheduleStrategy::getFailureStrategy).ifPresent(arg_0 -> ((SpecScheduleStrategy)strategy).setFailureStrategy(arg_0));
    }

    protected ControllerJoinCode buildControllerJoinCode(SpecNode specNode) {
        SpecJoin join = specNode.getJoin();
        if (join == null) {
            return null;
        }
        ControllerJoinCode code = new ControllerJoinCode();
        code.setResultStatus(join.getResultStatus());
        code.setBranchList(new ArrayList());
        Map branchMap = ListUtils.emptyIfNull((List)join.getBranches()).stream().collect(Collectors.toMap(SpecJoinBranch::getName, Function.identity()));
        String express = Optional.ofNullable(join.getLogic()).map(SpecLogic::getExpression).map(s -> "and " + s).orElse("");
        log.info("express: {}", (Object)express);
        String[] tokens = express.split("\\s+");
        if (tokens.length % 2 != 0) {
            throw new SpecException((SpecIErrorCode)SpecErrorCode.PARSE_ERROR, "node.join.logic.expression is invalid");
        }
        for (int i = 0; i < tokens.length; i += 2) {
            ControllerJoinCode.Logic logic = (ControllerJoinCode.Logic)LabelEnum.getByLabel(ControllerJoinCode.Logic.class, (String)tokens[i]);
            if (logic == null) {
                throw new SpecException((SpecIErrorCode)SpecErrorCode.PARSE_ERROR, "node.join.logic.expression is invalid");
            }
            String branchName = tokens[i + 1];
            SpecJoinBranch branch = (SpecJoinBranch)branchMap.get(branchName);
            if (branch == null) {
                throw new SpecException((SpecIErrorCode)SpecErrorCode.PARSE_ERROR, "node.join.logic.expression is invalid");
            }
            ControllerJoinCode.Branch b = new ControllerJoinCode.Branch();
            String nodeId = this.getNodeIdFromSpecBranch(branch);
            b.setNode(nodeId);
            b.setNodeUuid(nodeId);
            b.setNodeName(this.getNodeNameFromSpecBranch(branch));
            b.setLogic(logic.getCode());
            b.setRunStatus(Optional.ofNullable(branch.getAssertion()).map(SpecAssertion::getIn).map(SpecAssertIn::getValue).orElse(Collections.emptyList()).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList()));
            code.getBranchList().add(b);
        }
        return code;
    }

    private String getNodeIdFromSpecBranch(SpecJoinBranch branch) {
        return Optional.ofNullable(branch).map(SpecJoinBranch::getNodeId).map(SpecRefEntity::getId).orElseGet(() -> Optional.ofNullable(branch).map(SpecJoinBranch::getOutput).filter(output -> BooleanUtils.isTrue((Boolean)output.getIsDefault())).map(SpecNodeOutput::getData).orElse(null));
    }

    private String getNodeNameFromSpecBranch(SpecJoinBranch branch) {
        return Optional.ofNullable(branch).map(SpecJoinBranch::getNodeId).map(SpecNode::getName).orElseGet(() -> Optional.ofNullable(branch).map(SpecJoinBranch::getOutput).filter(output -> BooleanUtils.isTrue((Boolean)output.getIsDefault())).map(SpecNodeOutput::getRefTableName).orElse(null));
    }

    public List<SpecRefEntityWrapper> getHeadList() {
        return this.headList;
    }

    public List<SpecRefEntityWrapper> getTailList() {
        return this.tailList;
    }

    static {
        taskTypeClassMap.put(TaskType.SQL, SqlParameters.class);
        taskTypeClassMap.put(TaskType.DEPENDENT, DependentParameters.class);
        taskTypeClassMap.put(TaskType.FLINK, FlinkParameters.class);
        taskTypeClassMap.put(TaskType.SPARK, SparkParameters.class);
        taskTypeClassMap.put(TaskType.DATAX, DataxParameters.class);
        taskTypeClassMap.put(TaskType.SHELL, ShellParameters.class);
        taskTypeClassMap.put(TaskType.HTTP, HttpParameters.class);
        taskTypeClassMap.put(TaskType.PROCEDURE, ProcedureParameters.class);
        taskTypeClassMap.put(TaskType.CONDITIONS, ConditionsParameters.class);
        taskTypeClassMap.put(TaskType.SQOOP, SqoopParameters.class);
        taskTypeClassMap.put(TaskType.SUB_PROCESS, SubProcessParameters.class);
        taskTypeClassMap.put(TaskType.PYTHON, PythonParameters.class);
        taskTypeClassMap.put(TaskType.MR, MapReduceParameters.class);
    }
}

