/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.transformer.flowspec;

import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.FlowSpecDolphinSchedulerV3Converter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.SpecWorkflowDolphinSchedulerV3Converter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.transformer.flowspec.FlowSpecDolphinSchedulerV3TransformerConfig;
import com.aliyun.dataworks.migrationx.transformer.flowspec.transformer.AbstractTransformer;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.aliyun.migrationx.common.utils.JsonFileUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSpecDolphinSchedulerV3Transformer
extends AbstractTransformer {
    private static final Logger log = LoggerFactory.getLogger(FlowSpecDolphinSchedulerV3Transformer.class);
    private static final Set<String> SUPPORT_KIND_SET = new HashSet<String>();
    private FlowSpecConverterContext context;
    private final List<Specification<DataWorksWorkflowSpec>> specificationList = new ArrayList<Specification<DataWorksWorkflowSpec>>();
    private final List<DagDataSchedule> dagDataScheduleList = new ArrayList<DagDataSchedule>();

    public FlowSpecDolphinSchedulerV3Transformer(String configPath, String sourcePath, String targetPath) {
        this.configPath = configPath;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
    }

    @Override
    public void transform() throws Exception {
        this.read();
        this.doTransform();
        this.write();
    }

    private void read() {
        try {
            JsonNode jsonNode;
            this.context = this.parseContext();
            JsonParser jsonParser = JsonFileUtils.buildJsonParser((InputStream)Files.newInputStream(Paths.get(this.sourcePath, new String[0]), new OpenOption[0]));
            while ((jsonNode = JSONUtils.readObjFromParser((JsonParser)jsonParser)) != null) {
                String flowSpec = JSONUtils.toJsonString((Object)jsonNode);
                this.specificationList.add((Specification<DataWorksWorkflowSpec>)SpecUtil.parseToDomain((String)flowSpec));
            }
        }
        catch (IOException e) {
            log.error("read config or source file error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void write() {
        File targetFile = new File(this.targetPath);
        if (targetFile.exists() && !targetFile.delete()) {
            log.error("target file exists and can not be deleted, file: {}", (Object)targetFile);
            throw new BizException(ErrorCode.NO_PERMISSION, new Object[]{"delete file " + targetFile});
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));){
            writer.write(JSONUtils.toJsonString(this.dagDataScheduleList));
        }
        catch (IOException e) {
            log.error("write to target file error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void doTransform() {
        List specList = ListUtils.emptyIfNull(this.specificationList).stream().filter(this::checkSpecification).map(Specification::getSpec).filter(Objects::nonNull).collect(Collectors.toList());
        this.dagDataScheduleList.addAll(specList.stream().map(spec -> ListUtils.emptyIfNull((List)spec.getWorkflows()).stream().map(workflow -> new SpecWorkflowDolphinSchedulerV3Converter((DataWorksWorkflowSpec)spec, (SpecWorkflow)workflow, this.context).convert()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList()));
        this.dagDataScheduleList.addAll(specList.stream().filter(spec -> CollectionUtils.isNotEmpty((Collection)spec.getNodes())).map(spec -> new FlowSpecDolphinSchedulerV3Converter((DataWorksWorkflowSpec)spec, this.context).convert()).collect(Collectors.toList()));
    }

    private boolean checkSpecification(Specification<DataWorksWorkflowSpec> specification) {
        return Objects.nonNull(specification) && SUPPORT_KIND_SET.contains(specification.getKind()) && Objects.nonNull(specification.getSpec());
    }

    private FlowSpecConverterContext parseContext() throws IOException {
        String content = FileUtils.readFileToString((File)new File(this.configPath), (Charset)StandardCharsets.UTF_8);
        FlowSpecDolphinSchedulerV3TransformerConfig config = (FlowSpecDolphinSchedulerV3TransformerConfig)JSONUtils.parseObject((String)content, FlowSpecDolphinSchedulerV3TransformerConfig.class);
        return Optional.ofNullable(config).orElseThrow(() -> new BizException(ErrorCode.PARSE_CONFIG_FILE_FAILED, new Object[]{config})).getContext();
    }

    static {
        SUPPORT_KIND_SET.add(SpecKind.MANUAL_WORKFLOW.getLabel());
        SUPPORT_KIND_SET.add(SpecKind.CYCLE_WORKFLOW.getLabel());
    }
}

