/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.ConditionType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ProcessTaskRelationListConverter
extends AbstractCommonConverter<List<ProcessTaskRelation>> {
    private final DataWorksWorkflowSpec spec;
    private final SpecWorkflow workflow;

    public ProcessTaskRelationListConverter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, List<ProcessTaskRelation> result, FlowSpecConverterContext context) {
        super(Objects.nonNull(result) ? result : new ArrayList(), context);
        this.spec = spec;
        this.workflow = workflow;
    }

    public ProcessTaskRelationListConverter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, FlowSpecConverterContext context) {
        this(spec, workflow, null, context);
    }

    @Override
    public List<ProcessTaskRelation> convert() {
        if (Objects.isNull(this.spec)) {
            return (List)this.result;
        }
        Long processDefinitionCode = this.context.getIdCodeMap().get(this.spec.getId());
        List nodeList = this.spec.getNodes();
        List dependList = this.spec.getFlow();
        if (Objects.nonNull(this.workflow)) {
            processDefinitionCode = this.context.getIdCodeMap().get(this.workflow.getId());
            nodeList = this.workflow.getNodes();
            dependList = this.workflow.getDependencies();
        }
        this.prepareFlow(nodeList, dependList);
        HashSet nonHeadNodeCodeSet = new HashSet();
        Long finalProcessDefinitionCode = processDefinitionCode;
        ListUtils.emptyIfNull((List)dependList).forEach(flow -> {
            String postNodeId = Optional.ofNullable(flow.getNodeId()).map(SpecRefEntity::getId).orElseThrow(() -> new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"nodeId"}));
            Long postNodeCode = this.context.getIdCodeMap().get(postNodeId);
            ListUtils.emptyIfNull((List)flow.getDepends()).forEach(depend -> {
                String preNodeId = Optional.ofNullable(depend.getNodeId()).map(SpecRefEntity::getId).orElse(null);
                Long preNodeCode = this.context.getIdCodeMap().get(preNodeId);
                if (Objects.nonNull(preNodeCode) && Objects.nonNull(postNodeCode)) {
                    ProcessTaskRelation processTaskRelation = this.buildProcessTaskRelation(finalProcessDefinitionCode, preNodeCode, postNodeCode);
                    ((List)this.result).add(processTaskRelation);
                    nonHeadNodeCodeSet.add(postNodeCode);
                }
            });
        });
        ListUtils.emptyIfNull((List)nodeList).stream().map(SpecRefEntity::getId).filter(Objects::nonNull).map(id -> this.context.getIdCodeMap().get(id)).filter(code -> Objects.nonNull(code) && !nonHeadNodeCodeSet.contains(code)).map(code -> this.buildProcessTaskRelation(finalProcessDefinitionCode, 0L, (Long)code)).forEach(((List)this.result)::add);
        return (List)this.result;
    }

    private ProcessTaskRelation buildProcessTaskRelation(Long processDefinitionCode, Long preNodeCode, Long postNodeCode) {
        ProcessTaskRelation processTaskRelation = new ProcessTaskRelation();
        processTaskRelation.setId(this.generateId(null));
        processTaskRelation.setName("");
        processTaskRelation.setProcessDefinitionVersion(1);
        processTaskRelation.setProjectCode(((Long)ObjectUtils.defaultIfNull((Object)this.context.getProjectCode(), (Object)0L)).longValue());
        processTaskRelation.setProcessDefinitionCode(processDefinitionCode.longValue());
        processTaskRelation.setPreTaskCode(preNodeCode.longValue());
        processTaskRelation.setPreTaskVersion(preNodeCode == 0L ? 0 : 1);
        processTaskRelation.setPostTaskCode(postNodeCode.longValue());
        processTaskRelation.setPostTaskVersion(1);
        processTaskRelation.setConditionType(ConditionType.NONE);
        processTaskRelation.setConditionParams("{}");
        processTaskRelation.setCreateTime(new Date());
        processTaskRelation.setUpdateTime(new Date());
        return processTaskRelation;
    }

    private void prepareFlow(List<SpecNode> nodeList, List<SpecFlowDepend> specFlowDependList) {
        HashMap outputDataNodeMap = new HashMap();
        ListUtils.emptyIfNull(nodeList).forEach(node -> {
            List outputs = node.getOutputs();
            ListUtils.emptyIfNull((List)outputs).stream().filter(output -> Objects.nonNull(output) && output instanceof SpecNodeOutput).map(SpecNodeOutput.class::cast).filter(output -> Objects.nonNull(output.getData())).forEach(output -> outputDataNodeMap.put(output.getData(), node));
        });
        ListUtils.emptyIfNull(specFlowDependList).stream().filter(flow -> Objects.nonNull(flow.getNodeId()) && CollectionUtils.isNotEmpty((Collection)flow.getDepends())).forEach(flow -> {
            List depends = flow.getDepends();
            depends.stream().filter(depend -> Objects.isNull(depend.getNodeId())).forEach(depend -> {
                String outputData = Optional.ofNullable(depend.getOutput()).map(SpecNodeOutput::getData).orElse(null);
                depend.setNodeId((SpecNode)outputDataNodeMap.get(outputData));
            });
        });
    }
}

