/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.flink.FlinkDeployMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.flink.FlinkParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters.AbstractParameterConverter;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class FlinkParameterConverter
extends AbstractParameterConverter<FlinkParameters> {
    private static final String FLINK_VERSION_BEFORE_1_10 = "<1.10";
    private static final String FLINK_VERSION_AFTER_OR_EQUALS_1_12 = ">=1.12";
    private static final String FLINK_VERSION_AFTER_OR_EQUALS_1_13 = ">=1.13";
    public static final FlinkDeployMode DEFAULT_DEPLOY_MODE = FlinkDeployMode.CLUSTER;

    public FlinkParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        SpecScript script = new SpecScript();
        ProgramType programType = ((FlinkParameters)this.parameter).getProgramType();
        if (!ProgramType.SQL.equals((Object)programType)) {
            throw new RuntimeException("not support flink type: " + programType);
        }
        String type = this.getSqlConverterType();
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = this.buildRunCommandLine((FlinkParameters)this.parameter);
        String resourceReference = this.buildFileResourceReference(specNode, "##");
        code = this.replaceCodeWithParams(code, specVariableList);
        script.setContent(resourceReference + code);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        runtime.setFlinkConf(this.buildConf((FlinkParameters)this.parameter));
        this.postHandle("FLINK", script);
    }

    public String buildRunCommandLine(FlinkParameters param) {
        switch (param.getProgramType()) {
            case SQL: {
                List<String> sqls = this.buildRunCommandLineForSql(param);
                return String.join((CharSequence)"\n", sqls);
            }
        }
        List<String> args = this.buildRunCommandLineForOthers(param);
        return String.join((CharSequence)" ", args);
    }

    public Map<String, Object> buildConf(FlinkParameters param) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        HashMap<String, String> streamingResourceSetting = new HashMap<String, String>();
        streamingResourceSetting.put("resourceSettingMode", "BASIC");
        HashMap<String, Integer> basicResourceSetting = new HashMap<String, Integer>();
        basicResourceSetting.put("parallelism", param.getParallelism());
        basicResourceSetting.put("taskmanagerResourceSettingSpec", (Integer)ImmutableMap.of((Object)"memory", (Object)param.getTaskManagerMemory(), (Object)"cpu", (Object)1.0));
        basicResourceSetting.put("jobmanagerResourceSettingSpec", (Integer)ImmutableMap.of((Object)"memory", (Object)param.getJobManagerMemory(), (Object)"cpu", (Object)1.0));
        conf.put("streamingResourceSetting", streamingResourceSetting);
        HashMap<String, Integer> flinkConf = new HashMap<String, Integer>();
        flinkConf.put("taskmanager.numberOfTaskSlots", param.getSlot());
        conf.put("flinkConf", flinkConf);
        return conf;
    }

    private List<String> buildRunCommandLineForSql(FlinkParameters flinkParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(flinkParameters.getInitScript());
        args.add(flinkParameters.getRawScript());
        return args;
    }

    public List<String> buildInitOptionsForSql(FlinkParameters flinkParameters) {
        ArrayList<String> initOptions = new ArrayList<String>();
        FlinkDeployMode deployMode = Optional.ofNullable(flinkParameters.getDeployMode()).orElse(FlinkDeployMode.CLUSTER);
        if (FlinkDeployMode.LOCAL == deployMode) {
            initOptions.add(String.format("set execution.target=%s", "local"));
        } else if (FlinkDeployMode.STANDALONE != deployMode) {
            String yarnQueue;
            String taskManagerMemory;
            String jobManagerMemory;
            String appName;
            initOptions.add(String.format("set execution.target=%s", "yarn-per-job"));
            int slot = flinkParameters.getSlot();
            if (slot > 0) {
                initOptions.add(String.format("set taskmanager.numberOfTaskSlots=%d", slot));
            }
            if (StringUtils.isNotEmpty((CharSequence)(appName = flinkParameters.getAppName()))) {
                initOptions.add(String.format("set yarn.application.name=%s", ArgsUtils.escape((String)appName)));
            }
            if (StringUtils.isNotEmpty((CharSequence)(jobManagerMemory = flinkParameters.getJobManagerMemory()))) {
                initOptions.add(String.format("set jobmanager.memory.process.size=%s", jobManagerMemory));
            }
            if (StringUtils.isNotEmpty((CharSequence)(taskManagerMemory = flinkParameters.getTaskManagerMemory()))) {
                initOptions.add(String.format("set taskmanager.memory.process.size=%s", taskManagerMemory));
            }
            if (StringUtils.isNotEmpty((CharSequence)(yarnQueue = flinkParameters.getYarnQueue()))) {
                initOptions.add(String.format("set yarn.application.queue=%s", yarnQueue));
            }
        }
        int parallelism = flinkParameters.getParallelism();
        if (parallelism > 0) {
            initOptions.add(String.format("set parallelism.default=%d", parallelism));
        }
        return initOptions;
    }

    private List<String> buildRunCommandLineForOthers(FlinkParameters flinkParameters) {
        String mainArgs;
        ResourceInfo mainJar;
        ArrayList<String> args = new ArrayList<String>();
        args.add("flink");
        FlinkDeployMode deployMode = Optional.ofNullable(flinkParameters.getDeployMode()).orElse(DEFAULT_DEPLOY_MODE);
        String flinkVersion = flinkParameters.getFlinkVersion();
        switch (deployMode) {
            case CLUSTER: {
                if (FLINK_VERSION_AFTER_OR_EQUALS_1_12.equals(flinkVersion) || FLINK_VERSION_AFTER_OR_EQUALS_1_13.equals(flinkVersion)) {
                    args.add("run");
                    args.add("-t");
                    args.add("yarn-per-job");
                    break;
                }
                args.add("run");
                args.add("-m");
                args.add("yarn-cluster");
                break;
            }
            case APPLICATION: {
                args.add("run-application");
                args.add("-t");
                args.add("yarn-application");
                break;
            }
            case LOCAL: {
                args.add("run");
                break;
            }
            case STANDALONE: {
                args.add("run");
            }
        }
        String others = flinkParameters.getOthers();
        switch (deployMode) {
            case CLUSTER: 
            case APPLICATION: {
                String taskManagerMemory;
                String jobManagerMemory;
                int taskManager;
                String appName;
                int slot = flinkParameters.getSlot();
                if (slot > 0) {
                    args.add("-ys");
                    args.add(String.format("%d", slot));
                }
                if (StringUtils.isNotEmpty((CharSequence)(appName = flinkParameters.getAppName()))) {
                    args.add("-ynm");
                    args.add(ArgsUtils.escape((String)appName));
                }
                if ((flinkVersion == null || FLINK_VERSION_BEFORE_1_10.equals(flinkVersion)) && (taskManager = flinkParameters.getTaskManager()) > 0) {
                    args.add("-yn");
                    args.add(String.format("%d", taskManager));
                }
                if (StringUtils.isNotEmpty((CharSequence)(jobManagerMemory = flinkParameters.getJobManagerMemory()))) {
                    args.add("-yjm");
                    args.add(jobManagerMemory);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(taskManagerMemory = flinkParameters.getTaskManagerMemory()))) break;
                args.add("-ytm");
                args.add(taskManagerMemory);
                break;
            }
            case LOCAL: {
                break;
            }
        }
        int parallelism = flinkParameters.getParallelism();
        if (parallelism > 0) {
            args.add("-p");
            args.add(String.format("%d", parallelism));
        }
        args.add("-sae");
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        this.determinedYarnQueue(args, flinkParameters, deployMode, flinkVersion);
        ProgramType programType = flinkParameters.getProgramType();
        String mainClass = flinkParameters.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("-c");
            args.add(flinkParameters.getMainClass());
        }
        if ((mainJar = flinkParameters.getMainJar()) != null) {
            String name;
            if (ProgramType.PYTHON == programType) {
                args.add("-py");
            }
            if ((name = mainJar.getResourceName()) == null && mainJar.getId() != null) {
                name = this.getResourceNameById(mainJar.getId());
            }
            args.add(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = flinkParameters.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    private void determinedYarnQueue(List<String> args, FlinkParameters flinkParameters, FlinkDeployMode deployMode, String flinkVersion) {
        switch (deployMode) {
            case CLUSTER: {
                if (FLINK_VERSION_AFTER_OR_EQUALS_1_12.equals(flinkVersion) || FLINK_VERSION_AFTER_OR_EQUALS_1_13.equals(flinkVersion)) {
                    this.doAddQueue(args, flinkParameters, "-Dyarn.application.queue");
                    break;
                }
                this.doAddQueue(args, flinkParameters, "-yqu");
                break;
            }
            case APPLICATION: {
                this.doAddQueue(args, flinkParameters, "-Dyarn.application.queue");
            }
        }
    }

    private void doAddQueue(List<String> args, FlinkParameters flinkParameters, String option) {
        String yarnQueue;
        String others = flinkParameters.getOthers();
        if ((StringUtils.isEmpty((CharSequence)others) || !others.contains(option)) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = flinkParameters.getYarnQueue()))) {
            switch (option) {
                case "-Dyarn.application.queue": {
                    args.add(String.format("-Dyarn.application.queue=%s", yarnQueue));
                    break;
                }
                case "-yqu": {
                    args.add("-yqu");
                    args.add(yarnQueue);
                }
            }
        }
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.flinkNodeType");
        String defaultConvertType = CodeProgramType.DIDE_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }

    private String getSqlConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.flinkSqlNodeType");
        if (convertType == null) {
            convertType = this.properties.getProperty("workflow.converter.flinkNodeType");
        }
        String defaultConvertType = CodeProgramType.FLINK_SQL_BATCH.name();
        return this.getConverterType(convertType, defaultConvertType);
    }

    private String getPythonConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.flinkPythonNodeType");
        String defaultConvertType = CodeProgramType.PYTHON.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

