/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecSubFlow;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.V3ProcessDefinitionConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV3WorkflowConverter {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV3WorkflowConverter.class);
    public static final String SPEC_VERSION = "1.2.0";
    private DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> dolphinSchedulerPackage;
    private final List<DagData> dagDataList;
    private final Properties converterProperties;

    public DolphinSchedulerV3WorkflowConverter(DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> dolphinSchedulerPackage, Properties converterProperties) {
        this.dolphinSchedulerPackage = dolphinSchedulerPackage;
        this.converterProperties = converterProperties;
        this.dagDataList = dolphinSchedulerPackage.getProcessDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (this.dagDataList.isEmpty()) {
            throw new RuntimeException("process list empty");
        }
    }

    public List<Specification<DataWorksWorkflowSpec>> convert() {
        ArrayList<Specification<DataWorksWorkflowSpec>> specifications = new ArrayList<Specification<DataWorksWorkflowSpec>>();
        this.preHandleSubProcess(this.dagDataList);
        for (DagData dagData : this.dagDataList) {
            ArrayList<SpecWorkflow> workflows = new ArrayList<SpecWorkflow>();
            Specification specification = new Specification();
            specification.setKind(SpecKind.CYCLE_WORKFLOW.getLabel());
            specification.setVersion(SPEC_VERSION);
            DataWorksWorkflowSpec spec = new DataWorksWorkflowSpec();
            String processName = dagData.getProcessDefinition().getName();
            spec.setName(processName);
            V3ProcessDefinitionConverter converter = new V3ProcessDefinitionConverter(dagData, this.converterProperties);
            SpecWorkflow workflow = converter.convert();
            if (workflow == null) continue;
            workflows.add(workflow);
            spec.setWorkflows(workflows);
            specification.setSpec((Spec)spec);
            specifications.add((Specification<DataWorksWorkflowSpec>)specification);
        }
        this.handleSubprocess();
        this.handleDependents(specifications);
        return specifications;
    }

    private void preHandleSubProcess(List<DagData> dagDataList) {
        for (DagData dagData : ListUtils.emptyIfNull(dagDataList)) {
            dagData.getTaskDefinitionList().stream().filter(task -> TaskType.SUB_PROCESS.name().equalsIgnoreCase(task.getTaskType())).forEach(task -> {
                JsonObject jsonObject = (JsonObject)GsonUtils.fromJsonString((String)task.getTaskParams(), JsonObject.class);
                if (jsonObject.has("processDefinitionCode")) {
                    Long processDefCode = jsonObject.get("processDefinitionCode").getAsLong();
                    DolphinSchedulerV3Context.getContext().putSubProcessCodeOutMap(processDefCode, String.valueOf(processDefCode));
                }
            });
        }
    }

    private void handleSubprocess() {
        Map codeWorkflowMap = DolphinSchedulerV3Context.getContext().getSubProcessCodeWorkflowMap();
        Map codeNodeMap = DolphinSchedulerV3Context.getContext().getSubProcessCodeNodeMap();
        for (Map.Entry entry : codeNodeMap.entrySet()) {
            SpecNodeOutput specNodeOutput;
            SpecWorkflow specWorkflow = (SpecWorkflow)codeWorkflowMap.get(entry.getKey());
            if (specWorkflow == null) continue;
            if (specWorkflow.getOutputs().isEmpty()) {
                specNodeOutput = new SpecNodeOutput();
                specNodeOutput.setData(specWorkflow.getId());
                specWorkflow.getOutputs().add(specNodeOutput);
            } else {
                specNodeOutput = (SpecNodeOutput)specWorkflow.getOutputs().get(0);
            }
            SpecNode subprocess = (SpecNode)entry.getValue();
            SpecSubFlow subflow = new SpecSubFlow();
            subflow.setOutput(specNodeOutput.getData());
            subprocess.setSubflow(subflow);
        }
    }

    private void handleDependents(List<Specification<DataWorksWorkflowSpec>> specifications) {
        HashMap<String, SpecWorkflow> nodeIdWorkflowMap = new HashMap<String, SpecWorkflow>();
        for (Specification<DataWorksWorkflowSpec> specification : specifications) {
            ((DataWorksWorkflowSpec)specification.getSpec()).getWorkflows().forEach(workflow -> workflow.getNodes().forEach(node -> nodeIdWorkflowMap.put(node.getId(), (SpecWorkflow)workflow)));
        }
        Map taskCodeSpecNodeMap = DolphinSchedulerV3Context.getContext().getTaskCodeSpecNodeMap();
        Map depMap = DolphinSchedulerV3Context.getContext().getSpecNodeProcessCodeMap();
        for (Map.Entry entry : depMap.entrySet()) {
            SpecNode specNode = (SpecNode)entry.getKey();
            SpecWorkflow workflow2 = (SpecWorkflow)nodeIdWorkflowMap.get(specNode.getId());
            SpecFlowDepend specFlowDepend = new SpecFlowDepend();
            List dependents = (List)entry.getValue();
            ArrayList<SpecDepend> depends = new ArrayList<SpecDepend>();
            for (Long code : dependents) {
                SpecNode depNode = (SpecNode)taskCodeSpecNodeMap.get(code);
                if (depNode == null) {
                    log.warn("can not find spec node: {}", (Object)code);
                    continue;
                }
                SpecNodeOutput specNodeOutput = new SpecNodeOutput();
                List outputs = depNode.getOutputs();
                String data = depNode.getId();
                if (CollectionUtils.isNotEmpty((Collection)outputs)) {
                    data = ((SpecNodeOutput)outputs.get(0)).getData();
                }
                specNodeOutput.setData(data);
                SpecDepend specDepend = new SpecDepend(null, DependencyType.NORMAL, specNodeOutput);
                depends.add(specDepend);
            }
            specFlowDepend.setDepends(depends);
            specFlowDepend.setNodeId(specNode);
            workflow2.getDependencies().add(specFlowDepend);
        }
        this.mergeDeps(nodeIdWorkflowMap);
    }

    private void mergeDeps(Map<String, SpecWorkflow> nodeIdWorkflowMap) {
        nodeIdWorkflowMap.values().stream().forEach(workflow -> {
            List depends = workflow.getDependencies();
            if (CollectionUtils.isNotEmpty((Collection)depends)) {
                HashMap map = new HashMap();
                depends.stream().forEach(dep -> {
                    ArrayList specNodes = (ArrayList)map.get(dep.getNodeId());
                    if (CollectionUtils.isNotEmpty((Collection)specNodes)) {
                        specNodes.addAll(dep.getDepends());
                    } else {
                        specNodes = new ArrayList();
                        specNodes.addAll(dep.getDepends());
                        map.put(dep.getNodeId(), specNodes);
                    }
                });
                ArrayList<SpecFlowDepend> specFlowDepends = new ArrayList<SpecFlowDepend>();
                for (Map.Entry entry : map.entrySet()) {
                    SpecFlowDepend specFlowDepend = new SpecFlowDepend();
                    specFlowDepend.setNodeId((SpecNode)entry.getKey());
                    specFlowDepend.setDepends((List)entry.getValue());
                    specFlowDepends.add(specFlowDepend);
                }
                workflow.setDependencies(specFlowDepends);
            }
        });
    }
}

