/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkParameterConverter
extends AbstractParameterConverter<SparkParameters> {
    private static final Logger log = LoggerFactory.getLogger(SparkParameterConverter.class);

    public SparkParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String type = this.getSparkConverterType();
        dwNode.setType(CodeProgramType.of((String)type).name());
        Map<String, String> resourcePair = this.handleResourcesReference();
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (resourcePair != null) {
            resourceNames.addAll(resourcePair.values());
        }
        if (CodeProgramType.EMR_SPARK.equals((Object)CodeProgramType.of((String)type))) {
            List<String> cmd = this.populateSparkOptions(type, resourceNames);
            String code = String.join((CharSequence)" ", cmd);
            code = this.replaceCode(code, dwNode);
            code = this.replaceResourceFullName(resourcePair, code);
            dwNode.setCode(code);
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        } else if (CodeProgramType.ODPS_SPARK.equals((Object)CodeProgramType.of((String)type))) {
            OdpsSparkCode odpsSparkCode = this.populateSparkOdpsCode(resourceNames);
            String code = odpsSparkCode.toString();
            code = this.replaceCode(code, dwNode);
            code = this.replaceResourceFullName(resourcePair, code);
            dwNode.setCode(code);
        }
        return Arrays.asList(dwNode);
    }

    private List<String> populateSparkOptions(String codeType, Collection<String> resourceNames) {
        String yarnQueue;
        String deployMode;
        ArrayList<String> args = new ArrayList<String>();
        SparkParameters sparkParameters = (SparkParameters)this.parameter;
        ProgramType programType = sparkParameters.getProgramType();
        ResourceInfo mainJar = sparkParameters.getMainJar();
        if (programType != ProgramType.SQL) {
            String resourceName = mainJar.getResourceName();
            if (StringUtils.isEmpty((CharSequence)resourceName)) {
                resourceName = this.getResourceNameById(mainJar.getId());
            }
            if (resourceName != null) {
                resourceNames.add(resourceName);
                mainJar.setResourceName(resourceName);
                args.add("spark-submit");
            } else {
                args.add("spark-submit");
            }
        } else {
            args.add("spark-submit");
        }
        String ref = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.of((String)codeType), (String)"", resourceNames);
        args.add(0, ref);
        String string = deployMode = StringUtils.isNotEmpty((CharSequence)sparkParameters.getDeployMode()) ? sparkParameters.getDeployMode() : "local";
        if (!"local".equals(deployMode)) {
            args.add("--master");
            String masterUrl = "yarn";
            args.add(masterUrl);
        }
        args.add("--deploy-mode");
        args.add(deployMode);
        String mainClass = sparkParameters.getMainClass();
        if (programType != ProgramType.PYTHON && programType != ProgramType.SQL && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("--class");
            args.add(mainClass);
        }
        this.populateSparkResourceDefinitions(args, sparkParameters);
        String appName = sparkParameters.getAppName();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            args.add("--name");
            args.add(ArgsUtils.escape((String)appName));
        }
        String others = sparkParameters.getOthers();
        if (!"local".equals(deployMode) && (StringUtils.isEmpty((CharSequence)others) || !others.contains("--queue")) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = sparkParameters.getYarnQueue()))) {
            args.add("--queue");
            args.add(yarnQueue);
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (programType != ProgramType.SQL && mainJar != null) {
            args.add(mainJar.getResourceName());
        }
        String mainArgs = sparkParameters.getMainArgs();
        if (programType != ProgramType.SQL && StringUtils.isNotEmpty((CharSequence)mainArgs)) {
            args.add(mainArgs);
        }
        return args;
    }

    private OdpsSparkCode populateSparkOdpsCode(Collection<String> resourceNames) {
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        odpsSparkCode.setResourceReferences(new ArrayList());
        odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
        ResourceInfo mainJar = ((SparkParameters)this.parameter).getMainJar();
        String resource = mainJar.getResourceName();
        if (StringUtils.isEmpty((CharSequence)resource)) {
            resource = this.getResourceNameById(mainJar.getId());
        }
        if (resource != null) {
            mainJar.setResourceName(resource);
            odpsSparkCode.getResourceReferences().add(resource);
            odpsSparkCode.getSparkJson().setMainJar(resource);
        }
        if (CollectionUtils.isNotEmpty(resourceNames)) {
            odpsSparkCode.getResourceReferences().addAll(resourceNames);
        }
        String mainClass = ((SparkParameters)this.parameter).getMainClass();
        odpsSparkCode.getSparkJson().setMainClass(mainClass);
        odpsSparkCode.getSparkJson().setVersion("2.x");
        odpsSparkCode.getSparkJson().setLanguage("java");
        String mainArgs = ((SparkParameters)this.parameter).getMainArgs();
        odpsSparkCode.getSparkJson().setArgs(mainArgs);
        ArrayList<String> confs = new ArrayList<String>();
        this.populateOdpsSparkResourceDefinitions(confs, (SparkParameters)this.parameter);
        odpsSparkCode.getSparkJson().setConfigs(confs);
        return odpsSparkCode;
    }

    private void populateSparkResourceDefinitions(List<String> args, SparkParameters sparkParameters) {
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores = sparkParameters.getDriverCores();
        if (driverCores > 0) {
            args.add(String.format("--conf spark.driver.cores=%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = sparkParameters.getDriverMemory()))) {
            args.add(String.format("--conf spark.driver.memory=%s", driverMemory));
        }
        if ((numExecutors = sparkParameters.getNumExecutors()) > 0) {
            args.add(String.format("--conf spark.executor.instances=%d", numExecutors));
        }
        if ((executorCores = sparkParameters.getExecutorCores()) > 0) {
            args.add(String.format("--conf spark.executor.cores=%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = sparkParameters.getExecutorMemory()))) {
            args.add(String.format("--conf spark.executor.memory=%s", executorMemory));
        }
    }

    private void populateOdpsSparkResourceDefinitions(List<String> args, SparkParameters sparkParameters) {
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores = sparkParameters.getDriverCores();
        if (driverCores > 0) {
            args.add(String.format("spark.driver.cores=%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = sparkParameters.getDriverMemory()))) {
            args.add(String.format("spark.driver.memory=%s", driverMemory));
        }
        if ((numExecutors = sparkParameters.getNumExecutors()) > 0) {
            args.add(String.format("spark.executor.instances=%d", numExecutors));
        }
        if ((executorCores = sparkParameters.getExecutorCores()) > 0) {
            args.add(String.format("spark.executor.cores=%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = sparkParameters.getExecutorMemory()))) {
            args.add(String.format("spark.executor.memory=%s", executorMemory));
        }
    }

    private String getSparkConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.sparkSubmitAs");
        String defaultConvertType = CodeProgramType.EMR_SPARK_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

