/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellParameterConverter
extends AbstractParameterConverter<ShellParameters> {
    private static final Logger log = LoggerFactory.getLogger(ShellParameterConverter.class);

    public ShellParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String convertType = this.getShellConverterType();
        dwNode.setType(convertType);
        dwNode.setCode(((ShellParameters)this.parameter).getRawScript());
        List resources = ListUtils.emptyIfNull((List)((ShellParameters)this.parameter).getResourceFilesList()).stream().map(ResourceInfo::getResourceName).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.DIDE_SHELL.name(), (CharSequence)dwNode.getType())) {
            dwNode.setParameter(Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)((ShellParameters)this.parameter).getLocalParams()).stream().map(Property::getValue).collect(Collectors.toList())));
            String codeArgPredefine = ListUtils.emptyIfNull((List)((ShellParameters)this.parameter).getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.joining("\n"));
            codeLines.add(codeArgPredefine);
        }
        codeLines.add(((ShellParameters)this.parameter).getRawScript());
        String code = Joiner.on((String)"\n").join(codeLines);
        code = this.replaceCode(code, dwNode);
        Map<String, String> resourceMap = this.handleResourcesReference();
        code = this.replaceResourceFullName(resourceMap, code);
        dwNode.setCode(code);
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_SHELL.name(), (CharSequence)dwNode.getType())) {
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        }
        return Arrays.asList(dwNode);
    }

    private String getShellConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.shellNodeType");
        String defaultConvertType = CodeProgramType.DIDE_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }

    private String getSQLConverterType(String defaultConvertType) {
        String convertType = this.properties.getProperty("workflow.converter.commandSqlAs");
        return this.getConverterType(convertType, defaultConvertType);
    }
}

