/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.ResourceType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonParameterConverter
extends AbstractParameterConverter<PythonParameters> {
    private static final Logger log = LoggerFactory.getLogger(PythonParameterConverter.class);

    public PythonParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String shellType = this.getConverterType();
        String type = this.properties.getProperty("workflow.converter.pythonNodeType", shellType);
        dwNode.setType(type);
        String usingCmd = this.properties.getProperty("workflow.converter.dolphinscheduler.python.code.block", "false");
        if (Boolean.parseBoolean(usingCmd)) {
            String cmd = "python -c \"" + ((PythonParameters)this.parameter).getRawScript() + "\"";
            cmd = this.replaceCode(cmd, dwNode);
            dwNode.setCode(cmd);
        } else if (CodeProgramType.ODPS_PYTHON.equals((Object)CodeProgramType.of((String)type)) || CodeProgramType.PYODPS.equals((Object)CodeProgramType.of((String)type)) || CodeProgramType.PYODPS3.equals((Object)CodeProgramType.of((String)type))) {
            String code = ((PythonParameters)this.parameter).getRawScript();
            code = this.replaceCode(code, dwNode);
            dwNode.setCode(code);
        } else {
            DataWorksTransformerConfig config;
            ArrayList<String> paths;
            DwResource pyRes = new DwResource();
            pyRes.setName(Joiner.on((String)"_").join((Object)this.processMeta.getName(), (Object)this.taskDefinition.getName(), new Object[0]) + ".py");
            pyRes.setWorkflowRef(this.dwWorkflow);
            this.dwWorkflow.getResources().add(pyRes);
            String engineType = this.properties.getProperty("workflow.converter.target.engine.type", "");
            if (StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.EMR.name(), (CharSequence)engineType)) {
                pyRes.setType(CodeProgramType.EMR_FILE.name());
                pyRes.setExtend(ResourceType.PYTHON.name());
                dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
                paths = new ArrayList<String>();
                config = DataWorksTransformerConfig.getConfig();
                if (config != null) {
                    paths.add(CalcEngineType.EMR.getDisplayName(config.getLocale()));
                    paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
                } else {
                    paths.add(CalcEngineType.EMR.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                    paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                }
                pyRes.setFolder(Joiner.on((String)File.separator).join(paths));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.HADOOP_CDH.name(), (CharSequence)engineType)) {
                pyRes.setExtend(ResourceType.PYTHON.name());
                pyRes.setType(CodeProgramType.CDH_FILE.name());
                paths = new ArrayList();
                config = DataWorksTransformerConfig.getConfig();
                if (config != null) {
                    paths.add(CalcEngineType.HADOOP_CDH.getDisplayName(config.getLocale()));
                    paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
                } else {
                    paths.add(CalcEngineType.HADOOP_CDH.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                    paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                }
                pyRes.setFolder(Joiner.on((String)File.separator).join(paths));
            } else {
                pyRes.setExtend(ResourceType.PYTHON.name());
                pyRes.setType(CodeProgramType.of((String)type).getName());
                paths = new ArrayList();
                config = DataWorksTransformerConfig.getConfig();
                if (config != null) {
                    paths.add(CalcEngineType.ODPS.getDisplayName(config.getLocale()));
                    paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
                } else {
                    paths.add(CalcEngineType.ODPS.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                    paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                }
                pyRes.setFolder(Joiner.on((String)File.separator).join(paths));
            }
            File tmpFIle = new File(FileUtils.getTempDirectory(), pyRes.getName());
            FileUtils.writeStringToFile((File)tmpFIle, (String)((PythonParameters)this.parameter).getRawScript(), (Charset)StandardCharsets.UTF_8);
            pyRes.setLocalPath(tmpFIle.getAbsolutePath());
            Map<String, String> resourceMap = this.handleResourcesReference();
            ArrayList<String> resources = new ArrayList<String>();
            if (resourceMap != null) {
                resources.addAll(resourceMap.values());
            }
            resources.add(pyRes.getName());
            String code = Joiner.on((String)"\n").join((Object)DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.of((String)dwNode.getType()), (String)"", resources), (Object)("python ./" + pyRes.getName()), new Object[0]);
            code = this.replaceCode(code, dwNode);
            code = this.replaceResourceFullName(resourceMap, code);
            dwNode.setCode(code);
            if (type.equals(CodeProgramType.EMR_SHELL.name())) {
                dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
            }
        }
        return Arrays.asList(dwNode);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.shellNodeType");
        String defaultConvertType = CodeProgramType.DIDE_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

