/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkParameterConverter
extends AbstractParameterConverter<SparkParameters> {
    private static final Logger log = LoggerFactory.getLogger(SparkParameterConverter.class);
    private static final String SQL_EXECUTION_TYPE_FILE = "FILE";
    private static final String RESOURCE_REFERENCE_SQL_PREFIX = "--";

    public SparkParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        String type = this.getConverterType();
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = this.convertCode(codeProgramType);
        code = this.replaceCodeWithParams(code, specVariableList);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        this.postHandle("SPARK", script);
    }

    public String convertCode(CodeProgramType codeProgramType) {
        if (CodeProgramType.EMR_SPARK.equals((Object)codeProgramType)) {
            List<String> cmd = this.populateSparkOptions((SparkParameters)this.parameter);
            String code = String.join((CharSequence)" ", cmd);
            return code;
        }
        if (CodeProgramType.ODPS_SPARK.equals((Object)codeProgramType)) {
            OdpsSparkCode odpsSparkCode = this.populateSparkOdpsCode();
            return odpsSparkCode.toString();
        }
        throw new IllegalArgumentException("Unsupported code program type: " + codeProgramType);
    }

    private List<String> populateSparkOptions(SparkParameters sparkParameters) {
        String others;
        String deployMode;
        ArrayList<String> args = new ArrayList<String>();
        ProgramType programType = sparkParameters.getProgramType();
        ResourceInfo mainJar = sparkParameters.getMainJar();
        if (programType != ProgramType.SQL) {
            String resource = mainJar.getName();
            if (resource != null) {
                String[] resources = resource.split("/");
                if (resources.length > 0) {
                    resource = resources[resources.length - 1];
                }
            } else {
                DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
                resource = CollectionUtils.emptyIfNull((Collection)context.getResources()).stream().filter(r -> r.getId() == mainJar.getId()).findAny().map(r -> r.getName()).orElse(null);
                mainJar.setName(resource);
            }
            String dwResource = "##@resource_reference{\"" + resource + "\"} \n";
            args.add(dwResource + "spark-submit");
        } else {
            args.add("spark-submit");
        }
        String string = deployMode = StringUtils.isNotEmpty((CharSequence)sparkParameters.getDeployMode()) ? sparkParameters.getDeployMode() : "local";
        if (!"local".equals(deployMode)) {
            args.add("--master");
            String masterUrl = "yarn";
            args.add(masterUrl);
        }
        args.add("--deploy-mode");
        args.add(deployMode);
        String mainClass = sparkParameters.getMainClass();
        if (programType != ProgramType.PYTHON && programType != ProgramType.SQL && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("--class");
            args.add(mainClass);
        }
        this.populateSparkResourceDefinitions(args, sparkParameters);
        String appName = sparkParameters.getAppName();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            args.add("--name");
            args.add(ArgsUtils.escape((String)appName));
        }
        if (StringUtils.isNotEmpty((CharSequence)(others = sparkParameters.getOthers()))) {
            args.add(others);
        }
        if (programType != ProgramType.SQL && mainJar != null) {
            args.add(mainJar.getName());
        }
        String mainArgs = sparkParameters.getMainArgs();
        if (programType != ProgramType.SQL && StringUtils.isNotEmpty((CharSequence)mainArgs)) {
            args.add(mainArgs);
        }
        return args;
    }

    private OdpsSparkCode populateSparkOdpsCode() {
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        odpsSparkCode.setResourceReferences(new ArrayList());
        odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
        ResourceInfo mainJar = ((SparkParameters)this.parameter).getMainJar();
        String resource = mainJar.getName();
        if (StringUtils.isEmpty((CharSequence)resource)) {
            resource = this.getResourceName(mainJar.getId());
        }
        if (resource != null) {
            String[] resources = resource.split("/");
            if (resources.length > 0) {
                resource = resources[resources.length - 1];
            }
            mainJar.setName(resource);
            odpsSparkCode.getResourceReferences().add(resource);
            odpsSparkCode.getSparkJson().setMainJar(resource);
        }
        String mainClass = ((SparkParameters)this.parameter).getMainClass();
        odpsSparkCode.getSparkJson().setMainClass(mainClass);
        odpsSparkCode.getSparkJson().setVersion("2.x");
        odpsSparkCode.getSparkJson().setLanguage("java");
        String mainArgs = ((SparkParameters)this.parameter).getMainArgs();
        odpsSparkCode.getSparkJson().setArgs(mainArgs);
        ArrayList<String> confs = new ArrayList<String>();
        this.populateOdpsSparkResourceDefinitions(confs, (SparkParameters)this.parameter);
        odpsSparkCode.getSparkJson().setConfigs(confs);
        return odpsSparkCode;
    }

    private void populateOdpsSparkResourceDefinitions(List<String> args, SparkParameters sparkParameters) {
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores = sparkParameters.getDriverCores();
        if (driverCores > 0) {
            args.add(String.format("spark.driver.cores=%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = sparkParameters.getDriverMemory()))) {
            args.add(String.format("spark.driver.memory=%s", driverMemory));
        }
        if ((numExecutors = sparkParameters.getNumExecutors()) > 0) {
            args.add(String.format("spark.executor.instances=%d", numExecutors));
        }
        if ((executorCores = sparkParameters.getExecutorCores()) > 0) {
            args.add(String.format("spark.executor.cores=%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = sparkParameters.getExecutorMemory()))) {
            args.add(String.format("spark.executor.memory=%s", executorMemory));
        }
    }

    private void populateSparkResourceDefinitions(List<String> args, SparkParameters sparkParameters) {
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores = sparkParameters.getDriverCores();
        if (driverCores > 0) {
            args.add(String.format("--conf spark.driver.cores=%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = sparkParameters.getDriverMemory()))) {
            args.add(String.format("--conf spark.driver.memory=%s", driverMemory));
        }
        if ((numExecutors = sparkParameters.getNumExecutors()) > 0) {
            args.add(String.format("--conf spark.executor.instances=%d", numExecutors));
        }
        if ((executorCores = sparkParameters.getExecutorCores()) > 0) {
            args.add(String.format("--conf spark.executor.cores=%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = sparkParameters.getExecutorMemory()))) {
            args.add(String.format("--conf spark.executor.memory=%s", executorMemory));
        }
    }

    private String getResourceName(Integer id) {
        if (id == null) {
            return null;
        }
        DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
        return CollectionUtils.emptyIfNull((Collection)context.getResources()).stream().filter(r -> r.getId() == id.intValue()).findAny().map(r -> {
            String name = r.getName();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = r.getResourceName();
            }
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = r.getFullName();
            }
            return name;
        }).orElse(null);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.sparkSubmitAs");
        String defaultConvertType = CodeProgramType.EMR_SPARK_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

