/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentParameterConverter
extends AbstractParameterConverter<DependentParameters> {
    private static final Logger log = LoggerFactory.getLogger(DependentParameterConverter.class);

    public DependentParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        CodeProgramType codeProgramType = CodeProgramType.VIRTUAL;
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
        List<Long> deps = this.convertDeps();
        context.getSpecNodeProcessCodeMap().put(specNode, deps);
        this.postHandle("DEPENDENT", script);
    }

    public List<Long> convertDeps() {
        log.info("params : {}", (Object)this.taskDefinition.getTaskParams());
        JsonObject param = (JsonObject)GsonUtils.fromJsonString((String)this.taskDefinition.getTaskParams(), JsonObject.class);
        DependentParameters dependentParameters = null;
        if (param.get("dependence") != null) {
            dependentParameters = (DependentParameters)GsonUtils.fromJson((JsonObject)param.getAsJsonObject("dependence"), DependentParameters.class);
        }
        if (dependentParameters == null || dependentParameters.getDependTaskList() == null || dependentParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)this.taskDefinition.getTaskParams());
            return Collections.emptyList();
        }
        DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
        List dependencies = dependentParameters.getDependTaskList();
        ArrayList<Long> codes = new ArrayList<Long>();
        ListUtils.emptyIfNull((List)dependencies).forEach(dependModel -> ListUtils.emptyIfNull((List)dependModel.getDependItemList()).forEach(depItem -> {
            long depCode = depItem.getDepTaskCode();
            if (depCode == 0L) {
                List taskDefinitions = (List)context.getProcessCodeTaskRelationMap().get(depItem.getDefinitionCode());
                for (TaskDefinition task : CollectionUtils.emptyIfNull((Collection)taskDefinitions)) {
                    if (codes.contains(task.getCode())) continue;
                    codes.add(task.getCode());
                }
            } else if (!codes.contains(depCode)) {
                codes.add(depCode);
            }
        }));
        return codes;
    }
}

