/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerBranchCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.FailureStrategy;
import com.aliyun.dataworks.common.spec.domain.enums.NodeInstanceModeType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRerunModeType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecBranches;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScheduleStrategy;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.Priority;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.ReleaseState;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.CheckPoint;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.StoreWriter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.filters.DolphinSchedulerConverterFilter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils.DolphinFilter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.ParamListConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.SpecFlowDependConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.TaskConverterFactoryV2;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.TriggerConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.exception.UnSupportedTypeException;
import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.UuidGenerators;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2ProcessDefinitionConverter {
    private static final Logger log = LoggerFactory.getLogger(V2ProcessDefinitionConverter.class);
    private List<SpecNode> specNodes = new ArrayList<SpecNode>();
    private static final SpecScriptRuntime WORKFLOW_RUNTIME = new SpecScriptRuntime();
    private static final SpecScriptRuntime MANUAL_WORKFLOW_RUNTIME = new SpecScriptRuntime();
    private ProcessDefinition processDefinition;
    private DagData dagData;
    private Properties converterProperties;
    private List<TaskDefinition> taskDefinitionList;
    private DolphinSchedulerConverterFilter filter;

    public V2ProcessDefinitionConverter(DagData dagData, Properties converterProperties) {
        this.dagData = dagData;
        this.converterProperties = converterProperties;
        this.processDefinition = dagData.getProcessDefinition();
        this.taskDefinitionList = dagData.getTaskDefinitionList();
        this.filter = new DolphinSchedulerConverterFilter();
    }

    public static String toWorkflowName(ProcessDefinition processDefinition) {
        if (processDefinition.getProjectName() == null) {
            return processDefinition.getName();
        }
        return StringUtils.toValidName((String)Joiner.on((String)"_").join((Object)processDefinition.getProjectName(), (Object)processDefinition.getName(), new Object[0]));
    }

    private SpecWorkflow initWorkflow() {
        SpecWorkflow specWorkflow = new SpecWorkflow();
        specWorkflow.setDependencies(new ArrayList());
        specWorkflow.setNodes(new ArrayList());
        specWorkflow.setInputs(new ArrayList());
        specWorkflow.setOutputs(new ArrayList());
        return specWorkflow;
    }

    public SpecWorkflow convert() {
        log.info("converting processDefinition {}", (Object)this.processDefinition.getName());
        if (!this.willConvert()) {
            return null;
        }
        SpecWorkflow specWorkflow = this.convertProcess(this.processDefinition);
        DolphinSchedulerV2Context.getContext().getSubProcessCodeWorkflowMap().put(this.processDefinition.getCode(), specWorkflow);
        this.convertTaskDefinitions(specWorkflow);
        this.convertTrigger(specWorkflow);
        this.convertTaskRelations(specWorkflow);
        this.handleBranch(specWorkflow);
        return specWorkflow;
    }

    private boolean willConvert() {
        List codes = DolphinSchedulerV2Context.getContext().getSubProcessCodeMap(Long.valueOf(this.processDefinition.getCode()));
        ReleaseState releaseState = this.processDefinition.getReleaseState();
        return DolphinFilter.willConvert(this.processDefinition.getName(), releaseState == null ? null : releaseState.name(), codes);
    }

    protected SpecWorkflow convertProcess(ProcessDefinition processDefinition) {
        log.info("convert workflow,processDefinition: {}", (Object)processDefinition.getName());
        SpecWorkflow specWorkflow = this.initWorkflow();
        specWorkflow.setId(UuidGenerators.generateUuid((Long)processDefinition.getCode()));
        specWorkflow.setName(V2ProcessDefinitionConverter.toWorkflowName(processDefinition));
        specWorkflow.setDescription(processDefinition.getDescription());
        List<SpecVariable> specVariableList = new ParamListConverter(processDefinition.getGlobalParamList()).convert();
        log.info("convert workflow,global params: {}", specVariableList);
        SpecScript script = new SpecScript();
        script.setParameters(specVariableList);
        script.setRuntime(WORKFLOW_RUNTIME);
        script.setPath(this.getScriptPath(specWorkflow.getName()));
        specWorkflow.setScript(script);
        specWorkflow.getOutputs().add(this.buildDefaultOutput(specWorkflow));
        return specWorkflow;
    }

    protected String getScriptPath(String name) {
        String defaultPath = org.apache.commons.lang3.StringUtils.defaultString((String)Config.get().getBasePath(), (String)"");
        return FilenameUtils.concat((String)defaultPath, (String)name);
    }

    protected List<SpecNode> convertTaskDefinitions(SpecWorkflow specWorkflow) {
        return this.convertTasks(specWorkflow);
    }

    protected void convertTrigger(SpecWorkflow specWorkflow) {
        Schedule schedule = this.dagData.getSchedule();
        if (Objects.nonNull(schedule)) {
            SpecTrigger trigger = new TriggerConverter(schedule).convert();
            specWorkflow.setTrigger(trigger);
            specWorkflow.setStrategy(this.buildSpecScheduleStrategy(this.processDefinition, schedule));
            log.info("convert workflow,schedule: {}", (Object)schedule);
        }
    }

    private void handleBranch(SpecWorkflow specWorkflow) {
        Map taskCodeSpecNodeMap = DolphinSchedulerV2Context.getContext().getTaskCodeSpecNodeMap();
        for (SpecNode specNode : specWorkflow.getNodes()) {
            if (specNode.getBranch() == null || specNode.getBranch().getBranches() == null) continue;
            List specBranches = specNode.getBranch().getBranches();
            ArrayList<ControllerBranchCode.Branch> branchList = new ArrayList<ControllerBranchCode.Branch>();
            for (SpecBranches specBranch : specBranches) {
                SpecNodeOutput specNodeOutput = specBranch.getOutput();
                if (specNodeOutput == null || specNodeOutput.getData() == null) continue;
                String data = specNodeOutput.getData();
                Long taskCode = Long.parseLong(data);
                SpecNode branchSpecNode = (SpecNode)taskCodeSpecNodeMap.get(taskCode);
                specNodeOutput.setData(branchSpecNode.getId());
                ControllerBranchCode.Branch branch = new ControllerBranchCode.Branch();
                branch.setCondition(specBranch.getWhen());
                branch.setNodeoutput(branchSpecNode.getId());
                branchList.add(branch);
            }
            if (branchList.size() <= 0) continue;
            String content = GsonUtils.toJsonString(branchList);
            specNode.getScript().setContent(content);
        }
    }

    protected void convertTaskRelations(SpecWorkflow specWorkflow) {
        List processTaskRelationList = this.dagData.getProcessTaskRelationList();
        log.info("convert workflow,processTaskRelationList: {}", (Object)processTaskRelationList);
        new SpecFlowDependConverter(null, specWorkflow, processTaskRelationList).convert();
    }

    private SpecScheduleStrategy buildSpecScheduleStrategy(ProcessDefinition processDefinition, Schedule schedule) {
        SpecScheduleStrategy strategy = new SpecScheduleStrategy();
        strategy.setPriority(this.convertPriority(schedule.getProcessInstancePriority()));
        strategy.setTimeout(Integer.valueOf(processDefinition.getTimeout()));
        strategy.setInstanceMode(NodeInstanceModeType.T_PLUS_1);
        strategy.setRerunMode(NodeRerunModeType.ALL_ALLOWED);
        strategy.setRerunTimes(Integer.valueOf(0));
        strategy.setRerunInterval(Integer.valueOf(0));
        strategy.setIgnoreBranchConditionSkip(Boolean.valueOf(false));
        strategy.setFailureStrategy(com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.FailureStrategy.CONTINUE.equals((Object)schedule.getFailureStrategy()) ? FailureStrategy.CONTINUE : FailureStrategy.BREAK);
        return strategy;
    }

    protected Integer convertPriority(Priority priority) {
        return Priority.LOWEST.getCode() - priority.getCode();
    }

    private SpecNodeOutput buildDefaultOutput(SpecWorkflow specWorkflow) {
        SpecNodeOutput specNodeOutput = new SpecNodeOutput();
        specNodeOutput.setIsDefault(Boolean.valueOf(true));
        String data = String.format("%s.%s", this.processDefinition.getProjectName(), this.processDefinition.getName());
        specNodeOutput.setData(data);
        specNodeOutput.setRefTableName(specWorkflow.getName());
        return specNodeOutput;
    }

    public List<SpecNode> convertTasks(SpecWorkflow specWorkflow) {
        CheckPoint checkPoint = CheckPoint.getInstance();
        String projectName = this.processDefinition.getProjectName();
        String processName = this.processDefinition.getName();
        Map loadedTasks = checkPoint.loadFromCheckPoint(projectName, processName);
        Function<StoreWriter, List> processFunc = writer -> ListUtils.emptyIfNull(this.taskDefinitionList).stream().filter(s -> {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return true;
        }).filter(task -> {
            boolean willConvert = this.filter.filterTasks(projectName, processName, task.getName());
            if (!willConvert) {
                log.warn("task {} not in filterTasks list", (Object)task.getName());
            }
            return willConvert;
        }).map(task -> {
            List<SpecNode> specNodes = this.convertTaskToWorkflowWithLoadedTask(specWorkflow, (TaskDefinition)task, loadedTasks);
            checkPoint.doCheckpoint(writer, specNodes, processName, task.getName());
            return specNodes;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        this.specNodes = checkPoint.doWithCheckpoint(processFunc, projectName);
        log.info("successfully converted {}, size {}", (Object)this.processDefinition.getName(), (Object)this.specNodes.size());
        return this.specNodes;
    }

    private List<SpecNode> convertTaskToWorkflowWithLoadedTask(SpecWorkflow specWorkflow, TaskDefinition taskDefinition, Map<String, List<SpecNode>> loadedTasks) {
        List<SpecNode> specNodes = loadedTasks.get(taskDefinition.getName());
        if (specNodes != null) {
            this.markSuccessProcess(specWorkflow, taskDefinition);
            log.info("loaded task {} from checkpoint", (Object)taskDefinition.getName());
            return specNodes;
        }
        return this.convertTaskDefinition(specWorkflow, taskDefinition);
    }

    private List<SpecNode> convertTaskDefinition(SpecWorkflow specWorkflow, TaskDefinition taskDefinition) {
        if (this.inSkippedList(taskDefinition)) {
            log.warn("task {} in skipped list", (Object)taskDefinition.getName());
            return Collections.emptyList();
        }
        try {
            AbstractParameterConverter converter = TaskConverterFactoryV2.create(this.converterProperties, specWorkflow, this.dagData, taskDefinition);
            SpecNode specNode = converter.convert();
            if (specNode != null) {
                DolphinSchedulerV2Context.getContext().getTaskCodeSpecNodeMap().put(taskDefinition.getCode(), specNode);
                return Arrays.asList(specNode);
            }
            return Collections.emptyList();
        }
        catch (UnSupportedTypeException e) {
            this.markFailedProcess(taskDefinition, e.getMessage());
            if (Config.get().isSkipUnSupportType()) {
                log.warn("task {} with type {} unsupported, skip", (Object)taskDefinition.getTaskType(), (Object)taskDefinition.getName());
                return Collections.emptyList();
            }
            throw e;
        }
        catch (Throwable e) {
            log.error("task converter error, taskName {} ", (Object)taskDefinition.getName(), (Object)e);
            if (Config.get().isTransformContinueWithError()) {
                return Collections.emptyList();
            }
            throw new RuntimeException(e);
        }
    }

    protected void markSuccessProcess(SpecWorkflow workflow, TaskDefinition taskDefinition) {
        for (SpecNode node : workflow.getNodes()) {
            DolphinMetrics metrics = DolphinMetrics.builder().projectName(taskDefinition.getProjectName()).projectCode(Long.valueOf(taskDefinition.getProjectCode())).processName(this.processDefinition.getName()).processCode(Long.valueOf(this.processDefinition.getCode())).taskName(taskDefinition.getName()).taskCode(Long.valueOf(taskDefinition.getCode())).taskType(taskDefinition.getTaskType()).build();
            metrics.setWorkflowName(workflow.getName());
            metrics.setDwName(node.getName());
            String type = node.getScript().getRuntime().getCommand();
            metrics.setDwType(type);
            TransformerContext.getCollector().markSuccessMiddleProcess((Metrics)metrics);
        }
    }

    private boolean inSkippedList(TaskDefinition taskDefinition) {
        if (Config.get().getSkipTypes().contains(taskDefinition.getTaskType()) || Config.get().getSkipTaskCodes().contains(String.valueOf(taskDefinition.getCode()))) {
            log.warn("task name {} code {} in skipped list", (Object)taskDefinition.getName(), (Object)taskDefinition.getCode());
            this.markSkippedProcess(taskDefinition);
            return true;
        }
        return false;
    }

    protected void markFailedProcess(TaskDefinition taskDefinition, String errorMsg) {
        DolphinMetrics metrics = DolphinMetrics.builder().projectName(taskDefinition.getProjectName()).projectCode(Long.valueOf(taskDefinition.getProjectCode())).processName(this.processDefinition.getName()).processCode(Long.valueOf(this.processDefinition.getCode())).taskName(taskDefinition.getName()).taskCode(Long.valueOf(taskDefinition.getCode())).taskType(taskDefinition.getTaskType()).build();
        metrics.setErrorMsg(errorMsg);
        TransformerContext.getCollector().markFailedMiddleProcess((Metrics)metrics);
    }

    protected void markSkippedProcess(TaskDefinition taskDefinition) {
        DolphinMetrics metrics = DolphinMetrics.builder().projectName(taskDefinition.getProjectName()).projectCode(Long.valueOf(taskDefinition.getProjectCode())).processName(this.processDefinition.getName()).processCode(Long.valueOf(this.processDefinition.getCode())).taskName(taskDefinition.getName()).taskCode(Long.valueOf(taskDefinition.getCode())).taskType(taskDefinition.getTaskType()).build();
        TransformerContext.getCollector().markSkippedProcess((Metrics)metrics);
    }

    static {
        WORKFLOW_RUNTIME.setEngine(CodeProgramType.VIRTUAL_WORKFLOW.getCalcEngineType().getLabel());
        WORKFLOW_RUNTIME.setCommand("WORKFLOW");
        MANUAL_WORKFLOW_RUNTIME.setEngine(CodeProgramType.VIRTUAL_WORKFLOW.getCalcEngineType().getLabel());
        MANUAL_WORKFLOW_RUNTIME.setCommand("MANUAL_WORKFLOW");
    }
}

