/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.ReleaseState;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.WorkflowParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.CheckPoint;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.StoreWriter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.filters.DolphinSchedulerConverterFilter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils.DolphinFilter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.ProcessDefinitionConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.TaskConverterFactoryV2;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.exception.UnSupportedTypeException;
import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2ProcessDefinitionConverter
extends ProcessDefinitionConverter<Project, DagData, DataSource, ResourceComponent, UdfFunc> {
    private static final Logger log = LoggerFactory.getLogger(V2ProcessDefinitionConverter.class);
    private List<DwWorkflow> dwWorkflowList = new ArrayList<DwWorkflow>();
    private ProcessDefinition processDefinition;
    private DagData dagData;
    private List<TaskDefinition> taskDefinitionList;
    private DolphinSchedulerConverterFilter filter;

    public V2ProcessDefinitionConverter(DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceComponent, UdfFunc> converterContext, DagData dagData) {
        super(converterContext, dagData);
        this.dagData = dagData;
        this.processDefinition = dagData.getProcessDefinition();
        this.taskDefinitionList = dagData.getTaskDefinitionList();
        this.filter = new DolphinSchedulerConverterFilter();
    }

    public static String toWorkflowName(ProcessDefinition processDefinition) {
        return StringUtils.toValidName((String)Joiner.on((String)"_").join((Object)processDefinition.getProjectName(), (Object)processDefinition.getName(), new Object[0]));
    }

    private boolean willConvert() {
        List codes = DolphinSchedulerV2Context.getContext().getSubProcessCodeMap(Long.valueOf(this.processDefinition.getCode()));
        ReleaseState releaseState = this.processDefinition.getReleaseState();
        return DolphinFilter.willConvert(this.processDefinition.getName(), releaseState == null ? null : releaseState.name(), codes);
    }

    @Override
    public List<DwWorkflow> convert() {
        log.info("converting processDefinition {}", (Object)this.processDefinition.getName());
        if (!this.willConvert()) {
            return Collections.emptyList();
        }
        DwWorkflow dwWorkflow = new DwWorkflow();
        dwWorkflow.setName(V2ProcessDefinitionConverter.toWorkflowName(this.processDefinition));
        dwWorkflow.setType(WorkflowType.BUSINESS);
        dwWorkflow.setScheduled(Boolean.valueOf(true));
        dwWorkflow.setVersion(WorkflowVersion.V3);
        this.converterContext.setDwWorkflow(dwWorkflow);
        dwWorkflow.setParameters(this.getGlobalParams());
        CheckPoint checkPoint = CheckPoint.getInstance();
        String projectName = this.processDefinition.getProjectName();
        String processName = this.processDefinition.getName();
        Map loadedTasks = checkPoint.loadFromCheckPoint(projectName, processName);
        Function<StoreWriter, List> processFunc = writer -> ListUtils.emptyIfNull(this.taskDefinitionList).stream().filter(s -> {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return true;
        }).filter(task -> {
            boolean willConvert = this.filter.filterTasks(projectName, processName, task.getName());
            if (!willConvert) {
                log.warn("task {} not in filter pattern, skip", (Object)task.getName());
            }
            return willConvert;
        }).map(task -> {
            List<DwWorkflow> dwWorkflows = this.convertTaskToWorkflowWithLoadedTask((TaskDefinition)task, loadedTasks);
            checkPoint.doCheckpoint(writer, dwWorkflows, processName, task.getName());
            return dwWorkflows;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        this.dwWorkflowList = checkPoint.doWithCheckpoint(processFunc, projectName);
        if (this.dagData.getSchedule() != null) {
            this.setSchedule(dwWorkflow);
        }
        return this.dwWorkflowList;
    }

    private List<DwWorkflow> convertTaskToWorkflowWithLoadedTask(TaskDefinition taskDefinition, Map<String, List<DwWorkflow>> loadedTasks) {
        List<DwWorkflow> workflows = loadedTasks.get(taskDefinition.getName());
        if (workflows != null) {
            this.markSuccessProcess(workflows, taskDefinition);
            log.info("loaded task {} from checkpoint", (Object)taskDefinition.getName());
            return workflows;
        }
        return this.convertTaskToWorkFlow(taskDefinition);
    }

    protected void markSuccessProcess(List<DwWorkflow> workflows, TaskDefinition taskDefinition) {
        for (DwWorkflow workflow : workflows) {
            for (Node node : workflow.getNodes()) {
                DolphinMetrics metrics = DolphinMetrics.builder().projectName(taskDefinition.getProjectName()).projectCode(Long.valueOf(taskDefinition.getProjectCode())).processName(this.processDefinition.getName()).processCode(Long.valueOf(this.processDefinition.getCode())).taskName(taskDefinition.getName()).taskCode(Long.valueOf(taskDefinition.getCode())).taskType(taskDefinition.getTaskType()).build();
                metrics.setWorkflowName(workflow.getName());
                metrics.setDwName(node.getName());
                metrics.setDwType(node.getType());
                TransformerContext.getCollector().markSuccessMiddleProcess((Metrics)metrics);
            }
        }
    }

    private void setSchedule(DwWorkflow dwWorkflow) {
        Schedule schedule = this.dagData.getSchedule();
        ListUtils.emptyIfNull((List)dwWorkflow.getNodes()).forEach(node -> {
            if (schedule.getCrontab() != null) {
                node.setCronExpress(this.convertCrontab(schedule.getCrontab()));
            }
            if (schedule.getStartTime() != null) {
                node.setStartEffectDate(schedule.getStartTime());
            }
            if (schedule.getEndTime() != null) {
                node.setEndEffectDate(schedule.getEndTime());
            }
        });
    }

    private String getGlobalParams() {
        List parameters = MapUtils.emptyIfNull((Map)this.processDefinition.getGlobalParamMap()).entrySet().stream().map(entry -> new WorkflowParameter().setKey((String)entry.getKey()).setValue((String)entry.getValue())).collect(Collectors.toList());
        return GsonUtils.toJsonString(parameters);
    }

    private List<DwWorkflow> convertTaskToWorkFlow(TaskDefinition taskDefinition) {
        if (this.inSkippedList(taskDefinition)) {
            return Collections.emptyList();
        }
        try {
            AbstractParameterConverter taskConverter = TaskConverterFactoryV2.create(this.dagData, taskDefinition, this.converterContext);
            taskConverter.convert();
            return taskConverter.getWorkflowList();
        }
        catch (UnSupportedTypeException e) {
            this.markFailedProcess(taskDefinition, e.getMessage());
            if (Config.get().isSkipUnSupportType()) {
                log.error("task name {} with type {} unsupported, skip", (Object)taskDefinition.getName(), (Object)taskDefinition.getTaskType());
                return Collections.emptyList();
            }
            throw e;
        }
        catch (Throwable e) {
            log.error("task converter error, taskName {} ", (Object)taskDefinition.getName(), (Object)e);
            if (Config.get().isTransformContinueWithError()) {
                return Collections.emptyList();
            }
            throw new RuntimeException(e);
        }
    }

    private boolean inSkippedList(TaskDefinition taskDefinition) {
        if (Config.get().getSkipTypes().contains(taskDefinition.getTaskType()) || Config.get().getSkipTaskCodes().contains(String.valueOf(taskDefinition.getCode()))) {
            log.warn("task name {} code {} in skipped list", (Object)taskDefinition.getName(), (Object)taskDefinition.getCode());
            this.markSkippedProcess(taskDefinition);
            return true;
        }
        return false;
    }

    @Override
    public List<DwWorkflow> getWorkflowList() {
        return this.dwWorkflowList;
    }

    protected void markSkippedProcess(TaskDefinition taskDefinition) {
        DolphinMetrics metrics = DolphinMetrics.builder().projectName(taskDefinition.getProjectName()).projectCode(Long.valueOf(taskDefinition.getProjectCode())).processName(this.processDefinition.getName()).processCode(Long.valueOf(this.processDefinition.getCode())).taskName(taskDefinition.getName()).taskCode(Long.valueOf(taskDefinition.getCode())).taskType(taskDefinition.getTaskType()).build();
        TransformerContext.getCollector().markSkippedProcess((Metrics)metrics);
    }

    protected void markFailedProcess(TaskDefinition taskDefinition, String errorMsg) {
        DolphinMetrics metrics = DolphinMetrics.builder().projectName(taskDefinition.getProjectName()).projectCode(Long.valueOf(taskDefinition.getProjectCode())).processName(this.processDefinition.getName()).processCode(Long.valueOf(this.processDefinition.getCode())).taskName(taskDefinition.getName()).taskCode(Long.valueOf(taskDefinition.getCode())).taskType(taskDefinition.getTaskType()).build();
        metrics.setErrorMsg(errorMsg);
        TransformerContext.getCollector().markFailedMiddleProcess((Metrics)metrics);
    }
}

