/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParameterConverter
extends AbstractParameterConverter<SqlParameters> {
    private static final Logger log = LoggerFactory.getLogger(SqlParameterConverter.class);

    public SqlParameterConverter(Properties properties, SpecWorkflow specWorkflow, ProcessMeta processMeta, TaskNode taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        String sqlNodeMapStr = this.properties.getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, String>>(){}.getType());
        String type = Optional.ofNullable(sqlTypeNodeTypeMapping).map(s -> (String)s.get(((SqlParameters)this.parameter).getType())).orElseGet(() -> {
            if (DbType.HIVE.equals((Object)((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.EMR_HIVE.name();
            }
            if (DbType.SPARK.equals((Object)((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.EMR_SPARK.name();
            }
            if (((SqlParameters)this.parameter).getType() != null) {
                return ((SqlParameters)this.parameter).getType().name();
            }
            String defaultNodeTypeIfNotSupport = this.getSQLConverterType();
            log.warn("using default node Type {} for node {}", (Object)defaultNodeTypeIfNotSupport, (Object)this.taskDefinition.getName());
            return defaultNodeTypeIfNotSupport;
        });
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String content = ((SqlParameters)this.parameter).getSql();
        if (CodeProgramType.EMR_HIVE.name().equals(codeProgramType) || CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            content = EmrCodeUtils.toEmrCode(codeProgramType, this.taskDefinition.getName(), content);
        }
        script.setContent(content);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
    }

    private String getConnectionName(String codeProgramType) {
        String mappingJson = this.properties.getProperty("workflow.converter.connection.mapping");
        if (StringUtils.isNotEmpty((String)mappingJson)) {
            Map connectionMapping = (Map)JSONUtils.parseObject((String)mappingJson, Map.class);
            if (connectionMapping == null) {
                log.error("parse connection mapping with {} error", (Object)mappingJson);
            } else {
                String connectionName = (String)connectionMapping.get(codeProgramType);
                log.info("Got connectionName {} by {}", (Object)connectionName, (Object)codeProgramType);
                return connectionName;
            }
        }
        if (!CodeProgramType.EMR_HIVE.name().equals(codeProgramType) && !CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            List datasources = DolphinSchedulerV1Context.getContext().getDataSources();
            if (((SqlParameters)this.parameter).getDatasource() > 0) {
                return CollectionUtils.emptyIfNull((Collection)datasources).stream().filter(s -> s.getId() == ((SqlParameters)this.parameter).getDatasource()).findFirst().map(s -> s.getName()).orElse(null);
            }
        }
        return null;
    }

    private String getSQLConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.commandSqlAs");
        return this.getConverterType(convertType, CodeProgramType.SQL_COMPONENT.name());
    }
}

