/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.MapReduceArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrParameterConverter
extends AbstractParameterConverter<MapReduceParameters> {
    private static final Logger log = LoggerFactory.getLogger(MrParameterConverter.class);
    public static final String MR_YARN_QUEUE = "mapreduce.job.queuename";

    public MrParameterConverter(Properties properties, SpecWorkflow specWorkflow, ProcessMeta processMeta, TaskNode taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        SpecScript script = new SpecScript();
        String type = this.getConverterType();
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = this.convertCode(codeProgramType);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
    }

    public String convertCode(CodeProgramType codeProgramType) {
        DolphinSchedulerV1Context context = DolphinSchedulerV1Context.getContext();
        List resourceInfos = context.getResources();
        Optional.ofNullable((MapReduceParameters)this.parameter).map(MapReduceParameters::getMainJar).flatMap(mainJar -> ListUtils.emptyIfNull((List)resourceInfos).stream().filter(res -> Objects.equals(res.getId(), mainJar.getId())).findFirst()).ifPresent(res -> ((MapReduceParameters)this.parameter).setMainJar(res));
        ListUtils.emptyIfNull((List)Optional.ofNullable((MapReduceParameters)this.parameter).map(MapReduceParameters::getResourceFilesList).orElse(ListUtils.emptyIfNull(null))).forEach(res -> ListUtils.emptyIfNull((List)resourceInfos).stream().filter(res1 -> Objects.equals(res1.getId(), res.getId())).forEach(res1 -> BeanUtils.copyProperties((Object)res1, (Object)res)));
        String type = codeProgramType.getName();
        List resources = ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getName).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)type), (String)"", resources));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_MR.name(), (CharSequence)type)) {
            String command = Joiner.on((String)" ").join((Iterable)MapReduceArgsUtils.buildArgs((MapReduceParameters)((MapReduceParameters)this.parameter)).stream().map(String::valueOf).collect(Collectors.toList()));
            codeLines.add(command);
            String code = Joiner.on((String)"\n").join(codeLines);
            code = EmrCodeUtils.toEmrCode(codeProgramType, this.taskDefinition.getName(), code);
            EmrCode emrCode = EmrCodeUtils.asEmrCode(type, code);
            Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
                spec.setQueue(((MapReduceParameters)this.parameter).getQueue());
                emrCode.getLauncher().setAllocationSpec(spec.toMap());
            });
            return emrCode.getContent();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.ODPS_MR.name(), (CharSequence)type)) {
            String command = Joiner.on((String)" ").join((Object)"jar", (Object)"-resources", new Object[]{Optional.ofNullable(((MapReduceParameters)this.parameter).getMainJar().getName()).orElse(""), "-classpath", Joiner.on((String)",").join(resources), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainClass()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainArgs()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getOthers()).orElse("")});
            codeLines.add(command);
            String code = Joiner.on((String)"\n").join(codeLines);
            code = EmrCodeUtils.toEmrCode(codeProgramType, this.taskDefinition.getName(), code);
            EmrCode emrCode = EmrCodeUtils.asEmrCode(type, code);
            Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
                spec.setQueue(((MapReduceParameters)this.parameter).getQueue());
                emrCode.getLauncher().setAllocationSpec(spec.toMap());
            });
            return emrCode.getContent();
        }
        throw new RuntimeException("Unsupported code type: " + type);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.mrNodeType");
        String defaultConvertType = CodeProgramType.EMR_MR.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

