/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.Flag;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.datax.DataxParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.datax.DataxUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.utils.ParameterUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.entity.Connection;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.entity.Parameter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.entity.Step;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataxParameterConverter
extends AbstractParameterConverter<DataxParameters> {
    private static final Logger log = LoggerFactory.getLogger(DataxParameterConverter.class);
    private static final String SELECT_ALL_CHARACTER = "*";
    private static final int DATAX_CHANNEL_COUNT = 1;

    public DataxParameterConverter(Properties properties, SpecWorkflow specWorkflow, ProcessMeta processMeta, TaskNode taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        String type = this.properties.getProperty("workflow.converter.dataxNodeType", CodeProgramType.DI.name());
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String json = this.buildDataxJsonFile(new HashMap<String, Property>());
        script.setContent(json);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
    }

    private String buildDataxJsonFile(Map<String, Property> paramsMap) {
        String json;
        if (((DataxParameters)this.parameter).getCustomConfig() == Flag.YES.ordinal()) {
            json = ((DataxParameters)this.parameter).getJson().replaceAll("\\r\\n", System.lineSeparator());
        } else {
            ObjectNode job = JSONUtils.createObjectNode();
            job.put("transform", false);
            job.put("type", "job");
            job.put("version", "2.0");
            ArrayNode steps = this.buildDataxJobSteps();
            if (steps == null) {
                throw new RuntimeException("steps is null");
            }
            job.putArray("steps").addAll(steps);
            job.set("setting", (JsonNode)this.buildDataxJobSettingJson());
            json = job.toString();
        }
        json = ParameterUtils.convertParameterPlaceholders((String)json, (Map)ParameterUtils.convert(paramsMap));
        log.debug("datax job json : {}", (Object)json);
        return json;
    }

    private ArrayNode buildDataxJobSteps() {
        DataSource source = this.getDataSource(((DataxParameters)this.parameter).getDataSource());
        if (source == null) {
            log.error("source {} is null", (Object)((DataxParameters)this.parameter).getDataSource());
            return null;
        }
        DataSource target = this.getDataSource(((DataxParameters)this.parameter).getDataTarget());
        if (target == null) {
            log.error("target {} is null", (Object)((DataxParameters)this.parameter).getDataTarget());
            return null;
        }
        Step reader = new Step();
        Step writer = new Step();
        reader.setName("Reader");
        reader.setCategory("reader");
        reader.setStepType(source.getType().name().toLowerCase());
        writer.setName("Writer");
        writer.setCategory("writer");
        writer.setStepType(target.getType().name().toLowerCase());
        Parameter readParameter = new Parameter();
        readParameter.setEncoding("UTF-8");
        readParameter.setEnvType(1);
        readParameter.setUseSpecialSecret(false);
        Parameter writeParameter = new Parameter();
        writeParameter.setEncoding("UTF-8");
        writeParameter.setEnvType(1);
        writeParameter.setUseSpecialSecret(false);
        Pair<String, String[]> pair = this.tryGrammaticalAnalysisSqlColumnNames(source.getType(), ((DataxParameters)this.parameter).getSql());
        String[] srcColumnNames = (String[])pair.getRight();
        if (srcColumnNames != null && srcColumnNames.length > 0) {
            readParameter.setColumn(Arrays.asList(srcColumnNames));
            String[] tgtColumnNames = DataxUtils.convertKeywordsColumns((DbType)target.getType(), (String[])srcColumnNames);
            if (tgtColumnNames != null && tgtColumnNames.length > 0) {
                writeParameter.setColumn(Arrays.asList(srcColumnNames));
            }
        }
        Connection sourceConnection = new Connection();
        sourceConnection.setDatasource(source.getName());
        sourceConnection.setTable(Arrays.asList((String)pair.getLeft()));
        readParameter.setConnection(Arrays.asList(sourceConnection));
        Connection targetConnection = new Connection();
        targetConnection.setDatasource(target.getName());
        targetConnection.setTable(Arrays.asList(((DataxParameters)this.parameter).getTargetTable()));
        writeParameter.setConnection(Arrays.asList(targetConnection));
        reader.setParameter(readParameter);
        writer.setParameter(writeParameter);
        ObjectNode steps = JSONUtils.createObjectNode();
        ArrayNode tableArr = steps.putArray("steps");
        JsonNode readerNode = JSONUtils.toJsonNode((Object)reader);
        tableArr.add(readerNode);
        JsonNode writerNode = JSONUtils.toJsonNode((Object)writer);
        tableArr.add(writerNode);
        return tableArr;
    }

    private ObjectNode buildDataxJobSettingJson() {
        ObjectNode speed = JSONUtils.createObjectNode();
        speed.put("channel", 1);
        if (((DataxParameters)this.parameter).getJobSpeedByte() > 0) {
            speed.put("byte", ((DataxParameters)this.parameter).getJobSpeedByte());
        }
        if (((DataxParameters)this.parameter).getJobSpeedRecord() > 0) {
            speed.put("record", ((DataxParameters)this.parameter).getJobSpeedRecord());
        }
        ObjectNode errorLimit = JSONUtils.createObjectNode();
        errorLimit.put("record", 0);
        errorLimit.put("percentage", 0);
        ObjectNode setting = JSONUtils.createObjectNode();
        setting.set("speed", (JsonNode)speed);
        setting.set("errorLimit", (JsonNode)errorLimit);
        return setting;
    }

    private Pair<String, String[]> tryGrammaticalAnalysisSqlColumnNames(DbType dbType, String sql) {
        String[] columnNames;
        String sourceTable = null;
        try {
            SQLStatementParser parser = DataxUtils.getSqlStatementParser((DbType)dbType, (String)sql);
            if (parser == null) {
                log.warn("database driver [{}] is not support grammatical analysis sql", (Object)dbType);
                return Pair.of(null, (Object)new String[0]);
            }
            SQLStatement sqlStatement = parser.parseStatement();
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
            SQLSelect sqlSelect = sqlSelectStatement.getSelect();
            List selectItemList = null;
            if (sqlSelect.getQuery() instanceof SQLSelectQueryBlock) {
                SQLExprTableSource expr;
                SQLSelectQueryBlock block = (SQLSelectQueryBlock)sqlSelect.getQuery();
                selectItemList = block.getSelectList();
                if (block.getFrom() instanceof SQLExprTableSource && (expr = (SQLExprTableSource)block.getFrom()).getExpr() instanceof SQLIdentifierExpr) {
                    sourceTable = ((SQLIdentifierExpr)expr.getExpr()).getName();
                }
            } else if (sqlSelect.getQuery() instanceof SQLUnionQuery) {
                SQLExprTableSource expr;
                SQLUnionQuery unionQuery = (SQLUnionQuery)sqlSelect.getQuery();
                SQLSelectQueryBlock block = (SQLSelectQueryBlock)unionQuery.getRight();
                selectItemList = block.getSelectList();
                if (block.getFrom() instanceof SQLExprTableSource && (expr = (SQLExprTableSource)block.getFrom()).getExpr() instanceof SQLIdentifierExpr) {
                    sourceTable = ((SQLIdentifierExpr)expr.getExpr()).getName();
                }
            }
            if (selectItemList == null) {
                throw new RuntimeException(String.format("select query type [%s] is not support", sqlSelect.getQuery().toString()));
            }
            columnNames = new String[selectItemList.size()];
            for (int i = 0; i < selectItemList.size(); ++i) {
                SQLSelectItem item = (SQLSelectItem)selectItemList.get(i);
                String columnName = null;
                if (item.getAlias() != null) {
                    columnName = item.getAlias();
                } else if (item.getExpr() != null) {
                    SQLPropertyExpr expr;
                    if (item.getExpr() instanceof SQLPropertyExpr) {
                        expr = (SQLPropertyExpr)item.getExpr();
                        columnName = expr.getName();
                    } else if (item.getExpr() instanceof SQLIdentifierExpr) {
                        expr = (SQLIdentifierExpr)item.getExpr();
                        columnName = expr.getName();
                    }
                } else {
                    throw new RuntimeException(String.format("grammatical analysis sql column [ %s ] failed", item));
                }
                if (SELECT_ALL_CHARACTER.equals(item.toString())) {
                    log.info("sql contains *, grammatical analysis failed");
                    return Pair.of((Object)sourceTable, (Object)new String[]{SELECT_ALL_CHARACTER});
                }
                if (columnName == null) {
                    throw new RuntimeException(String.format("grammatical analysis sql column [ %s ] failed", item));
                }
                columnNames[i] = columnName;
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return Pair.of(null, (Object)new String[0]);
        }
        return Pair.of(sourceTable, (Object)columnNames);
    }

    private DataSource getDataSource(int datasourceId) {
        List datasources = DolphinSchedulerV1Context.getContext().getDataSources();
        return CollectionUtils.emptyIfNull((Collection)datasources).stream().filter(s -> s.getId() == datasourceId).findFirst().orElse(null);
    }
}

