/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LanguageEnum;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRecurrenceType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFileResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScheduleStrategy;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.AbstractParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.conditions.ConditionsParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.datax.DataxParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.flink.FlinkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.http.HttpParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sqoop.SqoopParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.transformer.core.utils.SpecFileResourceTypeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils.ConverterTypeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.ParamListConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.UuidGenerators;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterConverter<T extends AbstractParameters> {
    private static final Logger log = LoggerFactory.getLogger(AbstractParameterConverter.class);
    protected static final String RESOURCE_REFERENCE_FORMAT = "%s@resource_reference{\"%s\"}";
    protected static final String RESOURCE_REFERENCE_PREFIX = "##";
    protected final TaskNode taskDefinition;
    protected final ProcessMeta processDefinition;
    protected final Properties properties;
    protected static Map<TaskType, Class<? extends AbstractParameters>> taskTypeClassMap = new EnumMap<TaskType, Class<? extends AbstractParameters>>(TaskType.class);
    protected T parameter;
    protected final SpecWorkflow specWorkflow;

    protected AbstractParameterConverter(Properties properties, SpecWorkflow specWorkflow, ProcessMeta processMeta, TaskNode taskDefinition) {
        this.properties = properties;
        this.specWorkflow = specWorkflow;
        this.processDefinition = processMeta;
        this.taskDefinition = taskDefinition;
        TaskType taskType = taskDefinition.getType();
        try {
            this.parameter = (AbstractParameters)GsonUtils.fromJsonString((String)taskDefinition.getParams(), (Type)TypeToken.get(taskTypeClassMap.get(taskType)).getType());
        }
        catch (Exception ex) {
            log.error("parse task {}, {}, parameter {} error: ", new Object[]{taskType, taskTypeClassMap.get(taskType), ex});
        }
    }

    protected abstract void convertParameter(SpecNode var1);

    public SpecNode convert() {
        SpecNode specNode = this.newSpecNode(this.taskDefinition);
        this.convertParameter(specNode);
        this.specWorkflow.getNodes().add(specNode);
        return specNode;
    }

    private SpecNode initSpecNode() {
        SpecNode specNode = new SpecNode();
        specNode.setInputs(new ArrayList());
        specNode.setOutputs(new ArrayList());
        specNode.setFileResources(new ArrayList());
        specNode.setFunctions(new ArrayList());
        return specNode;
    }

    protected SpecNode newSpecNode(TaskNode taskDefinition) {
        SpecNode specNode = this.initSpecNode();
        specNode.setId(UuidGenerators.generateUuid());
        specNode.setName(taskDefinition.getName());
        specNode.setDescription(taskDefinition.getDesc());
        specNode.setRerunTimes(Integer.valueOf(taskDefinition.getMaxRetryTimes()));
        specNode.setRerunInterval(Integer.valueOf((int)Duration.ofMinutes(taskDefinition.getRetryInterval()).toMillis()));
        try {
            Integer timeout = Integer.parseInt(taskDefinition.getTimeout());
            specNode.setTimeout(timeout);
        }
        catch (Exception e) {
            log.warn("parse task  {}, timeout {}  error: ", (Object)taskDefinition.getId(), (Object)taskDefinition.getTimeout());
        }
        this.resetNodeStrategy(specNode);
        SpecNodeOutput defaultOutput = this.buildDefaultNodeOutput(specNode);
        DolphinSchedulerV1Context.getContext().getTaskCodeNodeDataMap().put(taskDefinition.getId(), defaultOutput.getData());
        DolphinSchedulerV1Context.getContext().getTaskCodeNodeIdMap().put(taskDefinition.getId(), specNode.getId());
        specNode.getOutputs().add(defaultOutput);
        specNode.setTrigger(this.convertByTaskDefinition());
        return specNode;
    }

    private SpecTrigger convertByTaskDefinition() {
        SpecTrigger specTrigger = new SpecTrigger();
        specTrigger.setRecurrence("NORMAL".equals(this.taskDefinition.getRunFlag()) ? NodeRecurrenceType.NORMAL : NodeRecurrenceType.PAUSE);
        specTrigger.setId(UuidGenerators.generateUuid());
        return specTrigger;
    }

    protected SpecNodeOutput buildDefaultNodeOutput(SpecNode specNode) {
        SpecNodeOutput specNodeOutput = new SpecNodeOutput();
        specNodeOutput.setIsDefault(Boolean.valueOf(true));
        specNodeOutput.setData(specNode.getId());
        specNodeOutput.setRefTableName(specNode.getName());
        return specNodeOutput;
    }

    protected SpecNodeOutput getDefaultOutput(SpecNode specNode) {
        return this.getDefaultOutput((List<Output>)Optional.ofNullable(specNode).map(SpecNode::getOutputs).orElse(null));
    }

    protected SpecNodeOutput getDefaultOutput(SpecWorkflow specWorkflow, boolean throwException) {
        return this.getDefaultOutput((List<Output>)Optional.ofNullable(specWorkflow).map(SpecWorkflow::getOutputs).orElse(null), throwException);
    }

    protected SpecNodeOutput getDefaultOutput(SpecNode specNode, boolean throwException) {
        return this.getDefaultOutput((List<Output>)Optional.ofNullable(specNode).map(SpecNode::getOutputs).orElse(null), throwException);
    }

    protected SpecNodeOutput getDefaultOutput(List<Output> outputList) {
        return this.getDefaultOutput(outputList, false);
    }

    protected SpecNodeOutput getDefaultOutput(List<Output> outputList, boolean throwException) {
        Optional<Output> first = ListUtils.emptyIfNull(outputList).stream().filter(output -> output instanceof SpecNodeOutput && ((SpecNodeOutput)output).getIsDefault() != false).findFirst();
        if (throwException && !first.isPresent()) {
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"defaultOutput"});
        }
        return first.orElse(null);
    }

    protected List<SpecVariable> getContextOutputs(SpecNode specNode) {
        return specNode.getOutputs().stream().filter(v -> v instanceof SpecVariable && VariableScopeType.NODE_CONTEXT.equals((Object)((SpecVariable)v).getScope()) && VariableType.NODE_OUTPUT.equals((Object)((SpecVariable)v).getType())).map(v -> {
            SpecVariable variable = (SpecVariable)BeanUtils.deepCopy((Object)v, SpecVariable.class);
            variable.setNode(new SpecDepend(specNode, DependencyType.NORMAL, null));
            return variable;
        }).collect(Collectors.toList());
    }

    protected List<SpecVariable> convertSpecNodeParam(SpecNode specNode) {
        ParamListConverter paramListConverter = new ParamListConverter(this.parameter.getLocalParams(), this.taskDefinition);
        List<SpecVariable> specVariableList = paramListConverter.convert();
        for (SpecVariable specVariable : specVariableList) {
            if (!VariableType.NODE_OUTPUT.equals((Object)specVariable.getType())) continue;
            SpecDepend nodeDepend = new SpecDepend();
            nodeDepend.setNodeId(specNode);
            nodeDepend.setOutput(this.getDefaultOutput(specNode));
            specVariable.setNode(nodeDepend);
            specNode.getOutputs().add(specVariable);
        }
        return specVariableList;
    }

    protected void convertFileResourceList(SpecNode specNode) {
        ListUtils.emptyIfNull((List)this.parameter.getResourceFilesList()).forEach(resourceInfo -> {
            SpecFileResource specFileResource = new SpecFileResource();
            specFileResource.setRuntimeResource(specNode.getRuntimeResource());
            specFileResource.setName(this.getFileNameByPath(resourceInfo.getName()));
            specFileResource.setType(SpecFileResourceTypeUtils.getResourceTypeBySuffix(specFileResource.getName()));
            this.checkFileSameName(specFileResource.getName(), resourceInfo.getName());
            specNode.getFileResources().add(specFileResource);
        });
    }

    private void checkFileSameName(String fileName, String fullName) {
        String fullNameIn = null;
        if (Objects.nonNull(fullNameIn) && !fullNameIn.equals(fullName)) {
            log.warn("\u5b58\u5728\u540c\u540d\u8d44\u6e90\u51b2\u7a81\u98ce\u9669, {} \u548c {} \u5bfc\u5165\u540e\u4f1a\u540c\u540d", (Object)fullNameIn, (Object)fullName);
        }
    }

    protected String buildFileResourceReference(SpecNode specNode, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        Optional.ofNullable(specNode).map(SpecNode::getFileResources).ifPresent(fileResources -> fileResources.forEach(fileResource -> stringBuilder.append(String.format(RESOURCE_REFERENCE_FORMAT, prefix, fileResource.getName())).append("\n")));
        return stringBuilder.append("\n").toString();
    }

    protected void addRelation(SpecNode postNode, List<SpecNode> preNodeList, List<SpecNodeOutput> preNodeOutputList) {
        SpecFlowDepend specFlowDepend = this.newSpecFlowDepend();
        specFlowDepend.setNodeId(postNode);
        ListUtils.emptyIfNull(preNodeList).forEach(preNode -> {
            SpecNodeOutput preNodeOutput = this.getDefaultOutput((SpecNode)preNode);
            postNode.getInputs().add(preNodeOutput);
            postNode.getInputs().addAll(this.getContextOutputs((SpecNode)preNode));
            specFlowDepend.getDepends().add(new SpecDepend(preNode, DependencyType.NORMAL, preNodeOutput));
        });
        ListUtils.emptyIfNull(preNodeOutputList).forEach(preNodeOutput -> {
            postNode.getInputs().add(preNodeOutput);
            SpecDepend specDepend = new SpecDepend();
            specDepend.setType(DependencyType.NORMAL);
            specDepend.setOutput(preNodeOutput);
            specFlowDepend.getDepends().add(specDepend);
        });
        this.getWorkflowDependencyList().add(specFlowDepend);
    }

    protected SpecFlowDepend newSpecFlowDepend() {
        SpecFlowDepend specFlowDepend = new SpecFlowDepend();
        specFlowDepend.setDepends(new ArrayList());
        return specFlowDepend;
    }

    protected void addRelation(SpecNode postNode, List<SpecNode> preNodeList) {
        this.addRelation(postNode, preNodeList, null);
    }

    protected String getFileNameByPath(String path) {
        File file = new File(path);
        return file.getName();
    }

    protected String getScriptPath(SpecNode specNode) {
        if (Objects.isNull(specNode)) {
            return "";
        }
        String defaultPath = StringUtils.defaultString((String)Config.get().getBasePath(), (String)"");
        String workFlowPath = Optional.ofNullable(this.specWorkflow).map(SpecWorkflow::getName).orElse("");
        return FilenameUtils.concat((String)FilenameUtils.concat((String)defaultPath, (String)workFlowPath), (String)specNode.getName());
    }

    protected List<SpecFlowDepend> getWorkflowDependencyList() {
        if (Objects.nonNull(this.specWorkflow)) {
            return this.specWorkflow.getDependencies();
        }
        return Collections.emptyList();
    }

    protected SpecTrigger getWorkflowTrigger() {
        if (Objects.nonNull(this.specWorkflow)) {
            return this.specWorkflow.getTrigger();
        }
        return null;
    }

    protected SpecWorkflow getWorkFlow() {
        return this.specWorkflow;
    }

    protected void resetNodeStrategy(SpecNode specNode) {
        if (specNode.getStrategy() == null) {
            specNode.setStrategy(new SpecScheduleStrategy());
        }
        SpecScheduleStrategy strategy = specNode.getStrategy();
        strategy.setPriority(specNode.getPriority());
        strategy.setTimeout(specNode.getTimeout());
        strategy.setRerunInterval(specNode.getRerunInterval());
        strategy.setRerunTimes(specNode.getRerunTimes());
        strategy.setIgnoreBranchConditionSkip(specNode.getIgnoreBranchConditionSkip());
        strategy.setInstanceMode(specNode.getInstanceMode());
        strategy.setRerunMode(specNode.getRerunMode());
        Optional.ofNullable(this.getWorkFlow()).map(SpecWorkflow::getStrategy).map(SpecScheduleStrategy::getFailureStrategy).ifPresent(arg_0 -> ((SpecScheduleStrategy)strategy).setFailureStrategy(arg_0));
    }

    protected String codeToLanguageIdentifier(CodeProgramType nodeType) {
        LanguageEnum languageEnum = this.codeToLanguage(nodeType);
        if (languageEnum == null) {
            log.warn("can not find language by {}", (Object)nodeType);
            return null;
        }
        return languageEnum.getIdentifier();
    }

    protected LanguageEnum codeToLanguage(CodeProgramType nodeType) {
        switch (nodeType) {
            case SHELL: 
            case DIDE_SHELL: 
            case CDH_SHELL: 
            case EMR_SPARK_SHELL: 
            case CDH_SPARK_SHELL: 
            case EMR_SHELL: 
            case EMR_HIVE_CLI: 
            case PERL: {
                return LanguageEnum.SHELL_SCRIPT;
            }
            case EMR_SPARK_SQL: {
                return LanguageEnum.SPARK_SQL;
            }
            case CDH_HIVE: 
            case HIVE: 
            case EMR_HIVE: {
                return LanguageEnum.HIVE_SQL;
            }
            case EMR_IMPALA: 
            case CDH_IMPALA: {
                return LanguageEnum.IMPALA_SQL;
            }
            case CLICK_SQL: {
                return LanguageEnum.CLICKHOUSE_SQL;
            }
            case ODPS_SQL: 
            case ODPS_PERL: {
                return LanguageEnum.ODPS_SQL;
            }
            case ODPS_SCRIPT: {
                return LanguageEnum.ODPS_SCRIPT;
            }
            case EMR_PRESTO: 
            case CDH_PRESTO: {
                return LanguageEnum.PRESTO_SQL;
            }
            case PYODPS: {
                return LanguageEnum.PYTHON2;
            }
            case PYODPS3: {
                return LanguageEnum.PYTHON3;
            }
            case DATAX2: 
            case DATAX: 
            case RI: 
            case DI: {
                return LanguageEnum.JSON;
            }
            case HOLOGRES_SQL: {
                return LanguageEnum.HOLOGRES_SQL;
            }
        }
        return null;
    }

    protected String getConverterType(String convertType, String defaultConvertType) {
        String projectName = this.processDefinition.getProjectName();
        String processName = this.processDefinition.getProcessDefinitionName();
        String taskName = this.taskDefinition.getName();
        return ConverterTypeUtils.getConverterType(convertType, projectName, processName, taskName, defaultConvertType);
    }

    static {
        taskTypeClassMap.put(TaskType.SQL, SqlParameters.class);
        taskTypeClassMap.put(TaskType.DEPENDENT, DependentParameters.class);
        taskTypeClassMap.put(TaskType.FLINK, FlinkParameters.class);
        taskTypeClassMap.put(TaskType.SPARK, SparkParameters.class);
        taskTypeClassMap.put(TaskType.DATAX, DataxParameters.class);
        taskTypeClassMap.put(TaskType.SHELL, ShellParameters.class);
        taskTypeClassMap.put(TaskType.HTTP, HttpParameters.class);
        taskTypeClassMap.put(TaskType.PROCEDURE, ProcedureParameters.class);
        taskTypeClassMap.put(TaskType.CONDITIONS, ConditionsParameters.class);
        taskTypeClassMap.put(TaskType.SQOOP, SqoopParameters.class);
        taskTypeClassMap.put(TaskType.SUB_PROCESS, SubProcessParameters.class);
        taskTypeClassMap.put(TaskType.PYTHON, PythonParameters.class);
        taskTypeClassMap.put(TaskType.MR, MapReduceParameters.class);
    }
}

