/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerBranchCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecBranches;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.CheckPoint;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.StoreWriter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.filters.DolphinSchedulerConverterFilter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.ParamListConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.TaskConverterFactoryV1;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.exception.UnSupportedTypeException;
import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.UuidGenerators;
import com.google.common.base.Joiner;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1ProcessDefinitionConverter {
    private static final Logger log = LoggerFactory.getLogger(V1ProcessDefinitionConverter.class);
    private List<SpecNode> specNodes = new ArrayList<SpecNode>();
    private static final SpecScriptRuntime WORKFLOW_RUNTIME = new SpecScriptRuntime();
    private static final SpecScriptRuntime MANUAL_WORKFLOW_RUNTIME = new SpecScriptRuntime();
    private ProcessMeta processDefinition;
    private Properties converterProperties;
    private List<TaskNode> taskDefinitionList;
    private CheckPoint checkPoint;
    private SpecWorkflow specWorkflow;
    private DolphinSchedulerConverterFilter filter;

    public V1ProcessDefinitionConverter(ProcessMeta processMeta, List<TaskNode> taskDefinitionList, Properties converterProperties) {
        this.processDefinition = processMeta;
        this.converterProperties = converterProperties;
        this.taskDefinitionList = taskDefinitionList;
        this.filter = new DolphinSchedulerConverterFilter();
        this.checkPoint = CheckPoint.getInstance();
    }

    public static String toWorkflowName(ProcessMeta processMeta) {
        return StringUtils.toValidName((String)Joiner.on((String)"_").join((Object)processMeta.getProjectName(), (Object)processMeta.getProcessDefinitionName(), new Object[0]));
    }

    private SpecWorkflow initWorkflow() {
        SpecWorkflow specWorkflow = new SpecWorkflow();
        specWorkflow.setDependencies(new ArrayList());
        specWorkflow.setNodes(new ArrayList());
        specWorkflow.setInputs(new ArrayList());
        specWorkflow.setOutputs(new ArrayList());
        return specWorkflow;
    }

    public SpecWorkflow convert() {
        this.specWorkflow = this.convertProcess(this.processDefinition);
        DolphinSchedulerV1Context.getContext().getSubProcessCodeWorkflowMap().put(this.processDefinition.getProcessDefinitionId(), this.specWorkflow);
        this.convertTasks();
        this.convertTrigger(this.specWorkflow);
        this.handleBranch(this.specWorkflow);
        return this.specWorkflow;
    }

    protected SpecWorkflow convertProcess(ProcessMeta processDefinition) {
        log.info("convert workflow,processDefinition: {}", (Object)processDefinition.getProcessDefinitionName());
        SpecWorkflow specWorkflow = this.initWorkflow();
        specWorkflow.setId(UuidGenerators.generateUuid());
        specWorkflow.setName(V1ProcessDefinitionConverter.toWorkflowName(processDefinition));
        specWorkflow.setDescription(processDefinition.getProcessDefinitionDescription());
        ProcessData processData = processDefinition.getProcessDefinitionJson();
        List<SpecVariable> specVariableList = new ParamListConverter(processData.getGlobalParams()).convert();
        log.info("convert workflow,global params: {}", specVariableList);
        SpecScript script = new SpecScript();
        script.setParameters(specVariableList);
        script.setRuntime(WORKFLOW_RUNTIME);
        script.setPath(this.getScriptPath(specWorkflow.getName()));
        specWorkflow.setScript(script);
        specWorkflow.getOutputs().add(this.buildDefaultOutput(specWorkflow));
        return specWorkflow;
    }

    protected String getScriptPath(String name) {
        String defaultPath = org.apache.commons.lang3.StringUtils.defaultString((String)Config.get().getBasePath(), (String)"");
        return FilenameUtils.concat((String)defaultPath, (String)name);
    }

    protected List<SpecNode> convertTaskDefinitions(SpecWorkflow specWorkflow) {
        return this.convertTasks();
    }

    protected void convertTrigger(SpecWorkflow specWorkflow) {
        this.processDefinition.getScheduleCrontab();
        String crontab = this.processDefinition.getScheduleCrontab();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)crontab)) {
            SpecTrigger trigger = new SpecTrigger();
            trigger.setCron(this.convertCrontab(crontab));
            specWorkflow.setTrigger(trigger);
            log.info("convert workflow,crontab: {}", (Object)crontab);
        }
    }

    protected String convertCrontab(String scheduleCrontab) {
        try {
            return CronExpressUtil.quartzCronExpressionToDwCronExpress((String)scheduleCrontab);
        }
        catch (ParseException e) {
            log.error("convert quartz cron expression error: ", (Throwable)e);
            return "day";
        }
    }

    private void handleBranch(SpecWorkflow specWorkflow) {
        Map taskCodeSpecNodeMap = DolphinSchedulerV1Context.getContext().getTaskCodeSpecNodeMap();
        for (SpecNode specNode : specWorkflow.getNodes()) {
            if (specNode.getBranch() == null || specNode.getBranch().getBranches() == null) continue;
            List specBranches = specNode.getBranch().getBranches();
            ArrayList<ControllerBranchCode.Branch> branchList = new ArrayList<ControllerBranchCode.Branch>();
            for (SpecBranches specBranch : specBranches) {
                SpecNodeOutput specNodeOutput = specBranch.getOutput();
                if (specNodeOutput == null || specNodeOutput.getData() == null) continue;
                String data = specNodeOutput.getData();
                Long taskCode = Long.parseLong(data);
                SpecNode branchSpecNode = (SpecNode)taskCodeSpecNodeMap.get(taskCode);
                specNodeOutput.setData(branchSpecNode.getId());
                ControllerBranchCode.Branch branch = new ControllerBranchCode.Branch();
                branch.setCondition(specBranch.getWhen());
                branch.setNodeoutput(branchSpecNode.getId());
                branchList.add(branch);
            }
            if (branchList.size() <= 0) continue;
            String content = GsonUtils.toJsonString(branchList);
            specNode.getScript().setContent(content);
        }
    }

    private SpecNodeOutput buildDefaultOutput(SpecWorkflow specWorkflow) {
        SpecNodeOutput specNodeOutput = new SpecNodeOutput();
        specNodeOutput.setIsDefault(Boolean.valueOf(true));
        specNodeOutput.setData(specWorkflow.getId());
        specNodeOutput.setRefTableName(specWorkflow.getName());
        return specNodeOutput;
    }

    public List<SpecNode> convertTasks() {
        String projectName = this.processDefinition.getProjectName();
        String processName = this.processDefinition.getProcessDefinitionName();
        Map loadedTasks = this.checkPoint.loadFromCheckPoint(projectName, processName);
        SpecWorkflow workflow = new SpecWorkflow();
        Function<StoreWriter, List> processFunc = writer -> Optional.ofNullable(this.processDefinition.getProcessDefinitionJson()).map(pd -> this.toSpecNodes((ProcessData)pd, loadedTasks, (StoreWriter)writer)).orElse(Collections.emptyList());
        List<SpecNode> specNodes = this.checkPoint.doWithCheckpoint(processFunc, projectName);
        return specNodes;
    }

    private List<SpecNode> toSpecNodes(ProcessData pd, Map<String, List<SpecNode>> loadedTasks, StoreWriter writer) {
        return ListUtils.emptyIfNull((List)pd.getTasks()).stream().filter(s -> {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return true;
        }).filter(task -> {
            boolean willConvert = this.filter.filterTasks(this.processDefinition.getProjectName(), this.processDefinition.getProcessDefinitionName(), task.getName());
            if (!willConvert) {
                log.warn("task {} not in filterTasks list", (Object)task.getName());
            }
            return willConvert;
        }).filter(taskNode -> !this.inSkippedList((TaskNode)taskNode)).map(taskNode -> {
            List<SpecNode> specNodes = this.convertTaskToSpecNodeWithLoadedTask((TaskNode)taskNode, loadedTasks);
            this.checkPoint.doCheckpoint(writer, specNodes, this.processDefinition.getProcessDefinitionName(), taskNode.getName());
            return specNodes;
        }).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<SpecNode> convertTaskToSpecNodeWithLoadedTask(TaskNode taskNode, Map<String, List<SpecNode>> loadedTasks) {
        List<SpecNode> workflows = loadedTasks.get(taskNode.getName());
        if (workflows != null) {
            this.markSuccessProcess(workflows, taskNode);
            log.info("loaded task {} from checkpoint", (Object)taskNode.getName());
            return workflows;
        }
        return this.converter(taskNode);
    }

    private List<SpecNode> converter(TaskNode taskNode) {
        try {
            AbstractParameterConverter converter = TaskConverterFactoryV1.create(this.converterProperties, this.specWorkflow, this.processDefinition, taskNode);
            SpecNode specNode = converter.convert();
            if (specNode != null) {
                DolphinSchedulerV1Context.getContext().getTaskCodeSpecNodeMap().put(taskNode.getId(), specNode);
                return Arrays.asList(specNode);
            }
            return Collections.emptyList();
        }
        catch (UnSupportedTypeException e) {
            this.markFailedProcess(taskNode, e.getMessage());
            if (Config.get().isSkipUnSupportType()) {
                List<SpecNode> list = Collections.emptyList();
                return list;
            }
            throw e;
        }
        catch (Throwable e) {
            log.error("task converter error: ", e);
            if (Config.get().isTransformContinueWithError()) {
                return Collections.emptyList();
            }
            throw new RuntimeException(e);
        }
    }

    protected void markSuccessProcess(List<SpecNode> specNodes, TaskNode taskNode) {
        for (SpecNode node : specNodes) {
            DolphinMetrics metrics = DolphinMetrics.builder().projectName(this.processDefinition.getProjectName()).processName(this.processDefinition.getProcessDefinitionName()).taskName(taskNode.getName()).taskType(taskNode.getType().name()).build();
            metrics.setWorkflowName(this.specWorkflow.getName());
            metrics.setDwName(node.getName());
            metrics.setDwType(taskNode.getType().name());
            TransformerContext.getCollector().markSuccessMiddleProcess((Metrics)metrics);
        }
    }

    private boolean inSkippedList(TaskNode taskNode) {
        if (Config.get().getSkipTypes().contains(taskNode.getType()) || Config.get().getSkipTaskCodes().contains(taskNode.getName())) {
            log.warn("task name {}  in skipped list", (Object)taskNode.getName());
            this.markSkippedProcess(taskNode);
            return true;
        }
        return false;
    }

    protected void markSkippedProcess(TaskNode taskNode) {
        DolphinMetrics metrics = ((DolphinMetrics.DolphinMetricsBuilder)DolphinMetrics.builder().projectName(this.processDefinition.getProjectName()).processName(this.processDefinition.getProcessDefinitionName()).taskName(taskNode.getName()).taskType(taskNode.getType().name()).timestamp(System.currentTimeMillis())).build();
        TransformerContext.getCollector().markSkippedProcess((Metrics)metrics);
    }

    protected void markFailedProcess(TaskNode taskNode, String errorMsg) {
        DolphinMetrics metrics = ((DolphinMetrics.DolphinMetricsBuilder)DolphinMetrics.builder().projectName(this.processDefinition.getProjectName()).processName(this.processDefinition.getProcessDefinitionName()).taskName(taskNode.getName()).taskType(taskNode.getType().name()).timestamp(System.currentTimeMillis())).build();
        metrics.setErrorMsg(errorMsg);
        TransformerContext.getCollector().markSkippedProcess((Metrics)metrics);
    }

    static {
        WORKFLOW_RUNTIME.setEngine(CodeProgramType.VIRTUAL_WORKFLOW.getCalcEngineType().getLabel());
        WORKFLOW_RUNTIME.setCommand("WORKFLOW");
        MANUAL_WORKFLOW_RUNTIME.setEngine(CodeProgramType.VIRTUAL_WORKFLOW.getCalcEngineType().getLabel());
        MANUAL_WORKFLOW_RUNTIME.setCommand("MANUAL_WORKFLOW");
    }
}

