/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.WorkflowParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.StringUtils;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.CheckPoint;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.StoreWriter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.filters.DolphinSchedulerConverterFilter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.TaskConverterFactory;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.ProcessDefinitionConverter;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.exception.UnSupportedTypeException;
import com.aliyun.migrationx.common.metrics.DolphinMetrics;
import com.aliyun.migrationx.common.metrics.Metrics;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1ProcessDefinitionConverter
extends ProcessDefinitionConverter<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> {
    private static final Logger log = LoggerFactory.getLogger(V1ProcessDefinitionConverter.class);
    private List<DwWorkflow> dwWorkflowList = new ArrayList<DwWorkflow>();
    private DolphinSchedulerConverterFilter filter = new DolphinSchedulerConverterFilter();
    private CheckPoint checkPoint = CheckPoint.getInstance();

    public V1ProcessDefinitionConverter(DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext, ProcessMeta processDefinition) {
        super(converterContext, processDefinition);
    }

    public static String toWorkflowName(ProcessMeta processMeta) {
        return StringUtils.toValidName((String)Joiner.on((String)"_").join((Object)processMeta.getProjectName(), (Object)processMeta.getProcessDefinitionName(), new Object[0]));
    }

    @Override
    public List<DwWorkflow> convert() {
        DwWorkflow dwWorkflow = new DwWorkflow();
        dwWorkflow.setName(V1ProcessDefinitionConverter.toWorkflowName((ProcessMeta)this.processDefinition));
        dwWorkflow.setType(WorkflowType.BUSINESS);
        dwWorkflow.setScheduled(Boolean.valueOf(true));
        dwWorkflow.setVersion(WorkflowVersion.V3);
        this.converterContext.setDwWorkflow(dwWorkflow);
        String projectName = ((ProcessMeta)this.processDefinition).getProjectName();
        String processName = ((ProcessMeta)this.processDefinition).getProcessDefinitionName();
        Map loadedTasks = this.checkPoint.loadFromCheckPoint(projectName, processName);
        Function<StoreWriter, List> processFunc = writer -> Optional.ofNullable(((ProcessMeta)this.processDefinition).getProcessDefinitionJson()).map(pd -> {
            dwWorkflow.setParameters(GsonUtils.toJsonString(pd.getGlobalParams().stream().map(prop -> new WorkflowParameter().setKey(prop.getProp()).setValue(prop.getValue())).collect(Collectors.toList())));
            return this.toWorkflowlist((ProcessData)pd, loadedTasks, (StoreWriter)writer);
        }).orElse(Collections.emptyList());
        this.dwWorkflowList = this.checkPoint.doWithCheckpoint(processFunc, projectName);
        ListUtils.emptyIfNull((List)dwWorkflow.getNodes()).forEach(node -> node.setCronExpress(this.convertCrontab(((ProcessMeta)this.processDefinition).getScheduleCrontab())));
        this.processSubProcessDefinitionDepends();
        return this.dwWorkflowList;
    }

    private List<DwWorkflow> toWorkflowlist(ProcessData pd, Map<String, List<DwWorkflow>> loadedTasks, StoreWriter writer) {
        return ListUtils.emptyIfNull((List)pd.getTasks()).stream().filter(s -> {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return true;
        }).filter(task -> {
            boolean willConvert = this.filter.filterTasks(((ProcessMeta)this.processDefinition).getProjectName(), ((ProcessMeta)this.processDefinition).getProcessDefinitionName(), task.getName());
            if (!willConvert) {
                log.warn("task {} not in filterTasks list", (Object)task.getName());
            }
            return willConvert;
        }).filter(taskNode -> !this.inSkippedList((TaskNode)taskNode)).map(taskNode -> {
            List<DwWorkflow> dwWorkflows = this.convertTaskToWorkflowWithLoadedTask((TaskNode)taskNode, loadedTasks);
            this.checkPoint.doCheckpoint(writer, dwWorkflows, ((ProcessMeta)this.processDefinition).getProcessDefinitionName(), taskNode.getName());
            return dwWorkflows;
        }).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DwWorkflow> convertTaskToWorkflowWithLoadedTask(TaskNode taskNode, Map<String, List<DwWorkflow>> loadedTasks) {
        List<DwWorkflow> workflows = loadedTasks.get(taskNode.getName());
        if (workflows != null) {
            this.markSuccessProcess(workflows, taskNode);
            log.info("loaded task {} from checkpoint", (Object)taskNode.getName());
            return workflows;
        }
        return this.converter(taskNode);
    }

    private List<DwWorkflow> converter(TaskNode taskNode) {
        AbstractParameterConverter converter;
        try {
            converter = TaskConverterFactory.create((ProcessMeta)this.processDefinition, taskNode, this.converterContext);
            converter.convert();
        }
        catch (UnSupportedTypeException e) {
            this.markFailedProcess(taskNode, e.getMessage());
            if (Config.get().isSkipUnSupportType()) {
                List<DwWorkflow> list = Collections.emptyList();
                return list;
            }
            throw e;
        }
        catch (Throwable e) {
            log.error("task converter error: ", e);
            if (Config.get().isTransformContinueWithError()) {
                return Collections.emptyList();
            }
            throw new RuntimeException(e);
        }
        return converter.getWorkflowList();
    }

    protected void markSuccessProcess(List<DwWorkflow> workflows, TaskNode taskNode) {
        for (DwWorkflow workflow : workflows) {
            for (Node node : workflow.getNodes()) {
                DolphinMetrics metrics = DolphinMetrics.builder().projectName(((ProcessMeta)this.processDefinition).getProjectName()).processName(((ProcessMeta)this.processDefinition).getProcessDefinitionName()).taskName(taskNode.getName()).taskType(taskNode.getType().name()).build();
                metrics.setWorkflowName(workflow.getName());
                metrics.setDwName(node.getName());
                metrics.setDwType(node.getType());
                TransformerContext.getCollector().markSuccessMiddleProcess((Metrics)metrics);
            }
        }
    }

    private boolean inSkippedList(TaskNode taskNode) {
        if (Config.get().getSkipTypes().contains(taskNode.getType()) || Config.get().getSkipTaskCodes().contains(taskNode.getName())) {
            log.warn("task name {}  in skipped list", (Object)taskNode.getName());
            this.markSkippedProcess(taskNode);
            return true;
        }
        return false;
    }

    private void processSubProcessDefinitionDepends() {
        ListUtils.emptyIfNull(this.dwWorkflowList).forEach(workflow -> ListUtils.emptyIfNull((List)workflow.getNodes()).stream().filter(n -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)TaskType.SUB_PROCESS.name(), (CharSequence)((DwNode)n).getRawNodeType())).forEach(subProcessNode -> {
            SubProcessParameters subProcessParameter = (SubProcessParameters)GsonUtils.fromJsonString((String)subProcessNode.getCode(), (Type)new TypeToken<SubProcessParameters>(){}.getType());
            this.converterContext.getDolphinSchedulerPackage().getProcessDefinitions().values().stream().map(defList -> ListUtils.emptyIfNull((List)defList).stream().filter(df -> subProcessParameter != null).filter(df -> Objects.equals(df.getProcessDefinitionId(), subProcessParameter.getProcessDefinitionId())).findFirst().flatMap(proDef -> this.dwWorkflowList.stream().filter(wf -> org.apache.commons.lang3.StringUtils.equals((CharSequence)V1ProcessDefinitionConverter.toWorkflowName(proDef), (CharSequence)wf.getName())).findFirst().map(wf -> this.addStartEndNodeToDependedWorkflow((Node)subProcessNode, (ProcessMeta)proDef, (DwWorkflow)wf))).orElse(new DwNodeIo())).filter(io -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)io.getData())).findFirst().ifPresent(endNodeOut -> ListUtils.emptyIfNull((List)workflow.getNodes()).stream().filter(n -> ListUtils.emptyIfNull((List)n.getInputs()).stream().anyMatch(in -> ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().anyMatch(out -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)out.getData(), (CharSequence)in.getData())))).forEach(child -> ListUtils.emptyIfNull((List)child.getInputs()).stream().filter(in -> ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().anyMatch(depOut -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)in.getData(), (CharSequence)depOut.getData()))).forEach(in -> in.setData(endNodeOut.getData()))));
        }));
    }

    private DwNodeIo addStartEndNodeToDependedWorkflow(Node subProcessNode, ProcessMeta proDef, DwWorkflow wf) {
        DwNode startNode = new DwNode();
        startNode.setType(CodeProgramType.VIRTUAL.name());
        startNode.setWorkflowRef((Workflow)wf);
        DwNodeIo startNodeOutput = new DwNodeIo();
        startNodeOutput.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject(), (Object)wf.getName(), new Object[]{"start"}));
        startNodeOutput.setParseType(Integer.valueOf(1));
        startNode.setOutputs(Collections.singletonList(startNodeOutput));
        startNode.setInputs(new ArrayList());
        ListUtils.emptyIfNull((List)subProcessNode.getOutputs()).stream().findFirst().ifPresent(depOut -> startNode.getInputs().add(depOut));
        DwNode endNode = new DwNode();
        endNode.setType(CodeProgramType.VIRTUAL.name());
        endNode.setWorkflowRef((Workflow)wf);
        DwNodeIo endNodeOutput = new DwNodeIo();
        endNodeOutput.setData(Joiner.on((String)".").join((Object)this.converterContext.getProject(), (Object)wf.getName(), new Object[]{"end"}));
        endNodeOutput.setParseType(Integer.valueOf(1));
        endNode.setOutputs(Collections.singletonList(endNodeOutput));
        endNode.setInputs(new ArrayList());
        ListUtils.emptyIfNull((List)wf.getNodes()).forEach(node -> {
            String prefix = Joiner.on((String)".").join((Object)this.converterContext.getProject().getName(), (Object)proDef.getProjectName(), new Object[0]);
            if (ListUtils.emptyIfNull((List)node.getInputs()).stream().noneMatch(in -> org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)in.getData(), (CharSequence)prefix))) {
                node.getInputs().add(startNodeOutput);
            }
            if (ListUtils.emptyIfNull((List)wf.getNodes()).stream().map(Node::getInputs).flatMap(Collection::stream).noneMatch(in -> ListUtils.emptyIfNull((List)node.getOutputs()).stream().anyMatch(out -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)in.getData(), (CharSequence)out.getData())))) {
                ListUtils.emptyIfNull((List)node.getOutputs()).stream().findFirst().ifPresent(out -> endNode.getInputs().add(out));
            }
        });
        wf.getNodes().add(startNode);
        wf.getNodes().add(endNode);
        return endNodeOutput;
    }

    @Override
    public List<DwWorkflow> getWorkflowList() {
        return this.dwWorkflowList;
    }

    protected void markSkippedProcess(TaskNode taskNode) {
        DolphinMetrics metrics = ((DolphinMetrics.DolphinMetricsBuilder)DolphinMetrics.builder().projectName(((ProcessMeta)this.processDefinition).getProjectName()).processName(((ProcessMeta)this.processDefinition).getProcessDefinitionName()).taskName(taskNode.getName()).taskType(taskNode.getType().name()).timestamp(System.currentTimeMillis())).build();
        TransformerContext.getCollector().markSkippedProcess((Metrics)metrics);
    }

    protected void markFailedProcess(TaskNode taskNode, String errorMsg) {
        DolphinMetrics metrics = ((DolphinMetrics.DolphinMetricsBuilder)DolphinMetrics.builder().projectName(((ProcessMeta)this.processDefinition).getProjectName()).processName(((ProcessMeta)this.processDefinition).getProcessDefinitionName()).taskName(taskNode.getName()).taskType(taskNode.getType().name()).timestamp(System.currentTimeMillis())).build();
        metrics.setErrorMsg(errorMsg);
        TransformerContext.getCollector().markSkippedProcess((Metrics)metrics);
    }
}

