/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.AbstractParameters;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.ConditionsParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.DataxParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.DefaultParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.DependentParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.MrParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.PythonParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.ShellParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.SparkParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.SqlParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.SqoopParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.SubProcessParameterConverter;
import java.util.Optional;

public class TaskConverterFactory {
    public static <P extends AbstractParameters> AbstractParameterConverter<P> create(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext converterContext) throws Throwable {
        TaskType taskType = taskDefinition.getType();
        return Optional.ofNullable(taskType).map(type -> {
            switch (taskType) {
                case SQL: {
                    return new SqlParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case PYTHON: {
                    return new PythonParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case SPARK: {
                    return new SparkParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case CONDITIONS: {
                    return new ConditionsParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case SUB_PROCESS: {
                    return new SubProcessParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case DEPENDENT: {
                    return new DependentParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case SHELL: {
                    return new ShellParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case MR: {
                    return new MrParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case SQOOP: {
                    return new SqoopParameterConverter(processMeta, taskDefinition, converterContext);
                }
                case DATAX: {
                    return new DataxParameterConverter(processMeta, taskDefinition, converterContext);
                }
            }
            return new DefaultParameterConverter(processMeta, taskDefinition, converterContext);
        }).orElseThrow(() -> new RuntimeException("unsupported converter task type: " + taskType));
    }
}

