/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.utils;

import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.StringUtils;

public class ConverterTypeUtils {
    public static String getConverterType(String convertType, String projectName, String processName, String taskName, String defaultType) {
        if (StringUtils.isEmpty((CharSequence)convertType)) {
            return defaultType;
        }
        boolean valid = JSONUtils.checkJsonValid((String)convertType);
        if (!valid) {
            return convertType;
        }
        JsonNode jsonNode = JSONUtils.parseObject((String)convertType);
        String taskIdentity = String.format("%s.%s.%s", projectName, processName, taskName);
        String processIdentity = String.format("%s.%s.*", projectName, processName);
        String projectIdentity = String.format("%s.*", projectName, processName);
        if (jsonNode.has(taskIdentity)) {
            return jsonNode.get(taskIdentity).asText();
        }
        if (jsonNode.has(processIdentity)) {
            return jsonNode.get(processIdentity).asText();
        }
        if (jsonNode.has(projectIdentity)) {
            return jsonNode.get(projectIdentity).asText();
        }
        if (jsonNode.has("*")) {
            return jsonNode.get("*").asText();
        }
        return defaultType;
    }
}

