/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.caiyunjian;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.ModelTreeRoot;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.CaiyunjianTask;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DateParser;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasourceUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.FolderUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.IntlUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaiyunjianConverter
extends AbstractBaseConverter {
    private static final Logger log = LoggerFactory.getLogger(CaiyunjianConverter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CaiyunjianConverter.class);
    private static final String JSON_FILE_SUFFIX = ".json";
    private ConcurrentMap<String, DwWorkflow> dwWorkflowConcurrentMap = new ConcurrentHashMap<String, DwWorkflow>();
    public Project project;
    private Properties properties;
    private Map<String, DgDatasource> datasourceMap;

    public CaiyunjianConverter() {
        super(AssetType.CAIYUNJIAN, "CaiyunjianConverter");
    }

    public CaiyunjianConverter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(assetType, name, projectAssetLoader);
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        this.properties = this.propertiesLoader != null && this.properties == null ? (Properties)this.propertiesLoader.getResult() : this.properties;
        this.datasourceMap = DgDatasourceUtil.processDatasource((File)new File(asset.getPath(), "datasource.xlsx"));
        this.project.setDatasources(DgDatasourceUtil.convertDatasources(this.datasourceMap));
        List<DwWorkflow> list = this.convertWorkflowList(asset);
        ListUtils.emptyIfNull(list).forEach(wf -> ListUtils.emptyIfNull((List)wf.getNodes()).stream().peek(n -> NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n)).filter(n -> CodeProgramType.DI.name().equalsIgnoreCase(n.getType())).forEach(n -> {
            this.processFtpRootPath((Node)n, this.datasourceMap);
            NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n);
        }));
        ListUtils.emptyIfNull((List)this.project.getDatasources()).forEach(ds -> ((DwDatasource)ds).setProjectRef(this.project));
        return list;
    }

    private void processFtpRootPath(Node node, Map<String, DgDatasource> datasourceMap) {
        String code = node.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        JsonObject diJson = (JsonObject)GsonUtils.gson.fromJson(code, JsonObject.class);
        if (diJson == null) {
            return;
        }
        if (!diJson.has("steps")) {
            return;
        }
        JsonArray steps = diJson.get("steps").getAsJsonArray();
        if (steps.size() == 0) {
            return;
        }
        for (int i = 0; i < steps.size(); ++i) {
            DgDatasource dgDatasource;
            JsonObject step = steps.get(i).getAsJsonObject();
            if (!step.has("parameter")) continue;
            JsonObject parameter = step.get("parameter").getAsJsonObject();
            String datasource = null;
            if (parameter.has("datasourceId")) {
                Long datasourceId = parameter.get("datasourceId").getAsLong();
                datasource = datasourceMap.values().stream().filter(ds -> datasourceId != null && datasourceId.equals(ds.getId())).findAny().map(DgDatasource::getName).orElse(null);
            }
            if (StringUtils.isBlank(datasource) && parameter.has("datasourceName")) {
                datasource = parameter.get("datasourceName").getAsString();
            }
            if (StringUtils.isBlank(datasource) && parameter.has("datasource")) {
                datasource = parameter.get("datasource").getAsString();
            }
            if (StringUtils.isBlank(datasource)) {
                LOGGER.warn("datasource not found, node: {}", (Object)node.getName());
                continue;
            }
            parameter.addProperty("datasource", datasource);
            parameter.addProperty("datasourceName", datasource);
            if (!step.has("stepType") || Arrays.asList("sftp", "ftp").stream().noneMatch(t -> t.equalsIgnoreCase(step.get("stepType").getAsString())) || (dgDatasource = datasourceMap.get(datasource)) == null || !StringUtils.isNotBlank((CharSequence)dgDatasource.getRootPath()) || !parameter.has("path")) continue;
            JsonElement pathEle = parameter.get("path");
            JsonArray path = new JsonArray();
            if (pathEle.isJsonArray()) {
                path = parameter.get("path").getAsJsonArray();
            } else {
                path.add(pathEle.getAsString());
            }
            if (path == null || path.size() <= 0) continue;
            JsonArray pathList = new JsonArray();
            for (int j = 0; j < path.size(); ++j) {
                String p = path.get(j).getAsString();
                p = Joiner.on((String)File.separator).join((Object)dgDatasource.getRootPath(), (Object)p, new Object[0]);
                pathList.add(p);
            }
            parameter.add("path", (JsonElement)pathList);
        }
        node.setCode(GsonUtils.defaultGson.toJson((JsonElement)diJson));
    }

    public List<DwWorkflow> convertWorkflowList(Asset asset) throws Exception {
        this.workflowList = new ArrayList();
        this.dwWorkflowConcurrentMap = new ConcurrentHashMap<String, DwWorkflow>();
        File dir = asset.getPath();
        if (null == dir || !dir.exists()) {
            log.error("Caiyunjian asset dir invalid");
            return ListUtils.emptyIfNull(null);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = dir.listFiles(file -> file.isFile() && file.getName().endsWith(JSON_FILE_SUFFIX));
        File[] directoryFile = dir.listFiles(file -> file.isDirectory());
        if (null != directoryFile && directoryFile.length > 0) {
            for (int i = 0; i < directoryFile.length; ++i) {
                File[] childFiles = directoryFile[i].listFiles(file -> file.isFile() && file.getName().endsWith(JSON_FILE_SUFFIX));
                if (null == childFiles) continue;
                fileList.addAll(Arrays.asList(childFiles));
            }
        }
        if (null != files) {
            fileList.addAll(Arrays.asList(files));
        }
        if (fileList.size() <= 0) {
            log.error("Caiyunjian json file invalid");
            return ListUtils.emptyIfNull(null);
        }
        this.convertWorkflow(fileList);
        this.workflowList.addAll(new ArrayList(this.dwWorkflowConcurrentMap.values()));
        ListUtils.emptyIfNull((List)this.workflowList).forEach(wf -> ListUtils.emptyIfNull((List)wf.getNodes()).stream().forEach(n -> NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n)));
        return this.workflowList;
    }

    public void convertWorkflow(List<File> fileList) {
        fileList.forEach(jsonFile -> {
            try {
                String json = IOUtils.toString((Reader)new FileReader((File)jsonFile));
                CaiyunjianTask caiyunjianTask = (CaiyunjianTask)GsonUtils.defaultGson.fromJson(json, new TypeToken<CaiyunjianTask>(){}.getType());
                if (caiyunjianTask == null) {
                    log.error("error parse json file: {}", jsonFile);
                    throw new Exception("parse cai yun jian task json error: " + jsonFile.getName());
                }
                DwWorkflow dwWorkflow = this.getWorkflow();
                DwNode dwNode = caiyunjianTask.toNode(this.project.getName());
                this.processDetectTask(caiyunjianTask, dwNode);
                dwNode.setWorkflowRef((Workflow)dwWorkflow);
                this.getNodeFolder(dwNode, caiyunjianTask);
                if (null != dwNode) {
                    dwWorkflow.getNodes().add(dwNode);
                    dwNode.setWorkflowRef((Workflow)dwWorkflow);
                }
                if (!caiyunjianTask.getSuccess().booleanValue()) {
                    ReportItem reportItem = new ReportItem();
                    reportItem.setName(jsonFile.getName());
                    reportItem.setType(ReportItemType.CAIYUNJIAN_FILE_TO_NODE_FAILURE.name());
                    reportItem.setMessage("failed to convert job: " + jsonFile.getName());
                    this.reportItems.add(reportItem);
                    throw new Exception(reportItem.getMessage());
                }
            }
            catch (Exception e) {
                log.error("[Caiyunjian] file parse exception,file :{}", (Object)jsonFile.getName(), (Object)e);
                throw BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{jsonFile.getName() + ": " + e.getMessage()});
            }
        });
    }

    private void processDetectTask(CaiyunjianTask caiyunjianTask, DwNode dwNode) {
        if (caiyunjianTask.getTaskDetectInfoDO() == null || MapUtils.isEmpty(this.datasourceMap)) {
            return;
        }
        CaiyunjianTask.TaskDetectInfoDo taskDetectInfoDo = caiyunjianTask.getTaskDetectInfoDO();
        CaiyunjianTask.TaskDetectInfoDo.Setting setting = taskDetectInfoDo.getSetting();
        List intervalParameter = Arrays.stream(Arrays.stream(StringUtils.split((String)((String)StringUtils.defaultIfBlank((CharSequence)caiyunjianTask.getTaskDefineDO().getParameter(), (CharSequence)"")).trim(), (String)" ")).filter(p -> p.startsWith("--interval-")).filter(StringUtils::isNotBlank).findFirst().orElse("").split("-")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Integer intervalSeconds = CollectionUtils.size(intervalParameter) == 2 && ((String)intervalParameter.get(0)).equalsIgnoreCase("interval") && StringUtils.isNumeric((CharSequence)((CharSequence)intervalParameter.get(1))) ? Integer.parseInt((String)intervalParameter.get(1)) : 180;
        this.datasourceMap.values().stream().filter(ds -> Objects.equals(ds.getId(), setting.getDatasourceId())).findFirst().ifPresent(ds -> {
            try {
                String path = DateParser.parse((String)Joiner.on((String)File.separator).join((Iterable)Stream.of((String)StringUtils.defaultIfBlank((CharSequence)ds.getRootPath(), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)setting.getPath(), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)setting.getFileName(), (CharSequence)"")).filter(StringUtils::isNotBlank).collect(Collectors.toList())));
                String stopAt = Optional.ofNullable(this.properties).map(prop -> prop.getProperty("workflow.converter.detectTask.stopAt")).orElse("2350");
                String params = Joiner.on((String)" ").join((Object)StringUtils.defaultIfBlank((CharSequence)ds.getName(), (CharSequence)"datasourceName"), (Object)path, new Object[]{intervalSeconds, stopAt});
                String code = IOUtils.toString((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("res/ftpcheck.sh")));
                dwNode.setParameter(params);
                dwNode.setCode(code);
                dwNode.setType(CodeProgramType.DIDE_SHELL.name());
            }
            catch (Exception e) {
                log.error("convert detect config error: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private void getNodeFolder(DwNode dwNode, CaiyunjianTask caiyunjianTask) {
        ModelTreeRoot modelTreeRoot = null;
        if (dwNode.getWorkflowRef() != null) {
            modelTreeRoot = FolderUtils.getModelTreeRoot((Workflow)dwNode.getWorkflowRef());
        }
        if (CollectionUtils.isNotEmpty((Collection)caiyunjianTask.getDirPath())) {
            List parts = caiyunjianTask.getDirPath().stream().filter(s -> !s.equalsIgnoreCase(dwNode.getName()) && StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(parts)) {
                dwNode.setFolder("/");
            } else {
                dwNode.setFolder(Joiner.on((String)"/").join(parts));
            }
        } else {
            dwNode.setFolder("/");
        }
        if (modelTreeRoot != null) {
            dwNode.setFolder(Joiner.on((String)"/").join((Object)modelTreeRoot.getRootKey(), (Object)IntlUtils.get((String)"CAI_YUN_JIAN").d("CAI_YUN_JIAN"), new Object[]{dwNode.getFolder().replaceFirst("^/", "")}));
        }
    }

    private DwWorkflow getWorkflow() {
        return this.getDefaultWorkflow("OLD_VERSION_WORKFLOW");
    }

    private DwWorkflow getDefaultWorkflow(String name) {
        if (this.dwWorkflowConcurrentMap.containsKey(name)) {
            return (DwWorkflow)this.dwWorkflowConcurrentMap.get(name);
        }
        DwWorkflow dwWorkflow = new DwWorkflow();
        dwWorkflow.setName(name);
        dwWorkflow.setScheduled(Boolean.TRUE);
        this.dwWorkflowConcurrentMap.putIfAbsent(name, dwWorkflow);
        return dwWorkflow;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

