/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.adf;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.FlowType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeInstanceModeType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRecurrenceType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRerunModeType;
import com.aliyun.dataworks.common.spec.domain.enums.TriggerType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecSubFlow;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.adf.AdfConf;
import com.aliyun.dataworks.migrationx.domain.adf.AdfPackage;
import com.aliyun.dataworks.migrationx.domain.adf.Pipeline;
import com.aliyun.dataworks.migrationx.domain.adf.Trigger;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfConverter {
    private static final Logger log = LoggerFactory.getLogger(AdfConverter.class);
    private final AdfPackage adfPackage;
    private final AdfConf adfConf;

    public AdfConverter(AdfPackage adfPackage, AdfConf adfConf) {
        this.adfPackage = adfPackage;
        this.adfConf = adfConf;
    }

    public List<SpecWorkflow> convert() throws Exception {
        List pipelines = this.adfPackage.getPipelines();
        Map triggers = this.adfPackage.getTriggers();
        if (CollectionUtils.isEmpty((Collection)pipelines)) {
            throw new RuntimeException("empty pipelines");
        }
        ArrayList<SpecWorkflow> flows = new ArrayList<SpecWorkflow>(pipelines.size());
        for (Pipeline pipeline : pipelines) {
            Trigger trigger = triggers.getOrDefault(pipeline.getName(), null);
            flows.add(this.toWorkflow(pipeline, trigger));
        }
        return flows;
    }

    private SpecWorkflow toWorkflow(Pipeline pipeline, Trigger trigger) throws NoSuchAlgorithmException {
        SpecWorkflow flow = new SpecWorkflow();
        String flowId = AdfConverter.generateId(pipeline.getName());
        flow.setId(flowId);
        flow.setName(pipeline.getName());
        flow.setScript(AdfConverter.getFlowSpecScript(pipeline));
        flow.setOutputs(this.getOutput(flowId, pipeline.getName()));
        flow.setType(FlowType.CYCLE_WORKFLOW.getLabel());
        this.setTrigger(flow, trigger);
        this.setFlowNodesAndDependencies(flow, pipeline.getProperties().getActivities(), pipeline.getName());
        return flow;
    }

    private void setTrigger(SpecWorkflow flow, Trigger trigger) {
        if (trigger == null) {
            return;
        }
        SpecTrigger spec = new SpecTrigger();
        spec.setRecurrence(NodeRecurrenceType.NORMAL);
        flow.setTrigger(spec);
        if (trigger.getProperties() != null) {
            if ("ScheduleTrigger".equalsIgnoreCase(trigger.getProperties().getType())) {
                spec.setType(TriggerType.SCHEDULER);
            }
            Trigger.Recurrence recurrence = trigger.getProperties().getTypeProperties().getRecurrence();
            spec.setTimezone(recurrence.getTimeZone());
            spec.setStartTime(recurrence.getStartTime());
            spec.setCron(this.getCronFromConfig(trigger.getName()));
        }
    }

    private String getCronFromConfig(String name) {
        Map triggers = this.adfConf.getSettings().getTriggers();
        if (triggers.containsKey(name)) {
            return (String)triggers.get(name);
        }
        return null;
    }

    private void setFlowNodesAndDependencies(SpecWorkflow flow, List<Pipeline.PipelineProperty.Activity> activities, String pipelineName) throws NoSuchAlgorithmException {
        ArrayList<SpecNode> nodes = new ArrayList<SpecNode>(activities.size());
        flow.setNodes(nodes);
        ArrayList<SpecFlowDepend> specDepends = new ArrayList<SpecFlowDepend>();
        flow.setDependencies(specDepends);
        for (Pipeline.PipelineProperty.Activity activity : activities) {
            SpecNode node = new SpecNode();
            nodes.add(node);
            node.setName(activity.getName());
            node.setId(AdfConverter.generateId(pipelineName + activity.getName()));
            node.setDescription(activity.getDescription());
            node.setScript(AdfConverter.getNodeSpecScript(activity));
            node.setSubflow(this.getSubflow(activity));
            if ("Inactive".equalsIgnoreCase(activity.getState())) {
                node.setRecurrence(NodeRecurrenceType.SKIP);
            } else {
                node.setRecurrence(NodeRecurrenceType.NORMAL);
            }
            if (activity.getPolicy() != null) {
                if (activity.getPolicy().getRetry() != null && activity.getPolicy().getRetry() > 0) {
                    node.setRerunMode(NodeRerunModeType.ALL_ALLOWED);
                } else {
                    node.setRerunMode(NodeRerunModeType.ALL_DENIED);
                }
                node.setRerunTimes(activity.getPolicy().getRetry());
                node.setTimeout(Integer.valueOf(AdfConverter.toTimeoutInHours(activity.getPolicy().getTimeout())));
            }
            node.setOutputs(this.getOutput(node.getId(), node.getName()));
            node.setInstanceMode(NodeInstanceModeType.T_PLUS_1);
            List dependsOn = activity.getDependsOn();
            if (!CollectionUtils.isNotEmpty((Collection)dependsOn)) continue;
            SpecFlowDepend specDepend = new SpecFlowDepend();
            specDepend.setNodeId(node);
            specDepend.setDepends(new ArrayList(dependsOn.size()));
            specDepends.add(specDepend);
            for (Pipeline.PipelineProperty.Activity.DependActivity dependActivity : dependsOn) {
                SpecDepend depend = new SpecDepend();
                String id = AdfConverter.generateId(pipelineName + dependActivity.getActivity());
                SpecNode specNode = new SpecNode();
                specNode.setId(id);
                depend.setType(DependencyType.NORMAL);
                SpecNodeOutput output = new SpecNodeOutput();
                output.setData(id);
                output.setRefTableName(dependActivity.getActivity());
                depend.setOutput(output);
                specDepend.getDepends().add(depend);
            }
        }
    }

    private SpecSubFlow getSubflow(Pipeline.PipelineProperty.Activity activity) throws NoSuchAlgorithmException {
        if ("ExecutePipeline".equalsIgnoreCase(activity.getType())) {
            SpecSubFlow subFlow = new SpecSubFlow();
            String referencePipeline = activity.getTypeProperties().getPipeline().getReferenceName();
            String id = AdfConverter.generateId(referencePipeline);
            subFlow.setOutput(id);
            return subFlow;
        }
        return null;
    }

    @NotNull
    private static SpecScript getNodeSpecScript(Pipeline.PipelineProperty.Activity activity) {
        SpecScript script = new SpecScript();
        script.setPath(activity.getName());
        script.setContent(AdfConverter.getNodeContent(activity));
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        CodeProgramType command = AdfConverter.getCommand(activity.getType());
        runtime.setCommand(command.getName());
        runtime.setCommandTypeId(Integer.valueOf(command.getCode()));
        script.setRuntime(runtime);
        return script;
    }

    private static String getNodeContent(Pipeline.PipelineProperty.Activity activity) {
        String activityType = activity.getType();
        if ("DatabricksNotebook".equalsIgnoreCase(activityType)) {
            return activity.getTypeProperties().getNotebookPath();
        }
        if ("WebActivity".equalsIgnoreCase(activityType)) {
            return activity.getTypeProperties().getMethod() + " " + activity.getTypeProperties().getUrl();
        }
        if ("ExecutePipeline".equalsIgnoreCase(activityType)) {
            return null;
        }
        throw new RuntimeException("not supported activity type " + activityType);
    }

    @NotNull
    private static CodeProgramType getCommand(String activityType) {
        if ("DatabricksNotebook".equalsIgnoreCase(activityType)) {
            return CodeProgramType.ODPS_SQL;
        }
        if ("WebActivity".equalsIgnoreCase(activityType)) {
            return CodeProgramType.DIDE_SHELL;
        }
        if ("ExecutePipeline".equalsIgnoreCase(activityType)) {
            return CodeProgramType.SUB_PROCESS;
        }
        log.info("covert {} to dide_shell", (Object)activityType);
        return CodeProgramType.DIDE_SHELL;
    }

    public static int toTimeoutInHours(String timeStr) {
        Duration duration;
        int days;
        if (timeStr == null || timeStr.trim().isEmpty()) {
            return 12;
        }
        String[] dayAndTime = timeStr.split("\\.");
        if (dayAndTime.length != 2) {
            log.info("Invalid format. Expected format D.HH:MM:SS {}", (Object)timeStr);
            return 12;
        }
        try {
            days = Integer.parseInt(dayAndTime[0]);
        }
        catch (NumberFormatException e) {
            log.info("Invalid day value. {}", (Object)timeStr);
            return 12;
        }
        String timePart = dayAndTime[1];
        try {
            LocalTime lt = LocalTime.parse(timePart);
            duration = Duration.between(LocalTime.MIDNIGHT, lt);
        }
        catch (DateTimeParseException e) {
            log.info("Invalid time part. Expected format HH:MM:SS", (Throwable)e);
            return 12;
        }
        double totalHours = (double)(days * 24) + (double)duration.getSeconds() / 3600.0;
        return (int)totalHours;
    }

    @NotNull
    private static SpecScript getFlowSpecScript(Pipeline pipeline) {
        SpecScript script = new SpecScript();
        if (pipeline.getProperties() != null && pipeline.getProperties().getFolder() != null) {
            String folderPath = pipeline.getProperties().getFolder().getName();
            script.setPath(folderPath + "/" + pipeline.getName());
        } else {
            script.setPath(pipeline.getName());
        }
        SpecScriptRuntime specScriptRuntime = new SpecScriptRuntime();
        specScriptRuntime.setCommand("WORKFLOW");
        script.setRuntime(specScriptRuntime);
        return script;
    }

    public List<Output> getOutput(String id, String name) {
        SpecNodeOutput output = new SpecNodeOutput();
        output.setData(id);
        output.setArtifactType(ArtifactType.NODE_OUTPUT);
        output.setRefTableName(name);
        return ImmutableList.of((Object)output);
    }

    @NotNull
    private static String generateId(String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
        ByteBuffer buffer = ByteBuffer.wrap(hashBytes);
        long longValue = buffer.getLong();
        if (longValue == Long.MIN_VALUE) {
            return String.valueOf(Math.abs(buffer.getInt()));
        }
        return String.valueOf(Math.abs(buffer.getLong()));
    }
}

