/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.utils;

import com.aliyun.dataworks.common.spec.domain.enums.SpecFileResourceType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SpecFileResourceTypeUtils {
    private static final String PYTHON_SUFFIX = ".py";
    private static final String JAR_SUFFIX = ".jar";
    private static final String ARCHIVE_SUFFIX_ZIP = ".zip";
    private static final String ARCHIVE_SUFFIX_TAR = ".tar";
    private static final String ARCHIVE_SUFFIX_TGZ = ".tgz";
    private static final String ARCHIVE_SUFFIX_TAR_GZ = ".tar.gz";
    private static final String ARCHIVE_SUFFIX_NAR = ".nar";
    private static final Set<String> ARCHIVE_SUFFIX = new HashSet<String>(Arrays.asList(".zip", ".tar", ".tgz", ".tar.gz", ".nar"));

    public static SpecFileResourceType getResourceTypeBySuffix(String fileName) {
        int dotIndex = StringUtils.defaultString((String)fileName).lastIndexOf(46);
        if (dotIndex == -1) {
            return SpecFileResourceType.FILE;
        }
        String suffix = fileName.substring(dotIndex).toLowerCase();
        if (ARCHIVE_SUFFIX.contains(suffix) || StringUtils.defaultString((String)fileName).endsWith(ARCHIVE_SUFFIX_TAR_GZ)) {
            return SpecFileResourceType.ARCHIVE;
        }
        switch (suffix) {
            case ".py": {
                return SpecFileResourceType.PYTHON;
            }
            case ".jar": {
                return SpecFileResourceType.JAR;
            }
        }
        return SpecFileResourceType.FILE;
    }
}

