/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.transformer.core.translator.AbstractCommandSqlTranslator;
import com.aliyun.dataworks.migrationx.transformer.core.translator.NodePropertyTranslator;
import com.aliyun.dataworks.migrationx.transformer.core.translator.SparkSubmitTranslator;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateUtils {
    private static final Logger log = LoggerFactory.getLogger(TranslateUtils.class);
    private static final Set<Class<? extends NodePropertyTranslator>> TRANSLATORS;

    public static boolean translate(DwWorkflow workflow, DwNode node, List<Class<? extends NodePropertyTranslator>> translatorClasses, Supplier<CodeProgramType> nodeTypeSupplier) {
        AtomicBoolean changed = new AtomicBoolean(false);
        SetUtils.emptyIfNull(TRANSLATORS).stream().filter(clz -> ListUtils.emptyIfNull((List)translatorClasses).stream().anyMatch(clz::equals)).map(clz -> {
            try {
                return (NodePropertyTranslator)clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("{}", (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).filter(translator -> translator.match(workflow, node)).forEach(translator -> {
            try {
                log.debug("translator: {}, rawType: {}, targetType: {}", new Object[]{translator.getClass(), node.getType(), nodeTypeSupplier.get()});
                String rawType = node.getType();
                node.setType(((CodeProgramType)nodeTypeSupplier.get()).name());
                if (!translator.translate(workflow, node)) {
                    node.setType(rawType);
                } else {
                    changed.set(true);
                }
            }
            catch (ParseException e) {
                throw new BizException(ErrorCode.TRANSLATE_NODE_ERROR, new Object[0]).with(new Object[]{e});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return changed.get();
    }

    public static boolean translateSparkSubmit(DwNode node, Properties properties) {
        String sparkSubmitAs = properties.getProperty("workflow.converter.sparkSubmitAs", CodeProgramType.DIDE_SHELL.name());
        log.debug("sparkSubmitAs: {}", (Object)sparkSubmitAs);
        SparkSubmitTranslator translator = new SparkSubmitTranslator();
        if (translator.match((DwWorkflow)node.getWorkflowRef(), node)) {
            node.setType(sparkSubmitAs);
            return translator.translate((DwWorkflow)node.getWorkflowRef(), node);
        }
        return false;
    }

    public static boolean translateCommandSql(DwWorkflow workflow, DwNode node, Properties properties) {
        AtomicBoolean changed = new AtomicBoolean(false);
        Reflections reflections = new Reflections(AbstractCommandSqlTranslator.class.getPackage().getName(), new Scanner[0]);
        Set sqlTranslatorTypes = reflections.getSubTypesOf(AbstractCommandSqlTranslator.class);
        properties = properties == null ? new Properties() : properties;
        String targetType = properties.getProperty("workflow.converter.commandSqlAs", node.getType());
        log.debug("nodeType: {}, targetType: {}", (Object)node.getType(), (Object)targetType);
        SetUtils.emptyIfNull((Set)sqlTranslatorTypes).stream().map(clz -> {
            try {
                return (AbstractCommandSqlTranslator)clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("{}", (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).filter(translator -> translator.match(workflow, node)).forEach(translator -> {
            try {
                log.debug("translator: {}, rawType: {}, targetType: {}", new Object[]{translator.getClass(), node.getType(), targetType});
                String rawType = node.getType();
                node.setType(targetType);
                if (!translator.translate(workflow, node)) {
                    node.setType(rawType);
                } else {
                    changed.set(true);
                }
            }
            catch (ParseException e) {
                throw new BizException(ErrorCode.TRANSLATE_NODE_ERROR, new Object[0]).with(new Object[]{e});
            }
        });
        return changed.get();
    }

    public static boolean translateCommandSql(DwWorkflow workflow, DwNode node, String targetType) {
        AtomicBoolean changed = new AtomicBoolean(false);
        Reflections reflections = new Reflections(AbstractCommandSqlTranslator.class.getPackage().getName(), new Scanner[0]);
        Set sqlTranslatorTypes = reflections.getSubTypesOf(AbstractCommandSqlTranslator.class);
        log.debug("nodeType: {}, targetType: {}", (Object)node.getType(), (Object)targetType);
        SetUtils.emptyIfNull((Set)sqlTranslatorTypes).stream().map(clz -> {
            try {
                return (AbstractCommandSqlTranslator)clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("{}", (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).filter(translator -> translator.match(workflow, node)).forEach(translator -> {
            try {
                log.debug("translator: {}, rawType: {}, targetType: {}", new Object[]{translator.getClass(), node.getType(), targetType});
                String rawType = node.getType();
                node.setType(targetType);
                if (!translator.translate(workflow, node)) {
                    node.setType(rawType);
                } else {
                    changed.set(true);
                }
            }
            catch (ParseException e) {
                throw new BizException(ErrorCode.TRANSLATE_NODE_ERROR, new Object[0]).with(new Object[]{e});
            }
        });
        return changed.get();
    }

    static {
        Reflections reflections = new Reflections(NodePropertyTranslator.class.getPackage().getName(), new Scanner[0]);
        TRANSLATORS = reflections.getSubTypesOf(NodePropertyTranslator.class);
    }
}

