/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DICode;
import com.aliyun.dataworks.migrationx.transformer.core.translator.NodePropertyTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopToDITranslator
implements NodePropertyTranslator,
Reportable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqoopToDITranslator.class);
    private static final Pattern SQOOP_PATTERN = Pattern.compile("[\\s|\\n|\\t]*sqoop[\\s|\\n|\\t]+(import|IMPORT|export|EXPORT)[\\s|\\n|\\t]+");
    private static final Pattern SHELL_LINE_CONTINUATION_CHAR = Pattern.compile("[\\s|\\t]*\\\\[\\s|\\t]*");
    List<ReportItem> reportItems = new ArrayList<ReportItem>();

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        return this.checkNeedTranslate(node);
    }

    @Override
    public boolean translate(DwWorkflow workflow, DwNode node) {
        if (!this.match(workflow, node)) {
            return false;
        }
        DICode code = DICode.parseDiCode(this.extractSqoopCommand(node.getCode()));
        node.setCode(code.getCode());
        node.setType(CodeProgramType.DI.name());
        ReportItem reportItem = new ReportItem();
        reportItem.setWorkflow((Workflow)workflow);
        reportItem.setNode((Node)node);
        reportItem.setRiskLevel(code.getRiskLevel());
        reportItem.setAdvice(code.getAdvice());
        reportItem.setMessage(code.getMessage());
        reportItem.setType(ReportItemType.SQOOP_TO_DW_DI.getName());
        reportItem.setDescription(code.getDescription());
        reportItem.setName(String.format("%s: %s / :%s", SqoopToDITranslator.class.getSimpleName(), workflow.getName(), node.getName()));
        this.reportItems.add(reportItem);
        return true;
    }

    private String extractSqoopCommand(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        StringBuilder sqoopCmd = new StringBuilder();
        AtomicBoolean commandStarted = new AtomicBoolean(false);
        AtomicBoolean commandEnded = new AtomicBoolean(false);
        Arrays.stream(StringUtils.split((String)code, (char)'\n')).forEach(line -> {
            if (commandEnded.get()) {
                return;
            }
            if (!commandStarted.get() && SQOOP_PATTERN.matcher((CharSequence)line).find()) {
                sqoopCmd.append((String)line);
                commandStarted.set(true);
            }
            if (commandStarted.get()) {
                if (SHELL_LINE_CONTINUATION_CHAR.matcher((CharSequence)line).find()) {
                    sqoopCmd.append((String)line);
                } else if (StringUtils.isNotBlank((CharSequence)line)) {
                    sqoopCmd.append((String)line);
                    commandEnded.set(true);
                }
            }
        });
        return sqoopCmd.toString();
    }

    private boolean checkNeedTranslate(DwNode node) {
        if (node == null || StringUtils.isBlank((CharSequence)node.getCode())) {
            return false;
        }
        String code = node.getCode();
        Matcher matcher = SQOOP_PATTERN.matcher(code);
        return matcher.find();
    }

    @Override
    public List<ReportItem> getReport() {
        return this.reportItems;
    }
}

