/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.transformer.core.translator.AbstractCommandSqlTranslator;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCommandSqlTranslator
extends AbstractCommandSqlTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveCommandSqlTranslator.class);
    public static Pattern HIVE_PATTERN = Pattern.compile("[\\s|\\n|\\t]*hive[\\s|\\n|\\t]+.*");

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        return super.match(workflow, node) && StringUtils.contains((CharSequence)node.getCode(), (CharSequence)" -e ");
    }

    @Override
    protected Pattern getCommandPrefixPattern() {
        return HIVE_PATTERN;
    }

    @Override
    protected String getSqlOption() {
        return "e";
    }

    @Override
    protected Options getGnuOptions() {
        Options options = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"query");
        OptionBuilder.withDescription((String)"The query that should be executed");
        options.addOption(OptionBuilder.create((char)'e'));
        return options;
    }
}

